var p_paging_store = Ext.create('Ext.data.Store', {
    fields: ['value','name'],
    data: [[0,'-'],[5,'5'],[10,'10'],[20,'20'],[50,'50'],[100,'100'],[200,'200'],[500,'500'],[1000,'1000']]
});	
Ext.define("P5Jobhistory.view.JoblogGrids", {
    extend: 'Ext.grid.Panel',
    alias: "widget.jobloggrids",

    bind:{
        store: '{joblogstore}'
    },
    
    reference: 'jobloggrid_ref',
    itemId: 'jobloggrid_id',

    viewConfig: {
        loadMask: false,
        preserveScrollOnReload: true,
        preserveScrollOnRefresh: true
    },

    border: false,

    listeners: { itemdblclick: 'onOpenJobLogRow' },

    columns: [{
        xtype: 'actioncolumn',
        dataIndex: 'returnStr',
        align: 'center',
        text: '',
        menuDisabled : true,
        sortable: false,
        width: 30,
        renderer: function(value,metaData,record) {
            switch(value) {
                case 'TCL_OK':
                    metaData.tdCls = 'tcl-ok tcl-icon';
                    break;
                case 'TCL_ERROR':
                    metaData.tdCls = 'tcl-error tcl-icon';
                    break;
                case 'TCL_BREAK':
                    metaData.tdCls = 'tcl-break tcl-icon';
                    break;
                case 'TCL_WARNING':
                    metaData.tdCls = 'tcl-warning tcl-icon';
                    break;
                default:
                    metaData.tdCls = 'tcl-undefined tcl-icon';
            }
        },
        stopSelection: false,
        listeners: { click: 'onOpenJobLog' },
    },{
        dataIndex: 'jtype',
        align: 'center',
        text: '',
        menuDisabled : true,
        sortable: false,
        width: 22,
        renderer: function(value,metaData,record) {
            switch(value) {
                case 'archivejob':
                    metaData.tdCls = 'archivejob-icon';
                    break;
                case 'backupjob':
                    metaData.tdCls = 'backupjob-icon';
                    break;
                case 'backup2gojob':
                    metaData.tdCls = 'backup2gojob-icon';
                    break;
                case 'syncjob':
                    metaData.tdCls = 'syncjob-icon';
                    break;
                case 'migrationjob':
                    metaData.tdCls = 'migrationjob-icon';
                    break;
                case 'restorejob':
                    metaData.tdCls = 'restorejob-icon';
                    break;
                default:
                    metaData.tdCls = 'otherjob-icon';
            }
        }
    },{
        text: $$('Plan Name/Operation'),
        dataIndex: 'text',
        menuDisabled : true,
        sortable: false,
        width: 200,
    },{
        text: $$('Client'),
        dataIndex: 'client',
        menuDisabled : true,
        sortable: true,
        width: 80
    },{ 
        text: $$('User'),
        dataIndex: 'owner',
        menuDisabled : true,
        sortable: true,
        width: 80
    },{ 
        text: $$('Level'),
        dataIndex: 'level',
        menuDisabled : true,
        sortable: false,
        width: 60
    },{ 
        text: $$('Pool'),
        dataIndex: 'pool',
        menuDisabled : true,
        sortable: false,
        width: 80
    },{ 
        text: $$('Size'),
        dataIndex: 'numKbytes',
        menuDisabled : true,
        sortable: true,
        width: 80,
        renderer: eval('calcSizeIdx')
    },{ 
        text: $$('Start Time'),
        dataIndex: 'timeStarted',
        menuDisabled : true,
        sortable: true,
        width: 90,
        xtype: 'datecolumn',
        format: Ext.Date.patterns['formatTimeShort']
    },{ 
        text: $$('End Time'),
        dataIndex: 'timeCompleted',
        menuDisabled : true,
        sortable: true,
        width: 90,
        xtype: 'datecolumn',
        format: Ext.Date.patterns['formatTimeShort']
    },{ 
        text: $$('Duration'),
        dataIndex: 'duration',
        menuDisabled : true,
        sortable: false,
        width: 80,
        renderer: function(value,metaData) {
            return sec2min(value);
        }
    },{
        text: $$('Job'),
        dataIndex: 'name',
        menuDisabled : true,
        sortable: true,
        width: 80
    }],
    dockedItems: [{
        xtype: 'pagingtoolbar',
        bind: {store: '{joblogstore}'},
        dock: 'bottom',
        displayInfo: true,
        displayMsg: 'Displaying {0} - {1} of {2}',
        items: ['-', {
            xtype: 'combo',
            itemId: 'PerPageCombo',
            displayField: 'name',
            valueField: 'value',
            editable: false,
            queryMode: 'local',
            allowBlank: true,
            store: p_paging_store,
            width: 60,
            bind: {
                value: '{pageSize}'
            },
            margin: '0 10 0 10',
            listeners: {
                scope: this,
                select: function(combo, records, eOpts) {	
                    var pagingBar = combo.ownerCt;			
                    var log_store = pagingBar.getStore()
                    var pageSize  = combo.getValue()
                    Ext.state.Manager.set('pageSize',pageSize);
                    log_store.setPageSize(pageSize);
                    log_store.loadPage(1);
                }
            }
        },{ xtype: 'tbseparator' },{ xtype: 'tbtext', text: 'Items per page' }]
    }]
});
