//#############################################################################

//JavaScript Client Library

//See the file "license.txt" for information on usage and
//redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.


//#############################################################################

Ext.define("P5idx.view.IdxFilePickerViewModel", {
    extend: "Ext.app.ViewModel",
    alias: "viewmodel.idxfilepicker",

    requires:[
        'P5idx.model.IdxClient',
        'P5idx.model.IdxServerVolume',
        'P5idx.model.IdxFolderContent'
    ],

    stores: {
        clientstore: {
            type: 'tree', 
            model: 'P5idx.model.IdxClient',
            autoLoad: false
        },
        servervolumestore: {
            type: 'tree', 
            model: 'P5idx.model.IdxServerVolume',
            autoLoad: false,
            listeners: {
                beforeload: 'onVolumeStoreBeforeload',
                load: 'onVolumeStoreLoad'
            }
        },
        foldercontentstore: {
            type: 'tree', 
            model: 'P5idx.model.IdxFolderContent',
            autoLoad: false,
            sorters: [{
                property: 'leaf',
                direction: 'ASC'
            },{
                property: 'name',
                direction: 'ASC'
            }]
        }

    },

    formulas: {
        panelTitle: function (get) {
            return P5idx.AppType[P5idx.globals.AppType].panelTitle;
        },
        btnSelectEnable: function (get) {
            var selection = get('idxfoldercontentgrid_ref.selection');
            if ( selection ) {
                return false;
            } else {
                return true;
            }
        },
        btnSelectTxt: function (get) {
            return P5idx.AppType[P5idx.globals.AppType].btnSelectTxt;
        },
        btnSelectHandler: function (get) {
            return P5idx.AppType[P5idx.globals.AppType].btnSelectHandler;
        },
        btnHiddenP5Client: function (get) {
            return P5idx.AppType[P5idx.globals.AppType].btnHiddenP5Client;
        }
    }
});


