//#############################################################################

//JavaScript Client Library

//See the file "license.txt" for information on usage and
//redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.


//#############################################################################

console.log('Starting file picker');


Ext.define('P5idx.globals',{
    singleton : true,
    serverpage: document.urls.file_picker_fs.value,
    AppType: ''
});

Ext.define('P5idx.AppType.SyncTarget',{
    singleton : true,
    panelTitle: $$('Select Destination for data you want to copy'),
    multiSelect: false,
    btnSelectTxt: $$('Select Folder'),
    btnSelectHandler: 'onSelectedStart',
    callback: onCopyStart,
    sourceOfListing: '',
    selectedsource: '',
    selectedtarget: ''
});

Ext.define('P5idx.AppType.MigrationSource',{
    singleton : true,
    panelTitle: $$('Select a directory whose contents you want to transfer.'),
    multiSelect: false,
    btnSelectTxt: $$('Select Folder'),
    btnSelectHandler: 'onSelectedStart',
    callback: onReturnMigrationPath,
    returnform: '',
    returnfield: '',
    roottitle: '',
    elementurl: '',
    selectedpath: ''
});

Ext.define("P5idx.Application", {
    extend: "Ext.app.Application",
    name: "P5idx",
});

Ext.application({
    name: "P5idx",
    extend: "P5idx.Application",
	appFolder: '/lexxapp/file_picker_fs',
    views: ['IdxFilePicker'],
	requires: [ 
	    'P5idx.view.IdxFilePicker',
	    'P5idx.view.IdxFilePickerController',
	    'P5idx.view.IdxFilePickerViewModel'
	],
});
// FilePicker FilePicker FilePicker FilePicker FilePicker FilePicker
function prepareMigrationSource(address) {
    console.log(address.elementurl)
    var returnform = address.returnform;
    var returnfield = address.returnfield;
    var roottitle  = address.roottitle;
    var elementurl = address.elementurl;
    var me = this;
    popupHide()
    P5idx.globals.AppType = 'MigrationSource';
    P5idx.AppType[P5idx.globals.AppType].returnform  = returnform;
    P5idx.AppType[P5idx.globals.AppType].returnfield = returnfield;
    P5idx.AppType[P5idx.globals.AppType].roottitle  = roottitle;
    P5idx.AppType[P5idx.globals.AppType].elementurl = elementurl;
    idxFilePicker2()
}

// FilePicker FilePicker FilePicker FilePicker FilePicker FilePicker
function prepareCopyBySync(sourceOfListing) {
    var me = this;
    popupHide()
    P5idx.globals.AppType = 'SyncTarget';
    P5idx.AppType[P5idx.globals.AppType].sourceOfListing = sourceOfListing;
    if ( sourceOfListing == 'direct_copy' ) {
        console.log('prepareCopyBySync for direct_copy');
        getSelctedIndexItems()
        if ( numberElements == 0 ) {
            alert(document.msgForm.jsmsg1.value)
            return 0
        }
        P5idx.AppType[P5idx.globals.AppType].selectedsource = Ext.encode(selectedelements);
    } else if ( sourceOfListing == 'selection_copy' ) {
        console.log('prepareCopyBySync for selection_copy');
        // will process the copy with the session cached listing on server
        // see: session::get IndexSelections.$srcindex.$dbusage.$dboper
    }
    idxFilePicker()
}
// FilePicker Sync FilePicker Sync FilePicker Sync
function idxFilePicker() {
    var me = this;
    console.log('idxFilePicker');
    var fwin = Ext.ComponentQuery.query('#idxfilePicker_id')[0];
    if (!fwin) {
        fwin = myViewPort.add({
            xtype: 'idxfilePicker',
            itemId: 'idxfilePicker_id'
        });
    }
    fwin.show();
}
// FilePicker Migration FilePicker Migration FilePicker Migration
function idxFilePicker2() {
    var me = this;
    console.log('idxFilePicker2');
    var fwin = Ext.ComponentQuery.query('#idxfilePicker_id')[0];
    if (!fwin) {
        fwin = myViewPort.add({
            xtype: 'idxfilePicker2',
            itemId: 'idxfilePicker_id'
        });
    }
    fwin.show();
}
// Copy Copy Copy Copy Copy Copy Copy Copy Copy Copy 
function onCopyStart(selectedtarget) {
    var me = this;
    console.log('onCopyStart');
    Ext.Msg.show({
        title: $$('Confirmation'),
        message: $$('Do you really want to start the copy process?'),
        buttons: Ext.Msg.YESNO,
        buttonText:{ 
            yes: "Start Sync", 
            no: 'Cancel' 
        },
        icon: Ext.Msg.QUESTION,
        fn: function(btn) {
            if (btn == 'yes') {
                myViewPort.mask($$('Starting copy process ...'));
                Ext.Ajax.request({
                    url: document.urls.copy_by_sync.value,
                    method: 'POST',
                    params: { 
                        caller: 'ajaxStartCopySync',
                        sourceOfListing: P5idx.AppType[P5idx.globals.AppType].sourceOfListing,
                        selectedsource: P5idx.AppType[P5idx.globals.AppType].selectedsource,
                        selectedtarget: P5idx.AppType[P5idx.globals.AppType].selectedtarget
                    },
                    scope: this,
                    success: function(result, request) {
                        me.jobStatus = Ext.decode(result.responseText);
                        store_selection.load({params: {procedure: 'listing'}});
                        myViewPort.unmask();
                        if ( me.jobStatus.attention == 3 ) {
                            Ext.Msg.show({
                                title: $$('Information'),
                                message: me.jobStatus.message,
                                buttons: Ext.Msg.YESNO,
                                buttonText:{ 
                                    yes: "Job Monitor", 
                                    no: 'Close' 
                                },
                                icon: Ext.Msg.INFO,
                                fn: function(btn) {
                                    if (btn == 'yes') { jobMonitor(); }
                                }
                            })
                        } else {
                            extAlert(me.jobStatus.attention,me.jobStatus.message);
                        }
                    },
                    failure: function(result, request) {
                        Ext.MessageBox.alert('Failed', result.responseText);
                        myViewPort.unmask();
                    }
                });
            }
        }
    })
}
// Return Path - Return Path - Return Path - Return Path - Return Path - Return Path
function onReturnMigrationPath() {
    var me = this;
    console.log('onReturnMigrationPath');
    var path  = P5idx.AppType[P5idx.globals.AppType].selectedpath;
    var form  = P5idx.AppType[P5idx.globals.AppType].returnform;
    var field = P5idx.AppType[P5idx.globals.AppType].returnfield;
    var ifrm  = document.getElementsByName("migrateframe1")[0]
    var doc   = ifrm.contentDocument? ifrm.contentDocument: ifrm.contentWindow.document;
    doc.forms[form][field].value = path;
 }
