Ext.define('Dashboard.view.widget.WelcomeScreen', {
    extend: 'Ext.panel.Panel',
    xtype: 'welcome-screen-widget',
    
    requires: [
        'Dashboard.view.widget.WelcomeScreenModel',
        'Dashboard.view.widget.WelcomeScreenController'
    ],
    
    controller: 'welcome-screen',
    viewModel: {
        type: 'welcome-screen'
    },
    
    layout: {
        type: 'vbox',
        align: 'center',
        pack: 'center'
    },
    
    bodyStyle: {
        backgroundColor: '#f5f5f5'
    },

    initComponent: function() {
        var me = this;
        var isLicensed = !!+document.dashboardForm.isLicensed.value;
        var hasBackup  = !!+document.dashboardForm.hasBackup.value;
        var hasSync    = !!+document.dashboardForm.hasSync.value;
        var hasArchive = !!+document.dashboardForm.hasArchive.value;
        var isAdmin    = !!+document.dashboardForm.isAdmin.value;
    
        if (!isLicensed) {
            me.items = [{
                xtype: 'container',
                layout: {
                    type: 'vbox',
                    align: 'center'
                },
                items: [{
                    xtype: 'component',
                    html: '<div class="t30" style="text-align:center;margin-bottom:30px">Welcome to Archiware P5</div>'
                }, {
                    xtype: 'component',
                    html: '<div class="t15dark" style="text-align:center;margin-bottom:20px">Please enter a trial or a purchased license.</div>'
                }, {
                    xtype: 'image',
                    src: 'img4/license_64.png',
                    width: 64,
                    height: 64,
                    margin: '0 0 20 0'
                }, {
                    xtype: 'button',
                    text: 'Enter License',
                    handler: 'onEnterLicense',
                    scale: 'medium',
                    minWidth: 120
                }]
            }]        
        } else {
            me.items = [{
                xtype: 'container',
                padding: '10 0 20 0',
                items: [{
                    xtype: 'component',
                    html: '<div class="t30" style="text-align:center;margin-bottom:30px">Welcome to Archiware P5</div>'
                }, {
                    xtype: 'component',
                    html: '<div class="t15dark" style="text-align:center;margin-bottom:30px">Please configure one or more licensed P5 services.</div>'
                }]
            }, {
                xtype: 'container',
                layout: {
                    type: 'hbox',
                    pack: 'center',
                    align: 'stretch'
                },
                defaults: {
                    margin: '0 0',
                    width: 180
                },
                items: (function() {
                    var serviceItems = [];
                    if (hasBackup && isAdmin) {
                        var cls      = "service-card"
                        var nxtEvent = "MenuSwitchToolbar('backup')";
                        var imgClass = "backup_64";
                        var hdlClass = "t18";
                        var txtClass = "t14gray";
                    } else {
                        var cls      = "service-card-d"
                        var nxtEvent = "return false";
                        var imgClass = "backup_64_d";
                        var hdlClass = "t18d";
                        var txtClass = "t14dgray";
                    }
                    serviceItems.push({
                        xtype: 'container',
                        cls: `${cls}`,
                        html: `<div class="showBox140" onclick="${nxtEvent}">
                                <div class="${imgClass}"></div>
                                <div style="margin-top: 12px;text-align: center">
                                <div class="${hdlClass}">P5 Backup</div>
                                <div class="${txtClass}">Back up server data to disk and tape</div>
                                </div>`,
                        listeners: {
                            click: {
                                element: 'el',
                                fn: 'onBackupClick'
                            }
                        }
                    });
                    if (hasSync && isAdmin) {
                        var cls      = "service-card"
                        var nxtEvent = "MenuSwitchToolbar('synchronize')";
                        var imgClass = "synchronize_64";
                        var hdlClass = "t18";
                        var txtClass = "t14gray";
                    } else {
                        var cls      = "service-card-d"
                        var nxtEvent = "return false";
                        var imgClass = "synchronize_64_d";
                        var hdlClass = "t18d";
                        var txtClass = "t14dgray";
                    }
                    serviceItems.push({
                        xtype: 'container',
                        cls: `${cls}`,
                        html: `<div class="showBox140" onclick="${nxtEvent}">
                                <div class="${imgClass}"></div>
                                <div style="margin-top: 12px;text-align: center">
                                <div class="${hdlClass}">P5 Synchronize</div>
                                <div class="${txtClass}">Clone data to ensure high-availablity</div>
                                </div>`,
                        listeners: {
                            click: {
                                element: 'el',
                                fn: 'onBackupClick'
                            }
                        }
                    });
                    if (hasArchive && isAdmin) {
                        var cls      = "service-card"
                        var nxtEvent = "MenuSwitchToolbar('archive')";
                        var imgClass = "archive_64";
                        var hdlClass = "t18";
                        var txtClass = "t14gray";
                    } else {
                        var cls      = "service-card-d"
                        var nxtEvent = "return false";
                        var imgClass = "archive_64_d";
                        var hdlClass = "t18d";
                        var txtClass = "t14dgray";
                    }
                    serviceItems.push({
                        xtype: 'container',
                        cls: `${cls}`,
                        html: `<div class="showBox140" onclick="${nxtEvent}">
                                <div class="${imgClass}"></div>
                                <div style="margin-top: 12px;text-align: center">
                                <div class="${hdlClass}">P5 Archive</div>
                                <div class="${txtClass}">Migrate data from disk to tape or cloud</div>
                                </div>`,
                        listeners: {
                            click: {
                                element: 'el',
                                fn: 'onBackupClick'
                            }
                        }
                    });
                    return serviceItems;
                })()
            },{
                xtype: 'component',
                hidden: !!+document.dashboardForm.isAdmin.value,
                margin: '20 0 0 0',
                html: '<div style="text-align:center; margin-top:20px">'+
                      '<div class="t14gray">Note: Only users with administrative rights can access these settings</div>'+
                  '</div>'
            }];
        }
        me.callParent();
    }
});