//#############################################################################

//LTFSPanelViewModel.js

//JavaScript Client Library

//See the file "license.txt" for information on usage and
//redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.


//#############################################################################

Ext.define("P5LTFS.view.LTFSPanelViewModel", {
    extend: "Ext.app.ViewModel",
    alias: "viewmodel.ltfspanel",


    requires:[
        'P5LTFS.model.LTFSlocation',
        'P5LTFS.model.LTFSserverVolume',
        'P5LTFS.model.LTFSArchiveIndex',
        'P5LTFS.model.LTFSfolderContent',
        'P5LTFS.model.LTFSclient'
    ],

    data:{
        filepickerTitle: $$('Select data'),
        writedialogTitle: $$('Write to an LTFS tape'),
        showP5Client: true,
        showNewFolder: true,
        showArchiveIndex: true,
        showMonitor: false,
        multiSelect: false,
        selectText: $$('Select'),
        selectHandler: false,
        selectedsource: "",
        volumeType: "",
        volumePath: ""      
    },

    stores: {
        ltfsstore: {
            model: 'P5LTFS.model.LTFSlocation',
            autoLoad: true,
            groupField: 'groupby',
            listeners: {
                load: 'onLTFSStoreLoad'
            },
            sorters: [{
                property: 'sortorder',
                direction: 'ASC'
            },{
                property: 'id',
                direction: 'ASC'
            }]
        },
        clientstore: {
            type: 'tree', 
            model: 'P5LTFS.model.LTFSclient',
            autoLoad: true
        },
        servervolumestore: {
            type: 'tree', 
            model: 'P5LTFS.model.LTFSserverVolume',
            autoLoad: false,
            listeners: {
                beforeload: 'onVolumeStoreBeforeload',
                load: 'onVolumeStoreLoad'
            }
        },
        archiveindexstore: {
            type: 'tree', 
            model: 'P5LTFS.model.LTFSArchiveIndex',
            autoLoad: false,
            listeners: {
                beforeload: 'onVolumeStoreBeforeload',
                load: 'onIndexStoreLoad'
            }
        },
        foldercontentstore: {
            type: 'tree', 
            model: 'P5LTFS.model.LTFSfolderContent',
            autoLoad: false,
            sorters: [{
                property: 'leaf',
                direction: 'ASC'
            },{
                property: 'name',
                direction: 'ASC'
            }]
        }
    },

    formulas: {
       enableSelect: function (get) {
            var selection = get('ltfsfoldercontentgrid_ref.selection');
            if ( selection ) {
                return false;
            } else {
                return true;
            }
        },
        enableP5Client: function (get) {
            var showP5Client = get('showP5Client');
            if ( showP5Client ) {
                return false;
            } else {
                return true;
            }
        },
        enableNewFolder: function (get) {
            var showNewFolder = get('showNewFolder');
            if ( showNewFolder ) {
                return false;
            } else {
                return true;
            }
        },
        enableArchiveIndex: function (get) {
            var showArchiveIndex = get('showArchiveIndex');
            if ( showArchiveIndex ) {
                return false;
            } else {
                return true;
            }
        },
        enableMonitor: function (get) {
            var showMonitor = get('showMonitor');
            if ( showMonitor ) {
                return false;
            } else {
                return true;
            }
        },
        enableReadWriteButton: {
            bind: '{drive_slot_grid_ref.selection}',
            get:function(src) {
                return ( src && (src.data.state == "occupied" || src.data.state == "mounted") ) ? false : true
            }
        },
        enableMountButton: {
            bind: '{drive_slot_grid_ref.selection}',
            get:function(src) {
                return ( src && src.data.state == "occupied" ) ? false : true
            }
        },
        enableUnmountButton: {
            bind: '{drive_slot_grid_ref.selection}',
            get:function(src) {
                return ( src && src.data.state == "mounted" ) ? false : true
            }
        },
        enableLabelButton: {
            bind: '{drive_slot_grid_ref.selection}',
            get:function(src) {
                return ( src && src.data.state == "occupied" ) ? false : true
            }
        },
        enableCheckButton: {
            bind: '{drive_slot_grid_ref.selection}',
            get:function(src) {
                return ( src && src.data.state == "occupied" ) ? false : true
            }
        },
        enableMoveButton: {
            bind: '{drive_slot_grid_ref.selection}',
            get:function(src) {
                return ( src && src.data.jbpos != "" && src.data.state == "occupied" ) ? false : true
            }
        }
    }
});
