Ext.define('Dashboard.view.widget.DriveSpeedController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.drive-speed',
 
    init: function() {
        var historyStore = this.getViewModel().getStore('speedHistory');
        var now = new Date();
        
        // 20 empty records for the last 20 seconds
        for (var i = 30; i > 0; i--) {
            historyStore.add({
                dayTime: new Date(now.getTime() - (i * 1000)),
                speed: 0
            });
        }

        var drivesStore = this.getViewModel().getStore('drives');
        drivesStore.on('load', function(store) {
            var combo = this.lookupReference('driveSelector');
            var all   = store.findRecord('driveId', 'all');
            if (all) {
                combo.fireEvent('select', combo, all);
            }
            // Update-Prozess starten
            this.startDataUpdate();
        }, this);
    },
        
    startDataUpdate: function() {
        var me = this;
        this.updateTask = Ext.TaskManager.start({
            run: function() {
                if (Dashboard.globals.attention) return false;
                Ext.Ajax.request({
                    url: document.dashboardForm.startTdp.value,
                    params: {
                        caller: 'ajaxDriveSpeed',
                        driveId: me.getViewModel().get('selectedDriveId'),
                        demoMode: localStorage.getItem('demoMode') === 'true'
                    },
                    success: function(response) {
                        var data = Ext.JSON.decode(response.responseText);
                        if (data.success) {
                            me.addSpeedData(data.data);
                        }
                    },
                    scope: me
                });
            },
            interval: 1000,
            scope: me
        });
    },
 
    addSpeedData: function(data) { 
        if (!data || !data.length) return;
        var historyStore = this.getViewModel().getStore('speedHistory');
        var chart = this.lookupReference('chart_ref');
        var yAxisL = chart.getAxes()[0];
        var yAxisR = chart.getAxes()[1];
        var currentSpeed = data[0].currentSpeed;
        var currentMax = yAxisL.getMaximum();
        // Adjust scale upwards only
        if (currentSpeed > currentMax) {
            // Round up to the nearest 100
            var newMax = Math.ceil(currentSpeed / 100) * 100;
            yAxisL.setMaximum(newMax);
            yAxisR.setMaximum(newMax);
        }

        historyStore.add({
            dayTime: new Date(data[0].date * 1000),
            speed: currentSpeed
        });
        
        // Limit history to 30 seconds
        while (historyStore.getCount() > 30) {
            historyStore.removeAt(0);
        }
    },
    
    onSelectedDriveChange: function(combo, record) {
        var driveId = record.get('driveId');
        var drivesStore = this.getViewModel().getStore('drives');
        var chart  = this.lookupReference('chart_ref');
        var yAxisL = chart.getAxes()[0];
        var yAxisR = chart.getAxes()[1];
        var drive  = drivesStore.findRecord('driveId', driveId);
        // set default y-value
        if (drive) {
            yAxisL.setMaximum(drive.get('maxSpeed'));
            yAxisR.setMaximum(drive.get('maxSpeed'));
        }
    },
 
    onTooltipRender: function(tooltip, record) {
        tooltip.setHtml('Speed: ' + record.get('speed') + ' MB/s');
    },
 
    onDestroy: function() {
        if (this.updateTask) {
            Ext.TaskManager.stop(this.updateTask);
        }
        this.callParent();
    }
 });