#!/bin/sh
#
# Maintenance script used to update (stop, update and start)
# the current P5 server/distribution.
#
# NOTE: DO NOT RUN THIS SCRIPT BY HAND.
#
# See the file "license.txt" for information on usage and
# redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
# ----------------------------------------------------------------------
#

#
# Override locale settings
#

LANG="en_US.UTF-8";export LANG

#
# Bark if not root
#

my=`/usr/bin/id`
id=`expr "$my" : 'uid=\([0-9]*\)'`
if test $id -ne 0; then
    exit 100
fi

#
# Get home directory and place ourselves
# in the parent, as this should be the
# distribution root.
#

dir=`dirname "$0"`
cwd=`pwd`; cd "$dir"
dir=`pwd`
cd "$dir/../"

#
# Stop the server first.
#

if test $# -eq 0; then
    ./stop-server 1>/dev/null 2>&1
fi

#
# See if any update file seeded. If yes unpack the file,
# overwriting the current distro.
#

uf=./temp/awpst-upd.tgz
if test -f $uf -a -O $uf ; then
    tar xf $uf
    rm -rf $uf
fi

#
# Now, start the server again.
#

if test $# -eq 0; then
    ./start-server 1>/dev/null 2>&1
fi

cd "$cwd"
exit 0

# EOF
