Ext.define('Override.form.field.VTypes', {
    override: 'Ext.form.field.VTypes',

    LTFSserial:  function(value) {
        return this.LTFSserialRe.test(value);
    },
    LTFSserialRe: /^([A-Z0-9]{6,6})$/,
    LTFSserialText: $$('Either empty or exact 6 alphanumeric characters. (A–Z, 0–9)'),
    LTFSserialMask: /[A-Z0-9]/i
});
Ext.define('Override.form.field.VTypes', {
    override: 'Ext.form.field.VTypes',

    LTFSname:  function(value) {
        return this.LTFSnameRe.test(value);
    },
    LTFSnameRe: /^[^:*?<>"|/\\;]*$/,
    LTFSnameText: $$('For platform compatibility reason the following character are not valid:') + ' * ? < > " | / \ ; :',
    LTFSnameMask: /[^:*?<>"|/\\;]/i
});

Ext.define('P5LTFS.view.LTFSlabel', {
    extend: 'Ext.window.Window',
    alias: 'widget.ltfslabel',

	height: 380,
	width: 600,
	border: true,
    layout: 'fit',
	closeAction: 'hide',
	modal: true,

    title: $$('Create a Linear Tape File System (LTFS)'),

    defaults: {
        border:false
    },
    items: [{
        xtype: 'form',
        itemId: 'ltfslabelform_id',
        items: [{
            xtype: 'container',
            margin: '20 0 0 20',
            html: $$('Before an LTO tape can be written in LTFS format, it must be formatted and mounted.')
        },{
            xtype: 'fieldcontainer',
            margin: '20 0 0 40',
            layout: 'hbox',
            items: [{
                xtype: 'displayfield',
                margin: '0 5 0 0',
                value: $$('Volume Name')+':'
            },{
                xtype: 'textfield',
                name: 'voln',
                hideLabel: true,
                vtype: 'LTFSname',
                width: 250
            }/*,{
                xtype: 'displayfield',
                margin: '0 5 0 40',
                value: $$('Serial Number')+':'
            },{
                xtype: 'displayfield',
                margin: '0 0 0 5',
                value: $$('e.g. ABC123')
            }*/]
        },{
            xtype: 'radio',
            margin: '10 0 0 58',
            name: 'exception',
            inputValue: '-noerase',
            checked: true,
            boxLabel: $$('Blank tapes only')
        },{
            xtype: 'radio',
            margin: '0 0 0 58',
            name: 'exception',
            inputValue: '-erase',
            boxLabel: $$("Reformat tape (<b>Attention:</b> all existing data gets lost!)")
        },{
            xtype: 'container',
            margin: '20 0 0 40',
            html: $$('<b>Note:</b> Creating a Linear Tape File System (LTFS) may take a while.')
        }]
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
		ui: 'footer',
        layout: { pack: 'start' },
        defaults: {
            xtype : 'button',
            padding: '5 15 5 15'
        },
        items: [{ xtype: 'tbfill' },{
            xtype: 'button',
            text: $$('Cancel'),
            handler: function() {
                this.up().up().close();
            }
        },{
            xtype: 'button',
            handler: 'onCreateFS',
            text: $$('Create File System')
        },{ 
            xtype: 'tbspacer',
            width: 10
        }]
	}]        
});

Ext.define('P5LTFS.view.LTFSUnmount', {
    extend: 'Ext.window.Window',
    alias: 'widget.ltfsunmount',

	height: 200,
	width: 350,
	border: true,
    layout: 'fit',
	closeAction: 'hide',
	modal: true,

    title: $$('Unmount LTFS tape'),

    defaults: {
        border:false
    },
    items: [{
        xtype: 'form',
        itemId: 'ltfsunmountform_id',
        items: [{
            xtype: 'container',
            margin: '20 0 0 30',
            html: $$('Where do you want to unload the tape?')
        },{
            xtype: 'radio',
            margin: '10 0 0 40',
            name: 'unloadTo',
            inputValue: 'originslot',
            boxLabel: $$('To origin slot'),
            checked: true,
        },{
            xtype: 'radio',
            margin: '5 0 0 40',
            name: 'unloadTo',
            inputValue: 'mailslot',
            boxLabel: $$('To mailslot'),
        }]
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
		ui: 'footer',
        layout: { pack: 'start' },
        defaults: {
            xtype : 'button',
            padding: '5 15 5 15'
        },
        items: [{ xtype: 'tbfill' },{
            xtype: 'button',
            text: $$('Cancel'),
            handler: function() {
                this.up().up().close();
            }
        },{
            xtype: 'button',
            handler: 'onUnmountStart',
            text: $$('Unmount')
        }]
	}]        
});