//#############################################################################

//JavaScript Client Library

//See the file "license.txt" for information on usage and
//redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.


//#############################################################################

Ext.define("P5idx.view.IdxFilePickerController", {
    extend: "Ext.app.ViewController",
    alias: "controller.idxfilepicker",

    init: function() {
 		var me = this;
        me.control({
            '#idxclienttabpanel_id': {
                viewready: function(a,b,c) {
                    me.getStore('clientstore').load();
                },
                select: me.onClientSelect
            },
            '#idxservervolumegrid_id': {
                viewready: function(a,b,c) {
                    me.getStore('servervolumestore').load();
                },
                select: me.onServervolumeSelect
            },
            '#idxfoldercontentgrid2_id': {
                viewready: function(a,b,c) {
                    var me = this;
                    console.log('onServerSingleVolumeSelect');
                    var folder_store = me.getStore('foldercontentstore');
		            folder_store.removeAll();
		            folder_store.setRootNode({});
		            folder_store.loadData([],false);
                    folder_store.proxy.extraParams.multiSelect = P5idx.AppType[P5idx.globals.AppType].multiSelect;
                    var newRoot = {
                        expanded: true,
                        nodes: [{
                            name: P5idx.AppType[P5idx.globals.AppType].roottitle,
                            id: P5idx.AppType[P5idx.globals.AppType].elementurl,
                            path: "/",
                            iconCls: 'leafIcon_Dir',
                            expanded: true
                        }]
                    }
                    folder_store.setRootNode(newRoot);           
                }
            }
		});
    },
    onWriteClientToggel: function(obj) {
        me = this;
        console.log('onWriteClientToggel');
        var clientregion = Ext.ComponentQuery.query('#idxclienttabpanel_id')[0];
        clientregion.toggleCollapse();                
    },
    onClientSelect: function(view, record, item, index, event) {
		var me = this;
		console.log('onClientSelect: '+record.data.name);
        var volume_store = me.getStore('servervolumestore');
		volume_store.removeAll();
		volume_store.proxy.extraParams.hostname = record.data.name;
        volume_store.load();
    },
    onServervolumeSelect: function(view, record, item, index, event) {
		var me = this;
        console.log('onServervolumeSelect');
        var folder_store = me.getStore('foldercontentstore');
		folder_store.removeAll();
		folder_store.setRootNode({});
		var newRoot = {
			expanded: true,
            nodes: [{
			    name: record.get('name'),
			    id: record.get('elementurl'),
			    path: record.get('path'),
    			iconCls: 'leafIcon_Dir',
			    expanded: true
            }]
		}
		folder_store.setRootNode(newRoot);           
    },
    onVolumeStoreBeforeload: function( store, records, successful, operation, node, eOpts) {
        me = this;
        console.log('onVolumeStoreBeforeload');
        var folder_store = me.getStore('foldercontentstore');
		folder_store.removeAll();
		folder_store.setRootNode({});
		folder_store.loadData([],false);
        folder_store.proxy.extraParams.multiSelect = P5idx.AppType[P5idx.globals.AppType].multiSelect;
    },
    onVolumeStoreLoad: function( store, records, successful, operation, node, eOpts) {
        me = this;
        console.log('onVolumeStoreLoad');
        var JSONdata = operation.getResponse().responseJson;
        // if set pre-select a volume
        if ( JSONdata.selected !== "" ) { 
            var tree = me.lookupReference('idxservervolumegrid_ref');
            var node = store.getNodeById(JSONdata.selected);
            if (node !== null && node !== undefined) {
                tree.getSelectionModel().select([node],0,0);
            }
        }
    },
    onSelectedStart: function(obj) {
		var me = this;
        console.log('onSelectedStart');
		selected = [];
        var picker = me.lookupReference('idxfoldercontentgrid_ref');
        var selection = picker.getView().getChecked();
		Ext.iterate(selection, function(obj, index) {
			var path = obj.get('id');
			selected.push(path);
		});
		if ( selected.length == 0 ) {
            var record = picker.getSelectionModel().getSelection()[0];
            var path = record.get('id');
            selected.push(path);
            P5idx.AppType[P5idx.globals.AppType].selectedpath = record.get('path');
        }
        P5idx.AppType[P5idx.globals.AppType].selectedtarget = Ext.encode(selected);
        P5idx.AppType[P5idx.globals.AppType].callback();
    	var panel = Ext.ComponentQuery.query('#idxfilePicker_id')[0];
        if (panel) panel.close();
    },
    onNewFolder: function(obj) {
		var me = this;
        console.log('onNewFolder');
        var picker = me.lookupReference('idxfoldercontentgrid_ref');
        var record = picker.getSelectionModel().getSelection()[0];
        if (record) {
            Ext.Msg.prompt($$('Name of new folder'), '', function(btn, foldername){
                if (btn == 'ok') {
                    var elementurl = record.get('id');
                    Ext.Ajax.request({
                        url: P5idx.globals.serverpage,
                        timeout: 600000,
                        method: 'POST',
                        params: { 
                            caller: 'ajaxNewFolder',
                            node: elementurl,
                            folder: foldername
                        },
                        scope: this,
                        success:function(response, options) {
                            var XMLdata = response.responseXML;
                            // try to fetch values for page status and message
                            var attention = DQ.selectValue('attention', XMLdata);
                            var message   = DQ.selectValue('message', XMLdata);
                            var newnode   = DQ.selectValue('newnode', XMLdata);
                            if (typeof attention == 'undefined') {
                                extAlert(1,$$('Server communication error. (Invalid XML message)'))
                            } else if (attention > 0 ) {
                                extAlert(attention,message)
                            }
                            if (attention == 0 ) {
                                var folder_store = me.getStore('foldercontentstore');
		                        record.removeAll();
                                folder_store.load({ 
                                    node: record,
                                    callback : function(records, operation, success){
                                        var rootNode  = picker.getRootNode();
                                        var newObj    = rootNode.findChild('id',newnode, true);
                                        newObj.parentNode.expand();
                                        picker.getSelectionModel().select(newObj);
                                    }
                                });
                            };
                        },
                        failure: function(){
                            extAlert(1,'Could not connect to server')
                        }
                    });
                };
            });
        } else {
            extAlert(2,'Please select the parent folder')
        }
    }
});
