Ext.define('Dashboard.view.widget.InstallationInfo', {
    extend: 'Ext.container.Container',
    xtype: 'installation-info-widget',
    
    requires: [
        'Dashboard.view.widget.InstallationInfoModel',
        'Dashboard.view.widget.InstallationInfoController'
    ],
    
    controller: 'installation-info',
    viewModel: {
        type: 'installation-info'
    },
    
    layout: {
        type: 'hbox',
        align: 'start'
    },
    
    items: [{
        xtype: 'component',
        reference: 'p5logo_ref',
        width: 165,
        style: {
            padding: '20px'
        },
        listeners: {
            element: 'el',
            click: 'activateDemoMode'
        },
        html: '<div class="p5_256"></div>'
    }, {
        xtype: 'grid',
        flex: 1,
        border: false,
        margin: '0 0 0 15', 
        hideHeaders: true,
        disableSelection: true,
        rowLines: false,
        bind: {
            store: '{installInfoFiltered}'
        },
        bodyStyle: {
            border: 'none'
        },
        columns: [{
            dataIndex: 'text',
            align: 'right',
            flex: 1,
            maxWidth: 200,
            minWidth: 130 
        }, {
            dataIndex: 'value',
            flex: 3,
            renderer: 'valueRenderer'     
        }]
    }]
});