Ext.define("P5LTFS.model.LTFSlocation", {
    extend: "Ext.data.Model",
    idProperty: "id",
    schema: {
        namespace: "P5LTFS.model"
    },

    fields: [{
        name: 'id',
        type: 'number'
    },{
        name: 'jbpos',
        type: 'string'
    },{
        name: 'location',
        type: 'string'
    },{
        name: 'drive',
        type: 'string'
    },{
        name: 'type',
        type: 'string'
    },{
        name: 'occupied',
        type: 'boolean'
    },{
        name: 'indrive',
        type: 'string'
    },{
        name: 'volid',
        type: 'number'
    },{
        name: 'barcode',
        type: 'string'
    },{
        name: 'ltfs_volname',
        type: 'string'
    },{
        name: 'p5used',
        type: 'number'
    },{
        name: 'ltfs_url',
        type: 'string'
    },{
        name: 'ltfs_pool',
        type: 'string'
    },{
        name: 'text',
        type: 'string'
    },{
        name: 'qtip',
        type: 'string'
    },{
        name: 'device',
        type: 'string'
    },{
        name: 'size',
        type: 'string'
    },{
        name: 'state',
        type: 'string'
    },{
        name: 'groupby',
        type: 'string'
    },{
        name: 'sortorder',
        type: 'string'
    }],
    proxy:{
        type:'ajax',
        url: document.dataForm.ltfs_config.value,
        actionMethods:{
             read:'GET'
        },
        extraParams: {
            caller: 'ajaxGetLTFSLocation'
        },
        reader:{
            type:'json',
            rootProperty:'data'
        }
    }
});
