Ext.define('Ext.override.form.field.CheckBox',{
    override : 'Ext.form.field.Checkbox',
    stateEvents : ['change'],

    getState: function () {
        var state = this.callParent(arguments) || {};
        if(this.getValue()) state = this.addPropertyToState(state, 'checked');

        return state;
    },
    applyState: function (state) {

        this.callParent(arguments);

        Ext.apply(this, state);
        if (this.checked) this.setValue(true);
    }
});

var jobresults = Ext.create('Ext.data.Store', {
    fields: ['id','name'],
    data: [
        {id:'any', 'name':'Any'},
        {id:'archivejob', 'name':'Archive'},
        {id:'backupjob', 'name':'Backup'},
        {id:'backup2gojob', 'name':'Backup2Go'},
        {id:'syncjob', 'name':'Synchronize'},
        {id:'migrationjob', 'name':'Migration'},
        {id:'restorejob', 'name':'Restore'},
        {id:'otherjob', 'name':'Others'}
    ]
});
Ext.define('P5Jobmanager.view.ConfigRegion', {
    extend: 'Ext.form.Panel',
    xtype: 'configregion',
    
    cls: 'configregion-panel checkbox-radio',
    bodyStyle:{"background-color":"#576170"}, 
    width: 150,

    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    
    items: [{
        xtype: 'checkboxfield',
        margin: '10 0 0 20',
        name: 'parkedjobs_chkbx',
        boxLabel: $$('Parked Jobs'),
        inputValue: 1,
        reference: 'parkedjobs_chkbx_ref',
        stateful : true,
        stateId: 'parkedjobs_stateId'
    },{
        xtype: 'container',
        html: $$('Monitor Jobs'),
        margin: '10 0 0 10'
    },{
        xtype: 'jobtypegrid',
        cls: 'filter-grid',
        reference: 'jobtypegrid_ref',
        itemId: 'jobtypegrid_id',
        margin: '5 0 0 15',
        border: false,
    },{
        xtype: 'container',
        html: $$('Client'),
        margin: '10 0 0 10'
    },{
        xtype: 'clientgrid',
        cls: 'filter-grid',
        reference: 'clientgrid_ref',
        itemId: 'clientgrid_id',
        margin: '5 0 0 15',
        height: 230,
        border: false,
    },{
        xtype: 'container',
        flex: 1,
    }/*,{
        xtype: 'checkboxfield',
        margin: '5 0 2 10',
        name: 'monitorLegacyView',
        boxLabel: $$('Legacy Job Monitor'),
        inputValue: 1,
        listeners: { change: 'onToggelLegacyView' },
        bind: {
            value: '{currentUseddrive.isdefault}'
        }
    }*/,{
        xtype: 'displayfield',
        margin: '0 0 0 13',
        bind: {
            value: '<span class="x-fa fa-clock" style="{clockStyle}"></span><span style="padding-right:3px;"> {servertime}</span>'
        },
        listeners: {
            afterrender: function(component) {
                component.getEl().on('click', 'startStopReload');  
            }
        }
    }]
});

Ext.define('P5Jobmanager.view.JobTypeGrid', {
    extend: 'Ext.grid.Panel',
    xtype: 'jobtypegrid',

    bodyStyle:{"background-color":"#576170"}, 
    
    store: jobresults,
    
    selModel: {
        selType: 'checkboxmodel',
        mode: 'SINGLE',
        allowDeselect: false
    },

    headerBorders: false,
    hideHeaders: true,
    rowLines: false,
    border: false,

    columns: [{
        dataIndex: 'name',
        text: $$('Name'),
        flex: 1,
        tdCls: 'vd-multiline-row'
    }]
});
Ext.define('P5Jobmanager.view.ClientGrid', {
    extend: 'Ext.grid.Panel',
    xtype: 'clientgrid',

    bind:{
        store: '{clientstore}'
    },
    
    selModel: {
        selType: 'checkboxmodel',
        mode: 'SINGLE',
        allowDeselect: false
    },

    headerBorders: false,
    hideHeaders: true,
    rowLines: false,
    border: false,

    columns: [{
        dataIndex: 'name',
        text: $$('Name'),
        flex: 1,
        tdCls: 'vd-multiline-row'
    }]
});