Ext.define('Dashboard.view.widget.InstallationInfoController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.installation-info',
 
    activateDemoMode: function(evt) {
        if ( evt.shiftKey ) {
            // Set cookie or localStorage
            localStorage.setItem('demoMode', 'true');
        } else {
            localStorage.setItem('demoMode', 'false');
        }
        window.location.reload();

    },

    valueRenderer: function(value, meta, record, rowIndex, colIndex, store) {
        if (record.get('color') !== '') {
            meta.style = 'color: ' + record.get('color') + '; font-size: 12px';
        }
        
        return value + this.getQuoteMailLink(record, store);
    },
    
    getQuoteMailLink: function(record, store) {
        if (record.get('color') === 'red') {
            const hostId = store.findRecord('param', 'hostid').get('value');
            const liclist = store.findRecord('param', 'licenses').get('value');
            const subject = 'Archiware Quote Request: ' + record.get('text') + ' for Host-ID ' + hostId;
            
            let body = 'Dear Archiware Team,\n\n' +
                       'Please provide a quote based on the following information:\n' +
                       'Warning: ' + record.get('text') + '\n' +
                       'Host-ID: ' + hostId + '\n' +
                       'Serial#: ' + liclist + '\n\n';
    
            if (record.get('param') === 'demo_expires' || record.get('param') === 'license_expires') {
                body += 'Please complete the questionnaire below:\n' +
                       '------------------------------------------------\n' +
                       'Required Modules (please select):\n' +
                       'P5 Backup: [Yes/No]\n' +
                       'P5 Archive: [Yes/No]\n' +
                       'P5 Synchronize: [Yes/No]\n\n' +
                       'Hardware Configuration (please specify):\n' +
                       'Number of LTO drives: [     ]\n' +
                       'Tape Library: [Yes/No]\n' +
                       '  If Yes, number of slots: [     ]\n' +
                       'Backup/Archive to Cloud/Disk: [Yes/No]\n' +
                       '  If Yes, planned data volume: [     ]\n\n' +
                       'Contact Information (please fill in):\n' +
                       'Company Name:\n' +
                       'Contact Person:\n' +
                       'Address Line 1:\n' +
                       'Address Line 2:\n' +
                       'City:\n' +
                       'State/Province:\n' +
                       'ZIP/Postal Code:\n' +
                       'Country:\n\n';
            }
            
            body += 'Best Regards\n' +
                    '[Your Name]';
            
                    return ' <a href="mailto:team@archiware.com?' + 
                    'subject=' + encodeURIComponent(subject) + 
                    '&body=' + encodeURIComponent(body) + 
                    '" class="quote-link" style="margin-left:10px"' +
                    ' data-qtip="This will open an email with installation details to request a quote from Archiware.<br>Please fill it out and submit.">' + 
                    '<span class="fas fa-envelope"></span> Get a Quote</a>';
     
        }
        return '';
     }
 });