Ext.define('Dashboard.view.widget.CloudDiskUsage', {
    extend: 'Ext.panel.Panel',
    xtype: 'clouddisk-usage-widget',
    
    requires: [
        'Dashboard.view.widget.CloudDiskUsageModel',
        'Dashboard.view.widget.CloudDiskUsageController'
    ],
    
    controller: 'clouddisk-usage',
    viewModel: {
        type: 'clouddisk-usage'
    },

    layout: 'fit',
    
    items: [{
        xtype: 'dataview',
        bind: {
            store: '{storageData}'
        },
        itemSelector: 'div.storage-tile',
        tpl: new Ext.XTemplate(
            '<div class="storage-container">',
            '<tpl for=".">',
                '<div class="storage-tile">',
                    '<div class="storage-header">',
                        '<i class="fas {[values.storageType === "cloud" ? "fa-cloud" : "fa-hdd"]} cloud-icon" style="color: {[values.usage === "Backup" ? "#8c8cd9" : "#ffcc33"]};"></i>',
                        '<div class="title">{poolName}</div>',
                    '</div>',
                    '<div class="storage-size">{[this.formatSize(values.usedCapacityKiB)]}</div>',
                    '<div class="storage-date">Last written: {[Ext.util.Format.date(values.lastUpdate, "M d, Y")]}</div>',
                '</div>',
            '</tpl>',
            '<div class="info-text">Showing pools with write activity in the last 4 weeks</div>',
        '</div>',
            {
                formatSize: function(size) {
                    return CalcSize(size);
                }
            }
        ),
        scrollable: true,
        style: {
            backgroundColor: '#f5f5f5',
            padding: '10px'
        }
    }]
});