Ext.define('Dashboard.view.widget.ArchiveStatsController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.archive-stats',
    
    onPeriodChange: function(segButton, button, pressed) {
        if (pressed) {
            var days = button.value;
            var planSelector = this.lookupReference('planSelector');
            var planId = planSelector ? planSelector.getValue() : 'all';
    
            var store = this.getViewModel().getStore('archiveStats');
            store.proxy.extraParams.days = days;
            store.proxy.extraParams.planId = planId;
            store.load();
        }
    },

    onPlanChange: function(combo, record) {
        var planId = record.get('planId');
        var periodButton = this.lookupReference('periodToggle_ref').items.findBy(function(item) {
            return item.pressed;
        });
        var days = periodButton ? periodButton.value : 7;  // Default 7 wenn nichts selektiert
    
        var store = this.getViewModel().getStore('archiveStats');
        store.load();
        store.proxy.extraParams.days = days;
        store.proxy.extraParams.planId = planId;
    }
});