Ext.define('Dashboard.view.widget.ArchiveOverviewController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.archive-overview-widget',
    
    onPeriodChange: function(segmentedButton, button, pressed) {
        if (pressed) {
            var store = this.getViewModel().getStore('archiveOverview');
            store.getProxy().setExtraParam('period', button.value);
            store.load();
        }
    },

    onCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e) {
        var me = this;
        var target = e.getTarget();
        
        if (target && target.hasAttribute('data-action')) {
            var action = target.getAttribute('data-action');
            
            switch (action) {
                case 'view-job':
                    var jobId = target.getAttribute('data-jobid');
                    me.viewJob(jobId);
                    break;
                case 'view-client':
                    var clientName = target.getAttribute('data-name');
                    me.viewClient(clientName);
                    break;
                case 'view-pool':
                    var poolName = target.getAttribute('data-name');
                    me.viewPool(poolName);
                    break;
            }
        }
        
        // Wenn auf den "more dirs" Eintrag geklickt wurde, zeige alle Verzeichnisse an
        if (target && target.className === 'more-dirs') {
            var dirs = record.get('dirlist');
            Ext.Msg.show({
                title: 'Archived Files',
                message: dirs.join('<br>'),
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.INFO
            });
        }
    },
    
    viewJob: function(jobId) {
        // Weiterleitung zur Job-Detailseite
        if (typeof actLinkRes === 'function') {
            actLinkRes('Job', jobId);
        }
    },
    
    viewClient: function(clientName) {
        // Weiterleitung zur Client-Detailseite
        if (typeof actLinkRes === 'function') {
            actLinkRes('Client', clientName);
        }
    },
    
    viewPool: function(poolName) {
        // Weiterleitung zur Pool-Detailseite
        if (typeof actLinkRes === 'function') {
            actLinkRes('Pool', poolName);
        }
    }
});