// File Picker Window ----------------------------
Ext.define('P5U.view.FilePicker', {
    extend: 'Ext.window.Window',
    alias: 'widget.filePicker_x',

	height: 350,
	width: 550,
	border: false,
	layout: 'border',
	closeAction: 'hide',
	items: [{
        region: 'west',
        xtype: 'clienttabpanel',
        itemId: 'clienttabpanel_id',
        collapsible: true,
        collapseMode: 'mini',
        collapsed: true,
        preventHeader: true,
        split: true,
        width: 150,
        layout: 'fit'
    }, {
		region: 'center',
		xtype: 'servervolumegrid',
		id: 'servervolumegrid_id',
		flex: 1,
		layout: 'fit'
	}, {
		region: 'east',
		xtype: 'foldercontentgrid',
		id: 'foldercontentgrid_id',
		split: true,
		flex: 2,
		layout: 'fit'
	}],
	dockedItems: [{
		xtype: 'filepickerfooter',
		dock: 'bottom',
		ui: 'footer'
	}]        
});

Ext.define('P5U.view.ClientTabpanel', {
    extend: 'Ext.grid.Panel',
    alias : 'widget.clienttabpanel',

    layout: 'fit',
    multiSelect: false,
    border: true,
    columns: [
        { dataIndex: 'id', hidden: true },
        { header: $$('P5 Client'), dataIndex: 'text', flex: 1 }
    ],
	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			store: 'Clients'
		});    
		me.callParent(arguments);
	}
});

Ext.define('P5U.view.ServerVolumeGrid', {
    extend: 'Ext.tree.Panel',
    alias : 'widget.servervolumegrid',

	useArrows: true,
	rootVisible: false,
	multiSelect: false,
	columns: [{ text: $$('Volumes'), dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
    initComponent: function() {
        var me = this;
        Ext.applyIf(me, {
            store: new P5U.store.ServerVolume()
        });    
        me.callParent(arguments);
    },
    root: {
        children : []
    }
});    

Ext.define('P5U.view.FolderContentGrid', {
    extend: 'Ext.tree.Panel',
    alias : 'widget.foldercontentgrid',

	padding: '0 0 0 0',
	useArrows: true,
	multiSelect: false,
	singleExpand: true,
	rootVisible: true,
	border: true,
	columns: [{ text: $$('Folder'), dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
	store: 'FolderContent'
});

Ext.define('P5U.view.FilePickerFooter', {
	extend: 'Ext.Toolbar',
    alias : 'widget.filepickerfooter',

	defaults: {
		xtype : 'button',
		padding: '5 15 5 15'
	},
	items: [{
        xtype: 'button',
        text: $$('Clients')+' ...',
        enableToggle: true,
        handler: function(me) {
            var centerregion = this.up().up().getComponent('clienttabpanel_id');
            centerregion.toggleCollapse();                
        }	
	},{ xtype: 'tbfill' },{
		xtype: 'button',
		text: $$('Cancel'),
		handler: function() {
			this.up().up().close();
		}
	},{
		xtype: 'button',
		action: 'selectFolder',
		text: $$('Select'),
		disabled: true
	},{ 
	 xtype: 'tbspacer',
	 width: 10
	}]
});
