Ext.define('P5LTFS.view.LTFSFilePicker', {
    extend: 'Ext.window.Window',
    alias: 'widget.ltfsfilePicker',

	height: 500,
	width: 650,
	border: false,
	layout: 'border',
	modal: true,
    bind:{
	    title: '{filepickerTitle}'
	},
	items: [{
        region: 'west',
        xtype: 'ltfsclienttabpanel',
        itemId: 'ltfsclienttabpanel_id',
        collapsible: true,
        collapseMode: 'mini',
        collapsed: true,
        preventHeader: true,
        split: true,
        width: 130,
        layout: 'fit'
    }, {
		region: 'center',
        xtype: "tabpanel",
		itemId: 'tabpanelOnlineArchive_id',
    	items: [{
		    xtype: 'ltfsservervolumegrid',
            title: $$('Online'),
		    itemId: 'ltfsservervolumegrid_id',
            reference: 'ltfsservervolumegrid_ref',
		    flex: 1,
		    layout: 'fit'
    	}, {
		    xtype: 'ltfsarchivegrid',
            title: $$('Archive'),
		    itemId: 'ltfsarchivegrid_id',
            reference: 'ltfsarchivegrid_ref',
		    flex: 1,
		    layout: 'fit',
		    tabConfig: {
                bind: { hidden: '{enableArchiveIndex}' }
            }
    	}],	    
	}, {
		region: 'east',
		xtype: 'ltfsfoldercontentgrid',
		itemId: 'ltfsfoldercontentgrid_id',
        reference: 'ltfsfoldercontentgrid_ref',
		split: true,
		flex: 2,
		layout: 'fit'
	}],
	dockedItems: [{
		xtype: 'ltfsfilepickerfooter',
		dock: 'bottom',
		ui: 'footer'
	}]        
});
Ext.define('P5LTFS.view.LTFSClientTabpanel', {
    extend: 'Ext.grid.Panel',
    alias : 'widget.ltfsclienttabpanel',

    multiSelect: false,
    border: true,
    bind:{
        store: '{clientstore}'
    },
    columns: [
        { dataIndex: 'id', hidden: true },
        { header: $$('P5 Client'), dataIndex: 'text', flex: 1 }
    ]
});

Ext.define('P5LTFS.view.LTFSServerVolumeGrid', {
    extend: 'Ext.tree.Panel',
    alias : 'widget.ltfsservervolumegrid',

	useArrows: true,
	rootVisible: false,
	multiSelect: false,
    hideHeaders: true,
    headerBorders: false,
	columns: [{ dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
    bind:{
        store: '{servervolumestore}'
    },
});    
Ext.define('P5LTFS.view.LTFSArchiveGrid', {
    extend: 'Ext.tree.Panel',
    alias : 'widget.ltfsarchivegrid',

	useArrows: true,
	rootVisible: false,
	multiSelect: false,
    hideHeaders: true,
    headerBorders: false,
	columns: [{ dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
    bind:{
        store: '{archiveindexstore}'
    },
});    
Ext.define('P5LTFS.view.LTFSFolderContentGrid', {
    extend: 'Ext.tree.Panel',
    alias : 'widget.ltfsfoldercontentgrid',

    cls: 'ltfsfoldercontentgrid',

    viewConfig: {
      	deferEmptyText: false,
		emptyText: $$('Please select a volume')
    },

	padding: '0 0 0 0',
	useArrows: true,
	singleExpand: true,
	rootVisible: false,
	multiSelect: false,
	border: true,
	columns: [{ text: $$('Folder'), dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
    bind:{
        store: '{foldercontentstore}'
    }
});
Ext.define('P5LTFS.view.LTFSFilePickerFooter', {
	extend: 'Ext.Toolbar',
    alias : 'widget.ltfsfilepickerfooter',

	defaults: {
		xtype : 'button',
		padding: '5 15 5 15'
	},
	items: [{
        xtype: 'button',
        text: $$('Clients')+' ...',
        enableToggle: true,
        bind:{
            hidden:'{enableP5Client}',
        },            
        handler: 'onWriteClientToggel'
	},{ xtype: 'tbfill' },{
		xtype: 'button',
		text: $$('New Folder ...'),
        bind:{
            hidden:'{enableNewFolder}',
        },            
        handler: 'onNewFolder',
	},{ 
        xtype: 'tbspacer',
        width: 40
	},{
		xtype: 'button',
		text: $$('Cancel'),
		handler: function() {
			this.up().up().close();
		}
	},{
		xtype: 'button',
		action: 'selectFolder',
        bind:{
            disabled: '{enableSelect}',
            handler: '{selectHandler}',
		    text: '{selectText}'
        }                
	}]
});
