Ext.define("P5LTFS.view.DiveSlotGrid", {
    extend: 'Ext.panel.Panel',
    alias: "widget.drive_slot_grid",
    
    margin: '0 0 0 0',
    border: false,
    layout: {
        type: 'vbox',
        pack: 'start',
        align: 'stretch'
    },
    items: [{
        xtype: 'container',
        margin: '10 0 0 20',
        html: $$('List of currently available tape library slots, tape library drives and standalone tape drives.')
    },{
        xtype: 'grid',
        bind:{
            store: '{ltfsstore}'
        },
        /*
        selModel: {
            selType: 'checkboxmodel',
            mode: 'SINGLE',
            allowDeselect: true               
        },*/
        viewConfig: { 
            stripeRows: true, 
            getRowClass: function(record) { 
                return record.get('p5used') > 0 || record.get('state') == 'empty' ? 'p5volume-row' : 'unknown-row'; 
            } 
        },      
        features: [{
            ftype: 'grouping',
            groupHeaderTpl: '{name}',
            hideGroupedHeader: true,
            startCollapsed: false
        }],
        reference: 'drive_slot_grid_ref',
        itemId: 'drive_slot_grid_id',
        margin: '10 0 20 20',
        flex: 1,
        border: true,
        columns: [
            { text: $$('Drive'), dataIndex: 'drive', width: 65 },
            { text: $$('Slot'), dataIndex: 'location', width: 65 },
            { text: $$('Status'), dataIndex: 'text', width: 80 },
            { text: $$('Bar Code'), dataIndex: 'barcode', width: 70 },
            //{ text: 'Device', dataIndex: 'device', width: 60 },
            //{ text: $$('Size'), dataIndex: 'size', width: 60 },
            //{ text: 'Used', dataIndex: 'occupied', width: 40 },
            { text: $$('Name'), dataIndex: 'ltfs_volname',flex: 1 },
            { text: $$('In use'), dataIndex: 'indrive', width: 70 }
            //{ text: "STATUS", dataIndex: 'state', flex: 1 },
            //{ text: "VOLID", dataIndex: 'volid', flex: 1 },
            //{ text: "p5used", dataIndex: 'p5used', flex: 1 }
        ],
        dockedItems: [{
            margin: '0 0 0 0',
            xtype: 'toolbar',
            dock: 'bottom',
            layout: { pack: 'start' },
            items: [{
                xtype: 'button', scale: 'small', iconCls: 'fa fa-refresh awesomeIconS', handler:'onDiveSlotGridReload', text: $$('Reload')
            }, '->', {
                xtype: 'checkboxfield', itemId: 'p5showvolumes_id', boxLabel: $$('Show entire library inventory'), margin: '0 10 0 0'
            }]
        }]
    }]
});
