//#############################################################################

//LoginAreaPanelController.js

//JavaScript Client Library

//See the file "license.txt" for information on usage and
//redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.


//#############################################################################

Ext.define("P5Loginaras.view.LoginAreaPanelController", {
    extend: "Ext.app.ViewController",
    alias: "controller.loginareapanel",
    init: function() {
 		var me = this;
        me.control({
            '#loginareas_tree_id': {
                viewready: function(a,b,c) {
                    console.log('loginareas_tree_id ready');
                    me.dbusage = document.globals.dbusage.value;
                    me.operation = document.globals.operation.value;
                    var loginarea_store = me.getStore('loginareas');
                    loginarea_store.proxy.extraParams.dbusage = me.dbusage;
                    loginarea_store.proxy.extraParams.operation = me.operation;
                    loginarea_store.load();
                },
                itemclick: me.onLoginareaSelect
            },
        });
    },
    onLoginareaSelect: function(view, record, item, index, event) {
		var me = this;
        console.log('onLoginareaSelect');
        if (record.data.leaf) {
            var browser_index = document.globals.browser_index.value;
            var elementurl = record.data.elementurl;
            var elementtxt = record.data.elementtxt;
            var loginarea  = record.data.loginarea;
            var wststation = record.data.wststation;
            var dbusage    = record.data.dbusage;
            var operation  = record.data.operation;
            //remove fix bottom bar as div element because it is not controlled by EXT
            rmDiv('wstreebody');
            rmDiv('loaderdiv');
            rmDiv('fixButton');
            //if (Ext.getCmp('selection_id')) Ext.getCmp('selection_id').destroy();
            Ext.getCmp('centercenter').removeAll();
            waitBox('centerdata');
            Ext.get('centerdata').load({
                url:browser_index,
                scripts:true,
                success: function(){
                    hideWait();
                },
                failure: function(){
                    extAlert(1,'Could not connect to server')
                }, 
                params:{
                    caller: 'volumenListing',
                    content: 'volumelist',
                    searchFlag: 'false',
                    listing: 'listing',
                    elementurl: elementurl,
                    elementtxt: elementtxt,
                    loginarea: loginarea,
                    workstation: wststation,
                    dbusage: dbusage,
                    operation: operation
                }
            });
        }
    },
    onLoginAreaSetup: function() {
        me = this;
        console.log('onLoginAreaSetup');
        var usage = me.dbusage == "Online" ? me.operation : me.dbusage; 
        var modul = usage.toLowerCase();
        MenuSwitchToolbar(modul,'Loginarea')
    }
});
