Ext.define('Dashboard.view.widget.ArchiveStats', {
    extend: 'Ext.panel.Panel',
    xtype: 'archive-stats-widget',
    
    requires: [
        'Dashboard.view.widget.ArchiveStatsModel',
        'Dashboard.view.widget.ArchiveStatsController'
    ],
    
    controller: 'archive-stats',
    viewModel: {
        type: 'archive-stats'
    },
    
    layout: 'fit',

    items: [{
        xtype: 'container',
        layout: {
            type: 'vbox',
            align: 'stretch'
        },
        flex: 1,
        items: [{
            xtype: 'cartesian',
            flex: 1,
            insetPadding: '10 20 0 0',
            animation: false,
            bind: {
                store: '{archiveStats}'
            },
            border: 0,
            legend: {
                type: 'dom',
                docked: 'right',
                hidden: true // Legend is necessary to prevent flickering on mouseover
            },
            axes: [{
                type: 'numeric',
                position: 'left',
                title: {
                    text: 'Size (GB)',
                    fontSize: 12
                },
                grid: true,
                minimum: 0,
            }, {
                type: 'category',
                position: 'bottom',
                grid: true
            }],
            series: [{
                type: 'bar',
                xField: 'dateShort',
                yField: 'dataAmountGiB',
                style: {
                    maxBarWidth: 50,
                    opacity: 0.80
                },
                colors: ['#ffcc33'],
                tooltip: {
                    trackMouse: true,
                    renderer: function(tooltip, record) {
                        var date = Ext.util.Format.date(record.get('date'), 'M d, Y');
                        tooltip.setHtml(date + '<br>Size: ' + CalcSize(record.get('dataAmountKiB')) + '<br>Duration: ' + record.get('durationMin') + ' min');
                    }
                }
            }]
        }]
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'top',
        items: [{
            xtype: 'image',
            src: 'img4/archive_24_c.png',
            width: 24,
            height: 24
       },'->',{
            xtype: 'segmentedbutton',
            reference: 'periodToggle_ref',
            stateful: true,
            stateId: 'archive-stats-period',
            stateEvents : ['toggle', 'pressed'],
            allowMultiple: false,
            defaults: {
                width: 50
            },
            items: [{
                text: '1W',
                value: 7
            }, {
                text: '2W',
                value: 14
            }, {
                text: '3W',
                value: 21
            }, {
                text: '4W',
                value: 28
            }],
            listeners: {
                toggle: 'onPeriodChange'
            }
        }, '-', {
            xtype: 'combobox',
            reference: 'planSelector_ref',
            width: 150,
            queryMode: 'local',
            displayField: 'planName',
            valueField: 'planId',
            value: 'all',
            bind: {
                store: '{archivePlans}'
            },
            listeners: {
                select: 'onPlanChange'
            }
    
        }]
    }]

});
