Ext.define("P5Jobmanager.view.JoblogGrids", {
    extend: 'Ext.grid.Panel',
    alias: "widget.jobloggrids",

    applyState: function(state) {
        // disable stateful sorters and filters
        // ist a workaround for stateful "getViewModel() is null"
        state.sort = false;
        state.storeState = false;
        this.callParent(arguments);
    },

    bind:{
        store: '{joblogstore}'
    },
    
    reference: 'jobloggrid_ref',
    itemId: 'jobloggrid_id',

    viewConfig: {
        loadMask: false,
        preserveScrollOnReload: true,
        preserveScrollOnRefresh: true
    },

    border: false,

    listeners: { itemdblclick: 'onOpenJobLogRow' },

    columns: [{
        xtype: 'actioncolumn',
        dataIndex: 'returnStr',
        align: 'center',
        text: '',
        menuDisabled : true,
        width: 30,
        renderer: function(value,metaData,record) {
            switch(value) {
                case 'TCL_OK':
                    metaData.tdCls = 'tcl-ok tcl-icon';
                    break;
                case 'TCL_ERROR':
                    metaData.tdCls = 'tcl-error tcl-icon';
                    break;
                case 'TCL_BREAK':
                    metaData.tdCls = 'tcl-break tcl-icon';
                    break;
                case 'TCL_WARNING':
                    metaData.tdCls = 'tcl-warning tcl-icon';
                    break;
                default:
                    metaData.tdCls = 'tcl-undefined tcl-icon';
            }
        },
        stopSelection: false,
        listeners: { click: 'onOpenJobLog' },
    },{
        dataIndex: 'jtype',
        align: 'center',
        text: '',
        menuDisabled : true,
        width: 22,
        renderer: function(value,metaData,record) {
            switch(value) {
                case 'archivejob':
                    metaData.tdCls = 'archivejob-icon';
                    break;
                case 'backupjob':
                    metaData.tdCls = 'backupjob-icon';
                    break;
                case 'backup2gojob':
                    metaData.tdCls = 'backup2gojob-icon';
                    break;
                case 'syncjob':
                    metaData.tdCls = 'syncjob-icon';
                    break;
                case 'migrationjob':
                    metaData.tdCls = 'migrationjob-icon';
                    break;
                case 'restorejob':
                    metaData.tdCls = 'restorejob-icon';
                    break;
                default:
                    metaData.tdCls = 'otherjob-icon';
            }
        }
    },{
        text: $$('Plan Name/Operation'),
        dataIndex: 'text',
        menuDisabled : true,
        sortable: false,
        width: 200
    },{
        text: $$('Client'),
        dataIndex: 'client',
        menuDisabled : true,
        sortable: false,
        width: 80
    },{
        text: $$('User'),
        dataIndex: 'owner',
        menuDisabled : true,
        sortable: false,
        width: 80
    },{ 
        text: $$('Level'),
        dataIndex: 'level',
        menuDisabled : true,
        sortable: false,
        width: 60
    },{ 
        text: $$('Pool'),
        dataIndex: 'pool',
        menuDisabled : true,
        sortable: false,
        width: 80
    },{ 
        text: $$('Size'),
        dataIndex: 'numKbytes',
        menuDisabled : true,
        sortable: false,
        width: 80,
        renderer: eval('calcSizeIdx')
    },{ 
        text: $$('Start Time'),
        dataIndex: 'timeStarted',
        menuDisabled : true,
        sortable: false,
        width: 90,
        xtype: 'datecolumn',
        format: Ext.Date.patterns['formatTimeShort']
    },{ 
        text: $$('End Time'),
        dataIndex: 'timeCompleted',
        menuDisabled : true,
        sortable: false,
        width: 90,
        xtype: 'datecolumn',
        format: Ext.Date.patterns['formatTimeShort']
    },{ 
        text: $$('Duration'),
        dataIndex: 'duration',
        menuDisabled : true,
        sortable: false,
        width: 80,
        renderer: function(value,metaData) {
            return sec2min(value);
        }
    },{
        text: $$('Job'),
        dataIndex: 'name',
        menuDisabled : true,
        sortable: false,
        flex: 1
    }],
    dockedItems: [{
        xtype: 'pagingtoolbar',
        bind: {store: '{joblogstore}'},
        dock: 'bottom',
        displayInfo: false,
        items: ['-', {
            xtype: 'combo',
            itemId: 'PerPageCombo',
            store: [10, 20, 50, 100],
            queryMode: 'local',
            width: 60,
            value: '10',
            editable: false,
            margin: '0 10 0 10',
            listeners: {
                change: {
                    fn: function (cmb, v) {
                        var pagingBar = cmb.ownerCt;
                        pagingBar.getStore().setPageSize(parseInt(v));
                        pagingBar.moveFirst();
                    }
                }
            }
        },{
            xtype: 'label',
            text: $$('Page size')
        },{ xtype: 'tbfill' },{
            xtype: 'label',
            text: $$('Jobs of the last 12 hours')
        },{ xtype:'tbspacer', width:15 }]
    }]
});
