//#############################################################################
//
//  setup_assistant.js
//
//    JavaScript Client Library
//
//    See the file "license.txt" for information on usage and
//    redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
//
//#############################################################################


Ext.onReady(function() {
    startAppListing();
});

Ext.Ajax.on('requestexception', function (conn,resp,opt) {
    // no error handling for portal communication
    if (resp && resp.status === 404) {
        setTimeout(function(){
            extAlert(1,'Page not found!');
        },200);
    } else if (resp && resp.status === 500) {
        // delay needed because of refreshing after loading will overwrite the Msg
        setTimeout(function(){
            Ext.Msg.show({
                title:'Session Expired',
                message: resp.responseText + '<br>' + resp.statusText,
                buttons: Ext.Msg.YESNO,
                buttonText:{ 
                    yes: "Login", 
                    no: 'Cancel' 
                },
                icon: Ext.Msg.WARNING,
                fn: function(btn) {
                    if (btn === 'yes') {
                        console.log('Reloading');
                        window.location.href=window.location.href.split('#')[0]
                    }
                }
            });
        },200);
    } else if (resp && resp.status === 0) {
        setTimeout(function(){
            extAlert(1,'Server has aborted the connection');
        },200);
    } else if (resp && resp.status !== undefined) {
        setTimeout(function(){
            extAlert(1,'Server connection error: ' + resp.status );
        },200);
    } else {
        setTimeout(function(){
            extAlert(1,'Server error');
        },200);
    }
});

// add template methode for afterRequest (since ext 5.0)
Ext.define('awProxy', {
	override: 'Ext.data.proxy.Ajax', 
	
	config: {
		afterRequest: Ext.emptyFn
	}
	
});

function startAppListing() {

    setup_assistant = document.urls.setup_assistant.value;
    dbusage = document.urls.dbusage.value;

    //  client listing -------------------------------------------------------------

	Ext.define('m_clients',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'name',  type: 'string', defaultValue: ''},
			{name: 'elementurl',  type: 'string', defaultValue: ''},
			{name: 'text', type: 'string', defaultValue: '' }
		]
	});

	store_clients = Ext.create('Ext.data.Store', {
		model: 'm_clients',
		proxy: {
			type: 'ajax',
			url: setup_assistant,
			actionMethods: 'POST',
			extraParams: {
				caller: 'ajaxGetClients',
				defaultClient: 'localhost'
			},
			reader: {
				type: 'xml',
				root: 'clients',
				record: 'client'
			},
            afterRequest: function(req, res) {
                if (req.getOperation().success) {
                    var panel_tree = Ext.getCmp('clientsgrid_id');
                    var cl = this.extraParams.defaultClient
                    var id = store_clients.find('text',cl);
                    if ( id >= 0 ) {
                        panel_tree.getSelectionModel().select(id);
                        panel_tree.fireEvent('itemclick', panel_tree, panel_tree.getSelectionModel().getLastSelected());
                    }
                } else {
	                alert($$('Server session has expired.'))
                   	parent.location.href='/login/logout'
                }
            }
		}
	});

    Ext.define('Tree.Clients.Grid', {
        extend: 'Ext.grid.Panel',
		xtype: 'clientsgrid',
		//cls: 'left-toolbar-bg-row',
        multiSelect: false,
        border: true,
		columns: [
			{ dataIndex: 'id', hidden: true },
			{ header: $$('P5 Client'), dataIndex: 'text', flex: 1 }
		],
        listeners: {
            itemclick: function(view, record, item, index, event) {
                var panel_tree = Ext.getCmp('servervolumegrid_id');
                var tree_store = panel_tree.getStore();
                tree_store.load({
					params: {
						hostname: record.data.name
					}
                });
                this.selectedClient = record.data.name;
                var htxt = $$('Volumes on') + ' ' + record.data.name;
                panel_tree.columns[0].setText(htxt);   
            }
        },
        initComponent: function() {
            var me = this;
            Ext.applyIf(me, {
                store: store_clients,
            });    
            me.callParent(arguments);
        }

    });
    
    Ext.define('Tree.Client.TabPanel', {
        extend: 'Ext.tab.Panel',
		xtype: 'clienttabpanel',
        activeTab: 0,
        tabPosition: 'bottom',
        defaults: {
            margins: '0 0 0 0',  
            border: '0 0 0 0',
            layout: 'fit',
            closable: false,
        },
        items: [ {
            title: $$('Select Client'),
		    border: false,
            items: [{
                xtype: 'clientsgrid',
                id: 'clientsgrid_id'
                //bodyStyle : 'background:#DBDFE6'
            }]
        },{
            title: $$('Add Client'),
		    border: false,
            items: [{
                xtype: 'clientform',
                itemId: 'clientform_id'
            }]
        }]
    });

	// general form fields
	
	Ext.define('m_clientform', {
		extend: 'Ext.data.Model',
		fields: ['hostname','username','password']
	});
		
	Ext.define('m_clientform_error', {
		extend: 'Ext.data.Model',
		fields: ['id', 'msg']
	});

    Ext.define('Tree.Client.Form', {
        extend: 'Ext.form.Panel',
		xtype: 'clientform',
        frame: true,
        waitMsgTarget:true,
        bodyStyle:'padding:5px 5px 0',
        layout:'auto',
        reader: {
            type: 'xml',
            model: 'm_clientform',
            record : 'client',
            successProperty: '@success'
        },
        errorReader: {
            type: 'xml',
            model: 'm_clientform_error',
            record : 'client',
            successProperty: '@success'
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: $$('P5 installed computer'),
			labelAlign: 'top',
            name: 'hostname',
			allowBlank: false,
            flex: 1,
            emptyText: $$('Enter DNS name ...')
        }, {
            xtype: 'label',
            text: $$('DNS name or TCP/IP address'),
            margin: '0 0 0 0'
        }, {
            xtype: 'textfield',
            fieldLabel: $$('Username'),
			labelAlign: 'top',
            name: 'username',
			allowBlank: false,
            flex: 1,
            margin: '20 0 0 0'
        }, {
            xtype: 'textfield',
            fieldLabel: $$('Password'),
			labelAlign: 'top',
			inputType: 'password',
			allowBlank: false,
            name: 'password',
            flex: 1,
            margin: '10 0 0 0'
        }],
        buttons: [{
            text: $$('New Client'),
            formBind: true,
            handler: function(btn){
                var tabpanel = btn.up().up().up().up();
                var thisForm = this.up('form').getForm()
                var hostname = thisForm.findField('hostname').getValue()              
                thisForm.submit({
                	waitMsg: $$('Saving')+' ...',
                    url: setup_assistant,
                    submitEmptyText: false,
                    params: {
                        caller: 'ajaxNewClient'
                    },
                    success: function(form,req) {
                        var XMLdata = req.response.responseXML;
                        // try to fetch values for page status and message
                        var attention = DQ.selectValue('attention', XMLdata);
                        var message   = DQ.selectValue('message', XMLdata);
                        var hostname  = DQ.selectValue('hostname', XMLdata);
                        if (typeof attention == 'undefined') {
                            extAlert(1,$$('Server communication error. (Invalid XML message)'))
                        } else if (attention > 0 ) {
                            extAlert(attention,message)
                        } else {
    			            store_clients.proxy.extraParams = {
            				    caller: 'ajaxGetClients',
				                defaultClient: hostname,
			                };
			                store_clients.load();
                            tabpanel.setActiveTab(0);
                        }
                    }
                });
            }        
		}]		
    });

    //  content listing -------------------------------------------------------------

	Ext.define('m_content',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'id',  type: 'string', defaultValue: ''},
			{name: 'name', type: 'string', defaultValue: '' },
			{name: 'path', type: 'string', defaultValue: '' }
		]
	});

    Ext.define('Tree.Content.Store', {
        extend: 'Ext.data.TreeStore',
        model: 'm_content',
        proxy: {
            type: 'ajax',
            url: setup_assistant,
            timeout: 600000,
            actionMethods: 'POST',
            extraParams: {
                caller: 'changeDir'
            },
            reader: {
                type: 'xml',
                root: 'nodes',
                record: 'node'
            }
        },
        listeners: {
            beforeload: function(store, records, successful) {
                var panel_tree = Ext.getCmp('contentgrid_id');
                panel_tree.setLoading(true, true)
            },
            load: function(store, records, successful) {
                var panel_tree = Ext.getCmp('contentgrid_id');
                panel_tree.setLoading(false)
            }
        },      
        sorters: [{
            property: 'leaf',
            direction: 'ASC'
        },{
            property: 'name',
            direction: 'ASC'
        }]
    });

    Ext.define('Tree.Content.Grid', {
        extend: 'Ext.tree.Panel',
		xtype: 'contentgrid',
        padding: '0 0 0 0',
        useArrows: true,
        multiSelect: false,
        singleExpand: true,
        rootVisible: true,
        border: true,
		columns: [{ text: $$('Folder'), dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
        listeners: {
            selectionchange: function(model, selected) {
                model.view.up().up().down('button[itemId=select_id]').setDisabled(!selected.length);
            }
        },
        initComponent: function() {
            var me = this;
            Ext.applyIf(me, {
                store: new Tree.Content.Store()
            });    
            me.callParent(arguments);
        }

    });

    if ( dbusage == 'Sync' ) {
        toolbarDef = {
            xtype: 'button',
            text: $$('New Folder ...'),
            handler: function() {
                var panel_tree   = Ext.getCmp('contentgrid_id');
                if (panel_tree.getSelectionModel().hasSelection()) {
                    Ext.Msg.prompt($$('Name of new folder'), '', function(btn, foldername){
                        if (btn == 'ok') {
                            var tree_store   = panel_tree.getStore();
                            var selectedNode = panel_tree.getSelectionModel().getSelection();
                            var nodeobj      = selectedNode[0];
                            var elementurl   = selectedNode[0].data.id
                            Ext.Ajax.request({
                                url: setup_assistant,
                                timeout: 600000,
                                method: 'POST',
                                params: { 
                                    caller: 'ajaxNewFolder',
                                    node: elementurl,
                                    folder: foldername
                                },
                                scope: this,
                                failure: function(){
                                    extAlert(1,'Could not connect to server')
                                }, 
                                success:function(response, options) {
                                    var XMLdata = response.responseXML;
                                    // try to fetch values for page status and message
                                    var attention = DQ.selectValue('attention', XMLdata);
                                    var message   = DQ.selectValue('message', XMLdata);
                                    var newnode   = DQ.selectValue('newnode', XMLdata);
                                    if (typeof attention == 'undefined') {
                                        extAlert(1,$$('Server communication error. (Invalid XML message)'))
                                    } else if (attention > 0 ) {
                                        extAlert(attention,message)
                                    }
                                    if (attention == 0 ) {
                                        nodeobj.removeAll();
                                        tree_store.load({ 
                                            node: nodeobj,
                                            callback : function(records, operation, success){
                                                var rootNode  = panel_tree.getRootNode();
                                                var newObj    = rootNode.findChild('id',newnode, true);
                                                newObj.parentNode.expand();
                                                panel_tree.getSelectionModel().select(newObj);
                                            }
                                        });
                                    };
                                }
                            });
                        };
                    });
                } else {
                    extAlert(2,'Please select the parent folder')
                }
            }
        };
    } else {
        toolbarDef = {
            xtype: 'tbspacer'
        };
    }

    Ext.define('Tree.Footer.BackupSource', {
        extend: 'Ext.Toolbar',
        dock: 'bottom',
        ui: 'footer', 
        defaults: {
            xtype : 'button',
            padding: '4 15 4 15'
        },
        items: [{
            xtype: 'button',
            text: $$('Clients ...'),
            enableToggle: true,
            handler: function(me) {
                var centerregion = this.up().up().getComponent('clienttabpanel_id');
                centerregion.toggleCollapse();                
            }
        },{ xtype: 'tbfill' },toolbarDef,{ xtype: 'tbspacer' },{
            xtype: 'button',
            text: $$('Cancel'),
            handler: function() {
                this.up().up().close();
            }
        },{
            xtype: 'button',
            itemId: 'select_id',
            text: $$('Select'),
            disabled: true,
            handler: function() {
                var panel_tree = Ext.getCmp('contentgrid_id');
                numberElements   = 0;
                selectedelements = [];
                var selection    = panel_tree.getSelectionModel().getSelection();
                Ext.iterate(selection, function(obj, index) {
                    var path = obj.get('path');
                    selectedelements.push(path);
                    numberElements++
                });
                if ( checkForSingle() == 0 ) return
                var grid_client = Ext.getCmp('clientsgrid_id');
                callback(grid_client.selectedClient,selectedelements)
                this.up().up().close();
            }
        },{ 
         xtype: 'tbspacer',
         width: 10
        }]
    });
    
    //  fixed disk and server volume listing -------------------------------------------------------------

    Ext.define('m_servervolume', {
        extend: 'Ext.data.Model',
        fields: [
            {name: 'name',     type: 'string'},
            {name: 'path',     type: 'string'},
            {name: 'elementurl',     type: 'string'},
            {name: 'duration', type: 'string'}
        ]
    });

    Ext.define('Tree.Servervolume.Store', {
        extend: 'Ext.data.TreeStore',
        model: 'm_servervolume',
        proxy: {
            type: 'ajax',
            url: setup_assistant,
            timeout: 600000,
            actionMethods: 'POST',
            extraParams: {
                caller: 'ajaxGetServerVolume'
            },
            reader: {
                type: 'json'
            },
            afterRequest: function(req, res) {
                if (req.getOperation().success) {
                    var panel_tree = Ext.getCmp('servervolumegrid_id');
                    panel_tree.getSelectionModel().select(1);
                    panel_tree.fireEvent('itemclick', panel_tree, panel_tree.getSelectionModel().getLastSelected());
                }
            }
        },
        listeners: {
            beforeload: function(store, records, successful) {
                var panel_tree = Ext.getCmp('servervolumegrid_id');
                panel_tree.setLoading(true, true)
            },
            load: function(store, records, successful) {
                var panel_tree = Ext.getCmp('servervolumegrid_id');
                panel_tree.setLoading(false)
            }
        }
    });

    Ext.define('Tree.Servervolume.Grid', {
        extend: 'Ext.tree.Panel',
		xtype: 'servervolumegrid',

        useArrows: true,
        rootVisible: false,
        multiSelect: false,
        //bodyStyle : 'background:#DBDFE6',
		//cls: 'left-toolbar-bg-row',
   		viewConfig: { 
        	stripeRows: false, 
        	getRowClass: function(record) { 
            	return record.get('iconCls')+'-row'; 
        	} 
    	},
    	columns: [{ text: $$('Volumes'), dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
        listeners: {
            beforeselect: function(view, record, item, index, event) {
                if(!record.data.leaf) return false;
            },
            select: function(view, record, item, index, event) {
                var panel_tree = Ext.getCmp('contentgrid_id');
                var tree_store = panel_tree.getStore();
                // reset panel and store
		        tree_store.removeAll();
                tree_store.setRootNode();
                //panel_tree.setRootNode(null);
                var newRoot = {
                    name: record.data.name,
                    id: record.data.elementurl,
                    path: record.data.path,
                    expanded: true
                }
                tree_store.setRootNode(newRoot);           
            }
        },
        initComponent: function() {
            var me = this;
            Ext.applyIf(me, {
                store: new Tree.Servervolume.Store()
            });    
            me.callParent(arguments);
        },
    	root: {
        	children : []
	    }
    });
    

    //  disk listing -------------------------------------------------------------

	Ext.define('m_disks',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'path', type: 'string', defaultValue: ''}
		]
	});

	store_disks = Ext.create('Ext.data.Store', {
		model: 'm_disks',
		proxy: {
			type: 'ajax',
			url: setup_assistant,
			actionMethods: 'POST',
			extraParams: {
				caller: 'ajaxGetDisks'
			},
			reader: {
				type: 'xml',
				root: 'disks',
				record: 'disk'
			},
            afterRequest: function(req, res) {
                if (!req.getOperation().success) {
	                alert($$('Server session has expired.'))
                   	parent.location.href='/login/logout'
                }
            }
		}
	});

    Ext.define('Tree.Disks.Grid', {
        extend: 'Ext.grid.Panel',
		xtype: 'disksgrid',
        multiSelect: false,
        border: true,
		columns: [
			{ header: $$('Path'), dataIndex: 'path', flex: 1 }
		],
        listeners: {
            selectionchange: {
                fn: function(model, selected) {
                    model.view.up().up().down('button[itemId=select_id]').setDisabled(!selected.length);
                },
                scope: this
            }
        },
        initComponent: function() {
            var me = this;
            Ext.applyIf(me, {
                store: store_disks,
            });    
            me.callParent(arguments);
        },
        viewConfig: {
            emptyText: "<div class='x-grid-empty'>" + $$('Warning: No suitable disk drive found.') + "</div>"
        }
    });

   Ext.define('Tree.Footer.TargetDisk', {
        extend: 'Ext.Toolbar',
        dock: 'bottom',
        ui: 'footer', 
        defaults: {
            xtype : 'button',
            padding: '4 15 4 15'
        },
        items: [{xtype: 'tbfill' },{
            xtype: 'button',
            text: $$('Cancel'),
            handler: function() {
                this.up().up().close();
            }
        },{
            xtype: 'button',
            itemId: 'select_id',
            text: $$('Select'),
            disabled: true,
            handler: function() {
                var panel_tree = Ext.getCmp('disksgrid_id');
                selectedelement = '';
                var selection   = panel_tree.getSelectionModel().getSelection();
                Ext.iterate(selection, function(obj, index) {
                    selectedelement = obj.get('path');
                });
                var storage = 'Disk';
                callback(storage,selectedelement)
    
                this.up().up().close();
            }
        },{ 
         xtype: 'tbspacer',
         width: 10
        }]
    })

    //  cloud listing -------------------------------------------------------------

	Ext.define('m_clouds',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'name', type: 'string', defaultValue: ''},
			{name: 'text', type: 'string', defaultValue: ''}
		]
	});

	store_clouds = Ext.create('Ext.data.Store', {
		model: 'm_clouds',
		proxy: {
			type: 'ajax',
			url: setup_assistant,
			actionMethods: 'POST',
			extraParams: {
				caller: 'ajaxGetClouds'
			},
			reader: {
				type: 'xml',
				root: 'clouds',
				record: 'cloud'
			},
            afterRequest: function(req, res) {
                if (!req.getOperation().success) {
	                alert($$('Server session has expired.'))
                   	parent.location.href='/login/logout'
                }
            }
		}
	});

    //  tape listing -------------------------------------------------------------

	Ext.define('m_tapes',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'name', type: 'string', defaultValue: ''},
			{name: 'text', type: 'string', defaultValue: ''}
		]
	});

	store_tapes = Ext.create('Ext.data.Store', {
		model: 'm_tapes',
		proxy: {
			type: 'ajax',
			url: setup_assistant,
			actionMethods: 'POST',
			extraParams: {
				caller: 'ajaxGetTapes'
			},
			reader: {
				type: 'xml',
				root: 'tapes',
				record: 'tape'
			},
            afterRequest: function(req, res) {
                if (!req.getOperation().success) {
	                alert($$('Server session has expired.'))
                   	parent.location.href='/login/logout'
                }
            }
		}
	});

    Ext.define('Tree.Tapes.Grid', {
        extend: 'Ext.grid.Panel',
		xtype: 'tapesgrid',
        multiSelect: false,
        border: true,
		columns: [
			{ header: $$('Name'), dataIndex: 'name'},
			{ header: $$('Description'), dataIndex: 'text', flex: 1 }
		],
        listeners: {
            selectionchange: {
                fn: function(model, selected) {
                    model.view.up().up().down('button[itemId=select_id]').setDisabled(!selected.length);
                },
                scope: this
            }
        },
        initComponent: function() {
            var me = this;
            Ext.applyIf(me, {
                store: store_tapes,
            });    
            me.callParent(arguments);
        }

    });

    Ext.define('Tree.Footer.BackupTape', {
        extend: 'Ext.Toolbar',
        dock: 'bottom',
        ui: 'footer', 
        defaults: {
            xtype : 'button',
            padding: '4 15 4 15'
        },
        items: [{
            xtype: 'button',
            text: $$('Add Tape Drive ...'),
            handler: function(me) {
                tapeWizard();
            }
        },{xtype: 'tbfill' },{
            xtype: 'button',
            text: $$('Cancel'),
            handler: function() {
                this.up().up().close();
            }
        },{
            xtype: 'button',
            itemId: 'select_id',
            text: $$('Select'),
            disabled: true,
            handler: function() {
                var tape_grid = Ext.getCmp('tapesgrid_id');
                selectedelement = '';
                var selection   = tape_grid.getSelectionModel().getSelection();
                Ext.iterate(selection, function(obj, index) {
                    selectedelement = obj.get('name');
                });
                var storage = 'Tape Drive';
                callback(storage,selectedelement)
                this.up().up().close();
            }
        }]
    })

    //  library listing -------------------------------------------------------------

	Ext.define('m_libraries',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'name', type: 'string', defaultValue: ''},
			{name: 'text', type: 'string', defaultValue: ''}
		]
	});

	store_libraries = Ext.create('Ext.data.Store', {
		model: 'm_libraries',
		proxy: {
			type: 'ajax',
			url: setup_assistant,
			actionMethods: 'POST',
			extraParams: {
				caller: 'ajaxGetLibraries'
			},
			reader: {
				type: 'xml',
				root: 'libraries',
				record: 'library'
			},
            afterRequest: function(req, res) {
                if (!req.getOperation().success) {
	                alert($$('Server session has expired.'))
                   	parent.location.href='/login/logout'
                }
            }
		}
	});

    Ext.define('Tree.Libraries.Grid', {
        extend: 'Ext.grid.Panel',
		xtype: 'librariesgrid',
        multiSelect: false,
        border: true,
		columns: [
			{ header: $$('Name'), dataIndex: 'name'},
			{ header: $$('Description'), dataIndex: 'text', flex: 1 }
		],
        listeners: {
            selectionchange: {
                fn: function(model, selected) {
                    model.view.up().up().down('button[itemId=select_id]').setDisabled(!selected.length);
                },
                scope: this
            }
        },
        initComponent: function() {
            var me = this;
            Ext.applyIf(me, {
                store: store_libraries,
            });    
            me.callParent(arguments);
        }

    });
    
    Ext.define('Tree.Footer.BackupLibrary', {
        extend: 'Ext.Toolbar',
        dock: 'bottom',
        ui: 'footer', 
        defaults: {
            xtype : 'button',
            padding: '4 15 4 15'
        },
        items: [{
            xtype: 'button',
            text: $$('Add Tape Library ...'),
            handler: function(me) {
                libraryWizard();
            }
        },{xtype: 'tbfill' },{
            xtype: 'button',
            text: $$('Cancel'),
            handler: function() {
                this.up().up().close();
            }
        },{
            xtype: 'button',
            itemId: 'select_id',
            text: $$('Select'),
            disabled: true,
            handler: function() {
                var library_grid = Ext.getCmp('librariesgrid_id');
                selectedelement = '';
                var selection   = library_grid.getSelectionModel().getSelection();
                Ext.iterate(selection, function(obj, index) {
                    selectedelement = obj.get('name');
                });
                var storage = 'Tape Library';
                callback(storage,selectedelement)
                this.up().up().close();
            }
        }]
    })

    //  time select ------------------------------------------------------------

    Ext.define('Tree.Time.Form', {
        extend: 'Ext.form.Panel',
		xtype: 'timeform',
        frame: true,
        waitMsgTarget:true,
        bodyStyle:'padding:5px 5px 0',
        layout:'auto',
        items: [{
            xtype: 'timefield',
			labelAlign: 'top',
            name: 'starttime',
            value: '22:00',
            fieldLabel: $$('Start Time'),
            format: 'G:i',
            increment: 30
        }]
    });

    //  interval select ------------------------------------------------------------

    var store_intervals = Ext.create('Ext.data.Store', {
        fields: ['sec', 'vsec'],
        data : [
            {sec:  900,  vsec: $$('15 min')},
            {sec: 1800,  vsec: $$('30 min')},
            {sec: 3600,  vsec: $$('1 hour')},
            {sec: 7200,  vsec: $$('2 hour')},
            {sec: 14400, vsec: $$('4 hour')},
            {sec: 21600, vsec: $$('6 hour')},
            {sec: 28800, vsec: $$('8 hour')},
            {sec: 43200, vsec: $$('12 hour')}
        ]
    });

    Ext.define('Tree.Interval.Form', {
        extend: 'Ext.form.Panel',
		xtype: 'intervalform',
        frame: true,
        waitMsgTarget:true,
        bodyStyle:'padding:5px 5px 0',
        layout:'auto',
        items: [{
            xtype: 'combobox',
            store: store_intervals,
            queryMode: 'local',
            valueField: 'sec',
            displayField: 'vsec',
			labelAlign: 'top',
            name: 'starttime',
            fieldLabel: $$('Interval'),
            listeners: {
                afterrender: function(combo) {
                    // set 1 hour as default
                    var recordSelected = combo.getStore().getAt(2);   
                    combo.setValue(recordSelected.get('sec'));
                }
            }        
        }]
    });

    //  Notification listing ------------------------------------------------------------

    Ext.define('m_notification', {
        extend: 'Ext.data.Model',
        idProperty: "id",
        fields: [
            {name: 'id',      type: 'string'},
            {name: 'subject', type: 'string'},
            {name: 'body',    type: 'string'},
            {name: 'created', type: 'date', dateFormat: 'U'}
        ]
    });

	store_notification = Ext.create('Ext.data.JsonStore', {
        model: 'm_notification',
        proxy: {
            type: 'ajax',
            url: setup_assistant,
            timeout: 600000,
            actionMethods: 'POST',
            extraParams: {
                caller: 'ajaxGetNotifications'
            },
            reader: {
                type: 'json',
                rootProperty: 'data'
            }
        },
        listeners: {
            load: function(store, records, successful) {
                if (store.getCount() == 0 ) {
                    document.getElementById('home:1:notification').style.color = "#d4d3d3";
                }
            }
        }     
    });

    Ext.define('Dashboard.Notification.Grid', {
        extend: 'Ext.grid.Panel',
		xtype: 'notificationgrid',
        multiSelect: false,
        border: true,
        hideHeaders: true,
        disableSelection: true,
        features: [{
            ftype: 'rowbody',
            getAdditionalData: function (data, idx, record, orig) {
                // Usually you would style the my-body-class in a CSS file
                return {
                    rowBody: '<div style="padding-left: 10px;padding-bottom: 10px">' + record.get("body") + '</div>'
                };
            }
        }],
        columns:[{
            xtype:'gridcolumn',
            text:'Message',
            flex: 1,
            dataIndex:'subject',
            renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
                metaData.tdStyle = "font-size: 12px;font-weight: bold !important;";
                return value;
            }
        },{
            xtype:'datecolumn',
            text:'Message',
            width: 120,
            dataIndex:'created',
            format: Ext.Date.patterns[userDateFormat]
        },{
            xtype: 'actioncolumn',
            width: 40,
            items: [{
                iconCls: 'fa fa-times',
                tooltip: 'Dismiss Note',
                handler: function(view, rowIndex, collIndex, item, theEvent, record, htmlRow) {
                    dismissNote(record);
                }
            }]
        }],
        initComponent: function() {
            var me = this;
            Ext.applyIf(me, {
                store: store_notification,
            });    
            me.callParent(arguments);
        }
    });
}

// client window
function clientWindow(wtype) {
    popupHide();
    callback = wtype
	var reswin = Ext.getCmp('clientspanel');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'clientspanel',
			title: $$('Select a Folder'),
			height: 350,
			width: 650,
			border: false,
			renderTo: 'centercenter',
			constrain: true,
			listeners: {
				beforeshow: function(win) {
					store_clients.load();
				}
			},
            layout: 'border',
            items: [{
                region: 'west',
                xtype: 'clienttabpanel',
                itemId: 'clienttabpanel_id',
                title: $$('P5 Clients'),
				collapsible: true,
				collapseMode: 'mini',
                collapsed: true,
                preventHeader: true,
		        border: false,
                split: true,
				width: 200,
                layout: 'fit'
            }, {
                region: 'center',
                xtype: 'servervolumegrid',
                id: 'servervolumegrid_id',
                flex: 1,
                layout: 'fit'
            }, {
                region: 'east',
                xtype: 'contentgrid',
                id: 'contentgrid_id',
                split: true,
                flex: 2,
                layout: 'fit'
            }],
            dockedItems: Ext.create('Tree.Footer.BackupSource', {})
		});
		Ext.getCmp('centercenter').add(reswin);
		reswin.show();
	} else {
		reswin.show();
	}
}
// add container storage
function containerWizard() {
    popupHide();
	var reswin  = Ext.getCmp('containerwizard');
	var cregion = Ext.getCmp('centercenter');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'containerwizard',
			title: $$('New Local Storage'),
			height: 350,
			width: 650,
			border: false,
			renderTo: 'centercenter',
			closeAction: 'hide',
			constrain: true,
            layout: 'fit',
            border: 1,
            items: [{
				xtype : "component",
				autoEl : {
					tag: "iframe",
					name: 'containerauto',
					frameBorder: 0
				}
            }]
		});
		cregion.add(reswin);
		reswin.show();
        document.hammerForm.elementType.value = 'Device';
        document.hammerForm.elementCall.value = 'cdisk';
        document.hammerForm.process.value     = 'wizard';
        document.hammerForm.elementurl.value  = "";
        document.hammerForm.selected.value    = "";
        document.hammerForm.target            = 'containerauto';
        document.hammerForm.submit();
	} else {
		reswin.show();
	}
}
// add cloud service
function cloudWizard() {
    popupHide();
	var reswin  = Ext.getCmp('cloudwizard');
	var cregion = Ext.getCmp('centercenter');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'cloudwizard',
			title: $$('New Cloud Service'),
			height: 550,
			width: 720,
			border: false,
			renderTo: 'centercenter',
			closeAction: 'hide',
			constrain: true,
            layout: 'fit',
            border: 1,
            items: [{
				xtype : "component",
				autoEl : {
					tag: "iframe",
					name: 'cloudauto',
					frameBorder: 0
				}
            }]
		});
		cregion.add(reswin);
		reswin.show();
        document.hammerForm.elementType.value = 'Device';
        document.hammerForm.elementCall.value = 'ccloud';
        document.hammerForm.process.value     = 'wizard';
        document.hammerForm.elementurl.value  = "";
        document.hammerForm.selected.value    = "";
        document.hammerForm.target            = 'cloudauto';
        document.hammerForm.submit();
	} else {
		reswin.show();
	}
}
// tape windows
// tape wizard
function tapeWizard() {
    popupHide();
	var reswin = Ext.getCmp('tapewizard');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'tapewizard',
			title: $$('Tape Drive Wizard'),
			height: 400,
			width: 550,
			border: false,
			renderTo: 'centercenter',
			constrain: true,
            layout: 'fit',
            border: 1,
            items: [{
				xtype : "component",
				autoEl : {
					tag: "iframe",
					name: 'deviceauto',
					frameBorder: 0
				}
            }]
		});
		Ext.getCmp('centercenter').add(reswin);
		reswin.show();
	} else {
		reswin.show();
	}
    document.hammerForm.elementType.value = 'Device';
    document.hammerForm.elementCall.value = 'ctape';
    document.hammerForm.elementurl.value  = "";
    document.hammerForm.selected.value    = "";
    document.hammerForm.target            = 'deviceauto';
    document.hammerForm.submit();
}
// tape list
function tapeWindow() {
    popupHide();
    callback = setBackupTarget
	var reswin = Ext.getCmp('tapepanel');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'tapepanel',
			title: $$('Select a Tape Drive'),
			height: 200,
			width: 400,
			border: false,
			renderTo: 'centercenter',
			constrain: true,
			listeners: {
				beforeshow: function(win) {
					store_tapes.load();
				}
			},
            layout: 'fit',
            items: {
				xtype : "tapesgrid",
                id: 'tapesgrid_id'
            },
            dockedItems: Ext.create('Tree.Footer.BackupTape', {})
		});
		Ext.getCmp('centercenter').add(reswin);
		reswin.show();
	} else {
		reswin.show();
	}
}
// library windows
// library wizard
function libraryWizard() {
    popupHide();
	var reswin = Ext.getCmp('librarywizard');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'librarywizard',
			title: $$('Tape Library Wizard'),
			height: 500,
			width: 550,
			border: false,
			renderTo: 'centercenter',
			constrain: true,
            layout: 'fit',
            border: 1,
            items: [{
				xtype : "component",
				autoEl : {
					tag: "iframe",
					name: 'jukeboxcreate',
					frameBorder: 0
				}
            }]
		});
		Ext.getCmp('centercenter').add(reswin);
		reswin.show();
	} else {
		reswin.show();
	}
    document.hammerForm.elementType.value = 'Jukebox';
    document.hammerForm.elementCall.value = 'cjb';
    document.hammerForm.elementurl.value  = "";
    document.hammerForm.selected.value    = "";
    document.hammerForm.target            = 'jukeboxcreate';
    document.hammerForm.submit();
}
// library list
function libraryWindow() {
    popupHide();
    callback = setBackupTarget
	var reswin = Ext.getCmp('librarypanel');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'librarypanel',
			title: $$('Select a Tape Library'),
			height: 200,
			width: 400,
			border: false,
			renderTo: 'centercenter',
			constrain: true,
			listeners: {
				beforeshow: function(win) {
					store_libraries.load();
				}
			},
            layout: 'fit',
            items: {
				xtype : "librariesgrid",
                id: 'librariesgrid_id'
            },
            dockedItems: Ext.create('Tree.Footer.BackupLibrary', {})
		});
		Ext.getCmp('centercenter').add(reswin);
		reswin.show();
	} else {
		reswin.show();
	}
}
// data section criteria
function migrateStep1(page) {
    popupHide();
	var reswin  = Ext.getCmp('migratestep1');
	var cregion = Ext.getCmp('centercenter');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'migratestep1',
			title: $$('Data Transfer Assistant'),
			height: 550,
			width: 720,
			border: false,
			modal : true,
			renderTo: 'centercenter',
			closeAction: 'hide',
			constrain: true,
            layout: 'fit',
            border: 1,
            items: [{
				xtype : "component",
				autoEl : {
					tag: "iframe",
					name: 'migrateframe1',
					frameBorder: 0
				}
            }]
		});
		cregion.add(reswin);
		reswin.show();

	    document.windowForm.action = page;
	    document.windowForm.target = 'migrateframe1';
	    document.windowForm.submit();
	} else {
		reswin.show();
	}
}
// set start time
function timeWindow(callback) {
    popupHide();
	var reswin = Ext.getCmp('timepanel');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'timepanel',
			title: $$('Select a Time'),
			height: 160,
			width: 250,
        	layout:'fit',
        	resizable: false,
        	border: false,
			renderTo: 'centercenter',
			constrain: true,
			items: {
                xtype: 'timeform',
                id: 'timeform_id',
                buttons: [{
                    text: $$('Cancel'),
                    handler: function() {
                        this.up().up().up().close();
                    }
                },{
                    text: $$('Select'),
                    handler: function() {
                        var starttime = Ext.getCmp('timeform_id').getForm().findField('starttime').getValue();
                        if (starttime) {
                            callback(Ext.Date.format(starttime, 'G:i'))
                        }
                        this.up().up().up().close();
                    }
                }]		
			}
		});
		Ext.getCmp('centercenter').add(reswin);
		reswin.show();
	} else {
		reswin.show();
	}
}            

// set start time
function intervalWindow(callback) {
    popupHide();
	var reswin = Ext.getCmp('timepanel');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'intervalpanel',
			title: $$('Select an Interval'),
			height: 130,
			width: 220,
        	layout:'fit',
        	resizable: false,
        	border: false,
			renderTo: 'centercenter',
			constrain: true,
			items: {
                xtype: 'intervalform',
                id: 'intervalform_id',
                buttons: [{
                    text: $$('Cancel'),
                    handler: function() {
                        this.up().up().up().close();
                    }
                },{
                    text: $$('Select'),
                    handler: function() {
                        var sec  = Ext.getCmp('intervalform_id').getForm().findField('starttime').getValue();
                        var vsec = Ext.getCmp('intervalform_id').getForm().findField('starttime').getRawValue();
                        if (sec) {
                            callback(sec,vsec)
                        }
                        this.up().up().up().close();
                    }
                }]		
			}
		});
		Ext.getCmp('centercenter').add(reswin);
		reswin.show();
	} else {
		reswin.show();
	}
}            

// select target for Backup and Archive
function targetWindow() {
    popupHide();
	var reswin = Ext.getCmp('selecttargetpanel');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'selecttargetpanel',
			title: $$('Select Storage Type'),
			height: 100,
			//width: 500,
        	resizable: false,
			renderTo: 'centercenter',
			constrain: true,
            layout: {
                type: 'hbox',
                padding: '5',
                align: 'middle',
            },
            defaults:{
                xtype: 'button',
                padding: '4 15 4 15',
                margin: '0 5 0 0',
                flex: 1
            },
            items:[{
                text: $$('Cloud object storage'),
                handler: function() {
                    this.up().close();
                    cloudWizard();
                }
            },{
                text: $$('Local disk storage'),
                handler: function() {
                    this.up().close();
                    containerWizard();
                }
            },{
                text: $$('Single Tape Drive'),
                handler: function() {
                    this.up().close();
                    tapeWindow();
                }
            },{
                text: $$('Tape Library'),
                margins: '0',
                handler: function() {
                    this.up().close();
                    libraryWindow();
                }
            }]
		});
		Ext.getCmp('centercenter').add(reswin);
		reswin.show();
	} else {
		reswin.show();
	}
}            
        
function nextstep(current,next) {
    document.getElementById(current).style.display = 'none';
    document.getElementById(next).style.display = 'block';
}
function setBackupSource(client,path) {
    document.getElementById('selectdata_id').style.display = 'none';
    document.getElementById('changesourcepath_id').innerHTML = client +': '+path;
    document.getElementById('changedata_id').style.display = 'block';
    document.getElementById('continue_1d_id').style.display = 'none';
    document.getElementById('continue_1a_id').style.display = 'block';
    document.wizardForm.sourceclient.value = client
    document.wizardForm.sourcepath.value = path
}
function setBackupTarget(storage,path) {
    document.getElementById('selectdrive_id').style.display = 'none';
    document.getElementById('changetargetpath_id').innerHTML = storage +': '+path;
    document.getElementById('changedrive_id').style.display = 'block';
    document.getElementById('continue_2d_id').style.display = 'none';
    document.getElementById('continue_2a_id').style.display = 'block';
    document.wizardForm.targetstorage.value = storage
    document.wizardForm.targetdevice.value = path
}
function setStartTime(startime) {
    document.getElementById('selecttime_id').style.display = 'none';
    document.getElementById('changestarttime_id').innerHTML = 'Start Time: '+startime;
    document.getElementById('changetime_id').style.display = 'block';
    document.getElementById('continue_3d_id').style.display = 'none';
    document.getElementById('continue_3a_id').style.display = 'block';
    document.wizardForm.starttime.value = startime
}
function setSyncTarget(client,path) {
    if ( document.wizardForm.sourceclient.value == client && document.wizardForm.sourcepath.value == path ) {
        extAlert(2,'Source and target path must be different.');
        return;
    }
    document.getElementById('selecttarget_id').style.display = 'none';
    document.getElementById('changetargetpath_id').innerHTML = client +': '+path;
    document.getElementById('changetarget_id').style.display = 'block';
    document.getElementById('continue_2d_id').style.display = 'none';
    document.getElementById('continue_2a_id').style.display = 'block';
    document.wizardForm.targetclient.value = client
    document.wizardForm.targetpath.value = path
}
function setInterwal(sec,vsec) {
    document.getElementById('selecttime_id').style.display = 'none';
    document.getElementById('changestarttime_id').innerHTML = 'Interval: '+vsec;
    document.getElementById('changetime_id').style.display = 'block';
    document.getElementById('continue_3d_id').style.display = 'none';
    document.getElementById('continue_3a_id').style.display = 'block';
    document.wizardForm.starttime.value = sec;
}
function createBackup() {
    Ext.getBody().mask($$('Preparing backup configuration ...'), 'loading')
    Ext.Ajax.request({
        url: setup_assistant,
        timeout: 600000,
        method: 'POST',
        params: { 
            caller: 'ajaxCreateBackup',
    	    sourceclient: document.wizardForm.sourceclient.value,
    	    sourcepath: document.wizardForm.sourcepath.value,
    	    targetstorage: document.wizardForm.targetstorage.value,
    	    targetdevice: document.wizardForm.targetdevice.value,
    	    starttime: document.wizardForm.starttime.value,
    	    objStore: document.wizardForm.objStore.value,
    	    baseDir: document.wizardForm.baseDir.value,
    	    sizegb: document.wizardForm.sizegb.value,
    	    clonedPool: document.wizardForm.clonedPool.value
        },
        scope: this,
        failure: function(){
            Ext.getBody().unmask();
            extAlert(1,'Could not connect to server')
        }, 
        success:function(response, options) {
            var XMLdata = response.responseXML;
            // try to fetch values for page status and message
            var attention = DQ.selectValue('attention', XMLdata);
            var message   = DQ.selectValue('message', XMLdata);
            if (typeof attention == 'undefined') {
                extAlert(1,$$('Server communication error. (Invalid XML message)'))
            } else if (attention > 0 ) {
                extAlert(attention,message)
            }
            Ext.getBody().unmask();
            if (attention == 0 ) {
                document.wizardForm.plan.value = DQ.selectValue('plan', XMLdata);
                document.getElementById('completetbackupplan_id').innerHTML = DQ.selectValue('plantext', XMLdata);
                document.getElementById('completesourcepath_id').innerHTML = DQ.selectValue('source', XMLdata);
                document.getElementById('completetargetpath_id').innerHTML = DQ.selectValue('target', XMLdata);
                document.getElementById('completestarttime_id').innerHTML  = DQ.selectValue('start', XMLdata);
                document.getElementById('step_4_startnow_id').style.display = 'block';
                nextstep('step_3_id','step_4_id');
            }
        }
    });
}
function startBackup() {
    Ext.getBody().mask($$('Starting backup now ...'), 'loading')
    Ext.Ajax.request({
        url: setup_assistant,
        timeout: 600000,
        method: 'POST',
        params: { 
            caller: 'ajaxStartBackup',
    	    plan: document.wizardForm.plan.value
        },
        scope: this,
        failure: function(){
            Ext.getBody().unmask();
            extAlert(1,'Could not connect to server')
        }, 
        success:function(response, options) {
            Ext.getBody().unmask();
            var XMLdata = response.responseXML;
            // try to fetch values for page status and message
            var attention = DQ.selectValue('attention', XMLdata);
            var message   = DQ.selectValue('message', XMLdata);
            if (typeof attention == 'undefined') {
                extAlert(1,$$('Server communication error. (Invalid XML message)'))
            } else if (attention > 0 ) {
                extAlert(attention,message)
            }
            if (attention == 0 ) {
                document.getElementById('step_4_startnow_id').style.display = 'none';
                document.getElementById('step_4_monitor_id').style.display = 'block';
            }
        }
    });
}
function createArchive() {
    Ext.getBody().mask($$('Preparing archive configuration ...'), 'loading')
    Ext.Ajax.request({
        url: setup_assistant,
        timeout: 600000,
        method: 'POST',
        params: { 
            caller: 'ajaxCreateArchive',
    	    targetstorage: document.wizardForm.targetstorage.value,
    	    targetdevice: document.wizardForm.targetdevice.value,
    	    starttime: document.wizardForm.starttime.value,
    	    objStore: document.wizardForm.objStore.value,
    	    baseDir: document.wizardForm.baseDir.value,
    	    sizegb: document.wizardForm.sizegb.value,
    	    clonedPool: document.wizardForm.clonedPool.value
        },
        scope: this,
        failure: function(){
            Ext.getBody().unmask();
            extAlert(1,'Could not connect to server')
        }, 
        success:function(response, options) {
            var XMLdata = response.responseXML;
            // try to fetch values for page status and message
            var attention = DQ.selectValue('attention', XMLdata);
            var message   = DQ.selectValue('message', XMLdata);
            if (typeof attention == 'undefined') {
                extAlert(1,$$('Server communication error. (Invalid XML message)'))
            } else if (attention > 0 ) {
                extAlert(attention,message)
            }
            Ext.getBody().unmask();
            if (attention == 0 ) {
                document.getElementById('completetarchiveplan_id').innerHTML = DQ.selectValue('plan', XMLdata);
                document.getElementById('completetargetpath_id').innerHTML = DQ.selectValue('target', XMLdata);
                nextstep('step_1_id','step_2_id');
            }
        }
    });
}
function createSync() {
    Ext.getBody().mask($$('Preparing synchronize configuration ...'), 'loading')
    Ext.Ajax.request({
        url: setup_assistant,
        timeout: 600000,
        method: 'POST',
        params: { 
            caller: 'ajaxCreateSync',
    	    sourceclient: document.wizardForm.sourceclient.value,
    	    sourcepath: document.wizardForm.sourcepath.value,
    	    targetclient: document.wizardForm.targetclient.value,
    	    targetpath: document.wizardForm.targetpath.value,
    	    starttime: document.wizardForm.starttime.value
        },
        scope: this,
        failure: function(){
            Ext.getBody().unmask();
            extAlert(1,'Could not connect to server')
        }, 
        success:function(response, options) {
            var XMLdata = response.responseXML;
            // try to fetch values for page status and message
            var attention = DQ.selectValue('attention', XMLdata);
            var message   = DQ.selectValue('message', XMLdata);
            if (typeof attention == 'undefined') {
                extAlert(1,$$('Server communication error. (Invalid XML message)'))
            } else if (attention > 0 ) {
                extAlert(attention,message)
            }
            Ext.getBody().unmask();
            if (attention == 0 ) {
                document.wizardForm.plan.value = DQ.selectValue('plan', XMLdata);
                document.getElementById('completetbackupplan_id').innerHTML = DQ.selectValue('plantext', XMLdata);
                document.getElementById('completesourcepath_id').innerHTML = DQ.selectValue('source', XMLdata);
                document.getElementById('completetargetpath_id').innerHTML = DQ.selectValue('target', XMLdata);
                document.getElementById('completeinterval_id').innerHTML  = DQ.selectValue('interval', XMLdata);
                document.getElementById('step_4_startnow_id').style.display = 'block';
                nextstep('step_3_id','step_4_id');
            }
        }
    });
}
function startSync() {
    Ext.getBody().mask($$('Starting sync now ...'), 'loading')
    Ext.Ajax.request({
        url: setup_assistant,
        timeout: 600000,
        method: 'POST',
        params: { 
            caller: 'ajaxSyncBackup',
    	    plan: document.wizardForm.plan.value
        },
        scope: this,
        failure: function(){
            Ext.getBody().unmask();
            extAlert(1,'Could not connect to server')
        }, 
        success:function(response, options) {
            Ext.getBody().unmask();
            var XMLdata = response.responseXML;
            // try to fetch values for page status and message
            var attention = DQ.selectValue('attention', XMLdata);
            var message   = DQ.selectValue('message', XMLdata);
            if (typeof attention == 'undefined') {
                extAlert(1,$$('Server communication error. (Invalid XML message)'))
            } else if (attention > 0 ) {
                extAlert(attention,message)
            }
            if (attention == 0 ) {
                document.getElementById('step_4_startnow_id').style.display = 'none';
                document.getElementById('step_4_monitor_id').style.display = 'block';
            }
        }
    });
}
//# functions for browser_tree to show release notes
function showStart(eButton) {
	popupHide();
	var homepage  = document.dataForm.home_starter.value;
	if ( document.resourceForm.notesFlag.checked == true ) {
		var notesFlag = document.resourceForm.notesFlag.value;
	} else {
        var notesFlag = "";
	}
	//remove fix bottom bar as div element because it is not controlled by EXT
	rmDiv('wstreebody');
	rmDiv('loaderdiv');
	rmDiv('fixButton');
	Ext.getCmp('centercenter').removeAll();
	waitBox('centerdata');
	var tmpdiv = getTempDiv('loaderdiv');
	//load data into div element
	tmpdiv.load({
		url:homepage,
		scripts:true,
		success: function(){
			hideWait();
		},
		failure: function(){
			extAlert(1,'Could not connect to server')
		}, 
		params:{
			caller: 'releaseNotes',
			notesFlag: notesFlag
		}
	});
	// create panel for scrolling
	var myPanel = Ext.create('Ext.panel.Panel', {
		contentEl: 'loaderdiv',
		layout: 'fit',
		autoScroll: true,
		border: false
	});
	//add panel to region
	Ext.getCmp('centercenter').add(myPanel);
}
//# Function to show the notification
function startNotification() {
    popupHide();
    var reswin = Ext.getCmp('notificationpanel');
    if(!reswin) {
        var reswin = Ext.create('Ext.window.Window', {
            id: 'notificationpanel',
            title: "Notifications",
            height: 400,
            width: 500,
            resizable: true,
            renderTo: 'centercenter',
            constrain: true,
            autoScroll: true,
            layout: 'fit',
			listeners: {
				beforeshow: function(win) {
					store_notification.load();
				}
			},
        	items: [{
                xtype: 'notificationgrid',
            }],
            buttons:[/*{xtype: 'tbspacer' },{
                xtype: 'label',
                autoEl: {
                    tag: 'a',
                    html: 'Dismiss all',
                    href: 'JavaScript:close()'
                },     
            },*/{xtype: 'tbfill' },{
                text: 'Close',
                handler: function() {
                    this.up().up().close();
                }
            }]
        });
        Ext.getCmp('centercenter').add(reswin);
        reswin.showAt(10,20);
    } else {
        reswin.show();
    }
}
function dismissNote(record) {
    Ext.Ajax.request({
        url: setup_assistant,
        timeout: 600000,
        method: 'POST',
        params: { 
            caller: 'ajaxDismissNotification',
    	    notification: record.get('id')
        },
        scope: this,
        failure: function(){
            extAlert(1,'Could not connect to server')
        }, 
        success:function(response, options) {
            console.log('Dismiss Notification Okay');
            store_notification.load();
        }
    });
}
 
