Ext.define("P5Jobmanager.view.ScheduledJobsGrid", {
    extend: 'Ext.grid.Panel',
    alias: "widget.scheduledjobsgrid",

    applyState: function(state) {
        // disable stateful sorters and filters
        // ist a workaround for stateful "getViewModel() is null"
        state.sort = false;
        state.storeState = false;
        this.callParent(arguments);
    },

    bind:{
        store: '{scheduledqueuestore}'
    },
    reference: 'scheduledjobsgrid_ref',
    itemId: 'scheduledjobsgrid_id',

    viewConfig: {
        loadMask: false,
        preserveScrollOnReload: true,
        preserveScrollOnRefresh: true
    },

    flex: 1,

    columns: [{
        xtype: 'actioncolumn',
        menuDisabled : true,
        width: 30,
        align:'center',
        stopSelection: false,
        listeners: { click: 'onContextMenuQueued' },
    },{
        dataIndex: 'jtype',
        align: 'center',
        text: '',
        menuDisabled : true,
        width: 22,
        renderer: function(value,metaData,record) {
            switch(value) {
                case 'archivejob':
                    metaData.tdCls = 'archivejob-icon';
                    break;
                case 'backupjob':
                    metaData.tdCls = 'backupjob-icon';
                    break;
                case 'backup2gojob':
                    metaData.tdCls = 'backup2gojob-icon';
                    break;
                case 'syncjob':
                    metaData.tdCls = 'syncjob-icon';
                    break;
                case 'migrationjob':
                    metaData.tdCls = 'migrationjob-icon';
                    break;
                case 'restorejob':
                    metaData.tdCls = 'restorejob-icon';
                    break;
                default:
                    metaData.tdCls = 'otherjob-icon';
            }
        }
    },{ text: $$('Scheduled by Time'), dataIndex: 'text', width: 200
    },{ text: $$('Client'), dataIndex: 'client', width: 80
    },{ text: $$('User'), dataIndex: 'owner', width: 80
    },{ text: $$('Level'), dataIndex: 'level', width: 60
    },{ text: $$('Pool'), dataIndex: 'pool', width: 80
    },{ 
        text: $$('Start Time'),
        dataIndex: 'start',
        width: 90,
        xtype: 'datecolumn',
        format: Ext.Date.patterns['formatTimeShort']
    },{
        text: $$('Job'),
        dataIndex: 'jobid',
        flex: 1
    }],
});