Ext.define('P5Jobmanager.view.MainView', {
    extend: 'Ext.container.Viewport',
    alias: 'widget.mainview',

    requires: [
        'P5Jobmanager.view.MainViewViewModel',
        'P5Jobmanager.view.MainViewViewController',
        'P5Jobmanager.view.JobmonitorGrids',
        'P5Jobmanager.view.ScheduledJobsGrid',
        'P5Jobmanager.view.JoblogGrids',
        'P5Jobmanager.view.ConfigRegion'
    ],

    controller: "mainview",

    viewModel: {
        type: 'mainview'
    },
    
    layout: 'border',
    items: [{
        header: false,
        xtype: 'configregion',
        region:'west',
        stateId: 'stateConfigregion_id',
        stateful: true,
        split: true,
        collapsed: false,
        collapsible: true,
        floatable: true,
        border: false,
    },{
        xtype: 'container',
        region: 'center',
        itemId: 'mainRegion',
        layout: 'border',
        border: false,
        items: [{
            xtype: 'scheduledjobsgrid',
            cls: 'jobmonitor-grid',
            region: 'north',
            stateId: 'stateScheduledjobsgrid_id',
            stateful: true,
            title: $$('Queued Jobs'),
            headerPosition: 'left',
            collapsible: true,
            titleCollapse: true,
            flex: 1,
            border: false,
            split: true
        },{
            xtype: 'jobmonitorgrids',
            cls: 'jobmonitor-grid',
            region: 'center',
            title: $$('Running Jobs'),
            headerPosition: 'left',
            flex: 1,
            border: false,
            split: true
        },{
            xtype: 'jobloggrids',
            cls: 'joblog-grid',
            region: 'south',
            stateId: 'stateJobloggrids_id',
            stateful: true,
            title: $$('Finished Jobs'),
            headerPosition: 'left',
            collapsible: true,
            titleCollapse: true,
            flex: 1,
            border: false,
            split: true
        }]
    }]
});