Ext.define("P5Jobmanager.model.JobmonitorListing", {
    extend: "Ext.data.Model",
    idProperty: "id",
    schema: {
        namespace: "P5Jobmanager.model"
    },

    fields: [{
        name: 'id',
        type: 'string'
    },{
        name: 'jtype',
        type: 'string'
    },{
        name: 'queue',
        type: 'string'
    },{
        name: 'order',
        type: 'number'
    },{
        name: 'title',
        type: 'string'
    },{
        name: 'status',
        type: 'string'
    },{
        name: 'client',
        type: 'string'
    },{
        name: 'pool',
        type: 'string'
    },{
        name: 'level',
        type: 'string'
    },{
        name: 'start',
        type: 'date',
        dateFormat: 'U'
    },{
        name: 'jobid',
        type: 'number'
    },{
        name: 'state',
        type: 'string'
    },{
        name: 'owner',
        type: 'string'
    },{
        name: 'reports',
        type: 'string'
    },{
        name: 'report',
        type: 'string'
    },{
        name:'shownreport',
        persist:false,
        convert:function(v, record){
            var jobid = record.getData().id;
            if ( P5Jobmanager.globals.jobid.indexOf(jobid) > -1 ) {
                return record.getData().report;
            } else {
                return record.getData().reports;
            }
        }
    },{
        name: 'numFiles',
        type: 'number'
    },{
        name: 'numKbytes',
        type: 'number'
    }],
    proxy:{
        type:'ajax',
        url: P5Jobmanager.globals.serverpage,
        actionMethods:{
             read:'GET'
        },
        extraParams: {
            tdp: 'jobmonitor',
            caller: 'ajaxGetRunning',
        },
        reader:{
            type:'json',
            rootProperty:'data'
        }
    }
});