Ext.define('P5idx.view.IdxFilePicker', {
    extend: 'Ext.window.Window',
    alias: 'widget.idxfilePicker',

    controller: "idxfilepicker",
    viewModel: {
        type: "idxfilepicker"
    },

    bind:{
        title: '{panelTitle}'
    },

	height: 380,
	width: 600,
	border: false,
	layout: 'border',
	modal: true,
	items: [{
        region: 'west',
        xtype: 'idxclienttabpanel',
        itemId: 'idxclienttabpanel_id',
        collapsible: true,
        collapseMode: 'mini',
        collapsed: true,
        preventHeader: true,
        split: true,
        width: 130,
        layout: 'fit'
    }, {
		region: 'center',
		xtype: 'idxservervolumegrid',
		itemId: 'idxservervolumegrid_id',
        reference: 'idxservervolumegrid_ref',
		flex: 1,
		layout: 'fit'
	}, {
		region: 'east',
		xtype: 'idxfoldercontentgrid',
		itemId: 'idxfoldercontentgrid_id',
        reference: 'idxfoldercontentgrid_ref',
		split: true,
		flex: 2,
		layout: 'fit'
	}],
	dockedItems: [{
		xtype: 'idxfilepickerfooter',
		dock: 'bottom',
		ui: 'footer'
	}]        
});
Ext.define('P5idx.view.IdxFilePicker2', {
    extend: 'Ext.window.Window',
    alias: 'widget.idxfilePicker2',

    controller: "idxfilepicker",
    viewModel: {
        type: "idxfilepicker"
    },

    bind:{
        title: '{panelTitle}'
    },

	height: 380,
	width: 600,
	border: false,
	layout: 'border',
	modal: true,
	items: [{
		region: 'center',
		xtype: 'idxfoldercontentgrid',
		itemId: 'idxfoldercontentgrid2_id',
        reference: 'idxfoldercontentgrid_ref',
		flex: 1,
		layout: 'fit'
	}],
	dockedItems: [{
		xtype: 'idxfilepickerfooter2',
		dock: 'bottom',
		ui: 'footer'
	}]        
});
Ext.define('P5idx.view.IdxClientTabpanel', {
    extend: 'Ext.grid.Panel',
    alias : 'widget.idxclienttabpanel',

    multiSelect: false,
    border: true,
    columns: [{ dataIndex: 'id', hidden: true },{ header: $$('P5 Client'), dataIndex: 'text', flex: 1 }],
    bind:{
        store: '{clientstore}'
    }
});

Ext.define('P5idx.view.IdxServerVolumeGrid', {
    extend: 'Ext.tree.Panel',
    alias : 'widget.idxservervolumegrid',

	useArrows: true,
	rootVisible: false,
	multiSelect: false,
	columns: [{ text: $$('Disk Volumes'), dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
    bind:{
        store: '{servervolumestore}'
    },
});    
Ext.define('P5idx.view.IdxFolderContentGrid', {
    extend: 'Ext.tree.Panel',
    alias : 'widget.idxfoldercontentgrid',

    selModel: {
        mode: 'SINGLE',
        allowDeselect: false
    },

	padding: '0 0 0 0',
	useArrows: true,
	singleExpand: true,
	rootVisible: false,
	border: true,
	columns: [{ text: $$('Folder'), dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
    bind:{
        store: '{foldercontentstore}'
    }
});
Ext.define('P5idx.view.IdxFilePickerFooter', {
	extend: 'Ext.Toolbar',
    alias : 'widget.idxfilepickerfooter',

	defaults: {
		xtype : 'button',
		padding: '5 15 5 15'
	},
	items: [{
        xtype: 'button',
        text: $$('Clients')+' ...',
        enableToggle: true,
        bind:{
            hidden: '{btnHiddenP5Client}',
        },            
        handler: 'onWriteClientToggel'
	},{ xtype: 'tbfill' },{
		xtype: 'button',
		text: $$('New Folder ...'),
        handler: 'onNewFolder',
	},{ 
        xtype: 'tbspacer',
        width: 50
	},{ 
		xtype: 'button',
		text: $$('Cancel'),
		handler: function() {
			this.up().up().close();
		}
	},{
		xtype: 'button',
        bind:{
            handler: '{btnSelectHandler}',
            disabled: '{btnSelectEnable}',
		    text: '{btnSelectTxt}'
        }                
	}]
});
Ext.define('P5idx.view.IdxFilePickerFooter2', {
	extend: 'Ext.Toolbar',
    alias : 'widget.idxfilepickerfooter2',

	defaults: {
		xtype : 'button',
		padding: '5 15 5 15'
	},
	items: [{
		xtype: 'button',
		text: $$('Cancel'),
		handler: function() {
			this.up().up().close();
		}
	},{
		xtype: 'button',
        bind:{
            handler: '{btnSelectHandler}',
            disabled: '{btnSelectEnable}',
		    text: '{btnSelectTxt}'
        }                
	}]
});
