Ext.define('P5U.controller.Information', {
    extend: 'Ext.app.Controller',

	init: function(){
		var me = this;
        me.control({
            'viewport > #CenterRegion': {
                 render: this.onPanelRendered
             },
            '#infoRegionWest_id': {
                 render: this.onInfoRegionWestReady,
                 expand: this.onPanelExpand
             },
            '#infoRegionCenter_id': {
                 render: this.onInfoRegionCenterReady
             },
            'infoForm button[action=submit]': {
                click: this.submitFormData
            },
            '#infoWindow_id button[action=assetMailTo]': {
                click: this.assetMail
            },
            '#infoWindow_id button[action=assetCopyLink]': {
                click: this.assetLink
            },
            '#infoWindow_id button[action=restoreWin]': {
                click: this.preRestoreCheck
            },
            'versiongrid': {
                select: this.changeBtime,
                viewready: function(gird) {
                	console.log('Versiongrid Ready');
                	me.myVersiongrid = gird;
                }
            },
            'indexcontentgrid': {
                select: this.onSelectContentgrid
            }
		});
	},
    onPanelExpand: function(obj) {
		console.log('Index Panel Expand');
		var panel_tree = Ext.ComponentQuery.query('#indexcontentgrid_id')[0];
        var node = panel_tree.store.getNodeById(P5U.globals.assetUrl);
        // select and check row/node
		panel_tree.getSelectionModel().select([node],0,1);
		node.set('checked', true);
		// scroll selected in focus
		var iy = panel_tree.getSelectionModel().getSelection()[0];
		var row = panel_tree.store.indexOf(iy);
		panel_tree.getView().focusRow(row);
    },
    onPanelRendered: function(obj) {
		console.log('Wiewport ready');
		var me = this;
		me.myCenterRegion = obj;
		me.getEnvironment(P5U.globals.nodeUrl, me.onEnvironmentReady);
    },
    getEnvironment: function(elementUrl, callnext){
		var me = this;
		console.log('Get Environment');
		console.log(P5U.globals.serverpage);
		console.log(P5U.globals.modus);
		Ext.Ajax.request({
			url: P5U.globals.serverpage,
			method: 'POST',
			params: { 
				caller: 'ajaxEnvironment',
				node: elementUrl,
				modus: P5U.globals.modus
			},
			scope: me,
			success: function(result, request) {
    			console.log('Environment store loaded');
    			try {
					var json = Ext.decode(result.responseText);
					console.log(json)
					// as long as no better address comes from server
					P5U.globals.linkHost  = window.location.host;
					P5U.globals.treetype  = json.treetype;
					P5U.globals.database  = json.database;
					P5U.globals.parentUrl = json.parentUrl;
					P5U.globals.parentName   = json.parentName;
					P5U.globals.parentPath   = json.parentPath;
					P5U.globals.parentClient = json.parentClient;
					P5U.globals.allowRestore  = json.allowRestore;
					P5U.globals.allowEdit     = json.allowEdit;
					P5U.globals.allowRelocate = json.allowRelocate;
				} catch (e) {
					alert($$('Server session has expired.'))
				}
			},
			callback: callnext,
			failure: function(result, request) {
				Ext.MessageBox.alert('Failed', result.responseText);
			}
		});
    },
    onEnvironmentReady: function() {
		var me = this;
		// load Metadata Form elements and create infowindow
		me.getStore('MetadataForm').load(function(records, operation, success) {
    		console.log('MetadataForm store loaded');
            me.onLoad(this);
		});
    },
    onInfoRegionCenterReady: function(infoRegionCenter) {
		var me = this;
    	console.log('Info Window Center Panel Ready'); 
		infoRegionCenter.add(me.myInfoWindow);
		// load version store
		me.getStore('Versions').load({
			params: {
				node: P5U.globals.nodeUrl
			},
			callback:function(records, operation, success){
    			console.log('Versions store loaded');
    			var rec = this.find('elementurl',P5U.globals.nodeUrl);
    			console.log('Select version '+ P5U.globals.nodeUrl);
    			me.myVersiongrid.getSelectionModel().select(rec);
			}
		});
    },
    setInfoWindowTitel: function() {
    	// set window title
    	var win = Ext.ComponentQuery.query('#infoRegionCenter_id')[0];
		win.setTitle(P5U.globals.assetname);
		// enable Restore Button
		var bbar = win.up().down('infoWindowFooter')
        var applybtn = Ext.ComponentQuery.query('#editmetadata_id')[0];
        if (typeof applybtn != 'undefined') {
		    applybtn.setHidden(!P5U.globals.allowEdit);
		}
		bbar.down('#restore_id').setDisabled(!P5U.globals.allowRestore);
    },
    onInfoRegionWestReady: function(win) {
		var me = this;
    	console.log('Info Window West Panel Ready'); 
		var nwin = Ext.widget({
			xtype: 'indexcontentgrid',
			itemId: 'indexcontentgrid_id',
		});
		win.add(nwin);
		nwin.show();
		// load directory content form parent node of selected eleement
        var panel_tree = Ext.ComponentQuery.query('#indexcontentgrid_id')[0];
        if (typeof panel_tree != 'undefined') {
            var tree_store = panel_tree.getStore();
		    tree_store.removeAll();
            tree_store.setRootNode();
            //panel_tree.setRootNode(null);
            var newRoot = {
                name: P5U.globals.parentName,
                id: P5U.globals.parentUrl,
                path: '/',
                expanded: true
            }
            tree_store.proxy.extraParams.snapshot = P5U.globals.snapshot;
            tree_store.setRootNode(newRoot);
        }
    },
    submitFormData: function(obj) {
		this.myInfoWindow.down('infoForm').myUpdate();
    },
    changeBtime: function(view, record) {
		var me = this;
		console.log('Change Backup Time');
		P5U.globals.assetUrl = record.data.elementurl;
		P5U.globals.assetname = record.data.name;
		P5U.globals.assetid   = record.data.addr;
		P5U.globals.previous = P5U.globals.snapshot
		P5U.globals.snapshot = record.data.snapshot;
		P5U.globals.instance = record.data.instance;
		// set window title
		me.setInfoWindowTitel();
    	if ( P5U.globals.treetype == 'AsxTree' ) {
			//reload metadata
			this.myInfoWindow.down('infoForm').myLoad(P5U.globals.assetUrl);
			//reload preview
			var store_preview = Ext.getStore('Preview');
			store_preview.proxy.extraParams.node = P5U.globals.assetUrl;
			store_preview.load();
		}
    },    
    assetMail: function(obj) {
		var me = this;
    	console.log('Mail to');
		var eurl = escape('http://' + P5U.globals.linkHost + '/lexxapp?u_app=user_app&u_task=info&u_db=' + P5U.globals.database + '&u_id='+ P5U.globals.assetid + '&modus=search');
		if ( P5U.globals.treetype == 'AsxTree'  ) {
			var subjtxt = $$('Archive information for')+': '
			var bodytxt = $$('For details about the archived asset, click the following link')+': '
		} else {
			var subjtxt = $$('Backup information for')+': '
			var bodytxt = $$('For details about the backup file, click the following link')+': '
		}
		console.log(P5U.globals.assetname);
		var subj = encodeURIComponent(subjtxt + P5U.globals.assetname);
		console.log(subj);
		var body = escape(bodytxt);
    	window.location = 'mailto:?body=%0A'+body+'%0A'+eurl+'&subject='+subj
    },
    assetLink: function(obj) {
		var me = this;
    	console.log('Copy link to clipboard');
		var eurl = 'http://' + P5U.globals.linkHost + '/lexxapp?u_app=user_app&u_task=info&u_db=' + P5U.globals.database + '&u_id='+ P5U.globals.assetid + '&modus=search';
        const elem = document.createElement('textarea');
        elem.value = eurl;
        document.body.appendChild(elem);
        elem.select();
        document.execCommand('copy');
        document.body.removeChild(elem);
        Ext.toast({ html: 'Link copied to the clipboard', align: 'b' });   
    },
    preRestoreCheck: function() {
		var me = this;
    	console.log('Check if restore is already running');
    	var panel_tree = Ext.ComponentQuery.query('#indexcontentgrid_id')[0];
		P5U.globals.selectedelements = [];
		P5U.globals.selectednames    = [];
		P5U.globals.selectedname     = '';
    	if (typeof panel_tree != 'undefined') {    	
			var records = panel_tree.getView().getChecked();
			Ext.Array.each(records, function(rec){
				P5U.globals.selectedelements.push(rec.get('id'));
				P5U.globals.selectednames.push(rec.get('name'));
			});
        }	
		if ( P5U.globals.selectedelements.length == 0 ) {
		    P5U.globals.selectedelements = [P5U.globals.assetUrl];
		    P5U.globals.selectednames    = [P5U.globals.assetname];
		    P5U.globals.selectedname     = P5U.globals.assetname;
		} else if ( P5U.globals.selectedelements.length == 1 ) {
		    P5U.globals.selectedname = P5U.globals.selectednames[0]
		} else {
		    P5U.globals.selectedname = P5U.globals.selectednames[0] + ', ...'
		}
		
		Ext.Ajax.request({
			url: P5U.globals.serverpage,
			method: 'POST',
			params: { 
				caller: 'ajaxIsRestoreRunning',
				node: P5U.globals.assetUrl,
				selectedelements: Ext.encode(P5U.globals.selectedelements),
				snapshot: P5U.globals.snapshot,
				instance: P5U.globals.instance
			},
			scope: me,
			success: function(result, request) {
				P5U.restoreStatus = Ext.decode(result.responseText);
				if ( P5U.restoreStatus.isrunnning ) {
					console.log(P5U.restoreStatus.isrunnning);
					me.getController('Restore').onRestoreStatus();
				} else {
					me.getController('Restore').onRestoreWindow();
				}
			},
			failure: function(result, request) {
				Ext.MessageBox.alert('Failed', result.responseText);
			}
		});
    },
	onSelectContentgrid: function(view, record, opt){
		var me = this;
		// load version store
		me.getStore('Versions').load({
			params: {
				node: record.data.id
			},
			callback:function(records, operation, success){
    			console.log('Versions store loaded');
    			var rec = this.find('elementurl',record.data.id);
    			console.log('Select version '+ record.data.id);
    			me.myVersiongrid.getSelectionModel().select(rec);
			}
		});
	},
	onLaunch: function(){
		console.log('Launch ready');
	},
    onLoad: function(store, records) {
		var md_items  = [];
		var md_fields = [];
		store.each(function(rec){
			var md_item  = {};
			if ( rec.get('itype') == 'dropdown' ) {
				md_item['xtype'] = 'combo';
				md_item['store'] = Ext.decode(rec.get('ilist'));
			} else {
				if ( rec.get('irows') > 1 ) {
					md_item['xtype'] = 'textareafield';
					md_item['rows'] = rec.get('irows');
				} else {
					md_item['xtype'] = 'textfield';
				}
			}
			md_item['fieldLabel'] = rec.get('text');
			md_item['name'] = rec.get('id');

			md_items.push(md_item);
			// all fields for model and store
			md_fields.push(rec.get('id'));
    	});
		var sys_fields = ['sys_name'];
		var all_fields = md_fields.concat(sys_fields)

		// create an model of system/tree fields and metadata field
        Ext.define('P5U.model.Metadata', {
            extend: 'Ext.data.Model',
            fields: all_fields
        });

		var subBut = {
			xtype: 'toolbar',
			//ui: 'footer',
    		items: [{xtype: 'tbfill' },{
    			xtype: 'button',
				text: $$('Apply'),
                itemId: 'editmetadata_id',
                hidden: true,
		        formBind: true,
		        action: 'submit',
		        style: 'padding: 1px 10px 2px 10px',
    		}]
		}
 		
 		md_items.push(subBut);
		var btimeTxt = (P5U.globals.treetype == 'AsxTree') ? $$('Archive Date') : $$('Backup Date')
        this.myInfoWindow = Ext.widget({
     		xtype: 'form',
			frame: true,
			style: { 
				borderTop: '0px',
				borderLeft: '0px',
				borderRight: '0px'
			},
        	items: {
        		xtype: 'infoForm',
				style: 'border: 0px',
				items: [{
					xtype:'fieldset',
					title: $$('Versions'),
					collapsible: true,
					style: 'padding: 2px 5px 5px 10px',
					items: {
                        xtype : 'versiongrid',
						columns: [
							{ dataIndex: 'type', hidden: true },
							{ dataIndex: 'name', hidden: true },
							{ header: btimeTxt, dataIndex: 'btime', width: 95, renderer: eval('renderDate') },
							{ header: $$('Modification Date'), dataIndex: 'mtime', width: 95, renderer: eval('renderDate') },
							{ header: $$('Size'), dataIndex: 'size', width: 60, renderer: eval('calcSizeIdx') },
							{ header: $$('Volume'), dataIndex: 'volume', flex: 2 },
							{ header: $$('Location'), dataIndex: 'location', flex: 1 },
							{ dataIndex: 'volid', hidden: true }
						],
					}
				}]
        	}
        });
    	if ( P5U.globals.treetype == 'AsxTree'  ) {
			this.myInfoWindow.down('infoForm').add([{
				xtype:'fieldset',
				title: $$('Preview'),
				collapsible: true,
				style: 'padding: 0 5px 5px 10px',
				items: {
					xtype: 'mdpreview'
				}
			},{
				xtype:'fieldset',
				title: $$('Metadata'),
				collapsible: true,
				style: 'padding: 0 5px 5px 10px',
				defaults: {
					anchor: '100%',
					//labelWidth: 80,
					labelAlign: 'right',
					//readOnly: true,
					fieldStyle: 'font-size:11px;',
					labelStyle: 'font-size:11px;'
				},
				items: md_items
			}]);
		}
		
		// depending from the index type and from where P5U is started
    	if ( P5U.globals.treetype == 'AsxTree'  ) {
    		// check if app was started standalone
	    	if ( top.opener && top.opener.parent.document.hammerForm ) {
				var nwin = Ext.widget({
					xtype: 'infoWindowIn',
					itemId: 'infoWindow_id',
					//title: $$('Archive information'),
                    maximized: true
				});
			} else {
				// standalone app
				var nwin = Ext.widget({
					xtype: 'infoWindow',
					itemId: 'infoWindow_id',
					//title: $$('Archive information'),
                    maximized: true
				});
			}
    	} else {
			var nwin = Ext.widget({
				xtype: 'infoWindowIn',
				itemId: 'infoWindow_id',
				//title: $$('Backup information'),
                maximized: true
			});
    	}
		nwin.show();
		this.myCenterRegion.add(nwin);
		// show in case of an error the msg box
		var msgwin = Ext.ComponentQuery.query('messagebox')[0];
		if(msgwin) {
			Ext.WindowManager.bringToFront(msgwin);		
		}
    }
});
