##############################################################################
#
# workspace_layout.tcl
#
#    P5 Resource Library
#
#    See the file "license.txt" for information on usage and
#    redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
#    Rcsid: @(#)$Id: workspace_layout.tcl,v 1.260 2019/03/14 10:30:18 jd Exp $
#
##############################################################################

proc getWSLayout { name } {

    set locale [session::browserLanguage]

    switch -exact -- $name {
        HfsTree {
            keylset collayout required   [list type icon name]
            keylset collayout customize  [list mtime size]
            keylset collayout searchable [list]
            keylset collayout pageSize   0 

            keylset collayout type.dataIndex   type
            keylset collayout type.hidden      true

            keylset collayout icon.dataIndex   icon
            keylset collayout icon.hidden      true

            keylset collayout name.dataIndex   name
            keylset collayout name.text        [translate "Name"]
            keylset collayout name.width       250
            keylset collayout name.dataType    string
            keylset collayout name.renderer    renderIconIdx           
            
            keylset collayout mtime.dataIndex  mtime
            keylset collayout mtime.text       [translate "Modification Date"]
            keylset collayout mtime.width      120
            keylset collayout mtime.dataType   date
            keylset collayout mtime.dateFormat "U"
            keylset collayout mtime.renderer   renderDate
            
            keylset collayout size.dataIndex   size
            keylset collayout size.text        [translate "Size"]
            keylset collayout size.width       80
            keylset collayout size.dataType    int
            keylset collayout size.renderer    calcSizeIdx
        }
        BsxTree {
            keylset collayout required          [list type icon name]
            keylset collayout customize         [list mtime size]
            keylset collayout searchable        [list name type mtime size]
            keylset collayout pageSize          200 

            keylset collayout type.dataIndex   type
            keylset collayout type.text        [translate "Type"]
            keylset collayout type.dataType    string
            keylset collayout type.inputType   forFileType
            keylset collayout type.hidden      true

            keylset collayout icon.dataIndex   icon
            keylset collayout icon.hidden      true

            keylset collayout name.dataIndex   name
            keylset collayout name.text        [translate "Name"]
            keylset collayout name.width       250
            keylset collayout name.dataType    string
            keylset collayout name.inputType   ""
            keylset collayout name.renderer    renderIconIdx           

            keylset collayout mtime.dataIndex  mtime
            keylset collayout mtime.text       [translate "Modification Date"]
            keylset collayout mtime.width      120
            keylset collayout mtime.dataType   date
            keylset collayout mtime.dateFormat "U"
            keylset collayout mtime.inputType   ""
            keylset collayout mtime.renderer   renderDate
            
            keylset collayout size.dataIndex   size
            keylset collayout size.text        [translate "Size"]
            keylset collayout size.width       80
            keylset collayout size.dataType    int
            keylset collayout size.inputType   ""
            keylset collayout size.renderer    calcSizeIdx
        }
        AsxTree {
            keylset collayout required   [list type icon name]
            keylset collayout customize  [list btime mtime size]
            keylset collayout searchable [list name type btime mtime size]
            keylset collayout pageSize   200 

            keylset collayout type.dataIndex   type
            keylset collayout type.text        [translate "Type"]
            keylset collayout type.dataType    string
            keylset collayout type.inputType   forFileType
            keylset collayout type.hidden      true

            keylset collayout icon.dataIndex   icon
            keylset collayout icon.hidden      true

            keylset collayout name.dataIndex   name
            keylset collayout name.text        [translate "Name"]
            keylset collayout name.width       250
            keylset collayout name.dataType    string
            keylset collayout name.inputType   ""
            keylset collayout name.renderer    renderIconIdx           
            
            keylset collayout btime.dataIndex  btime
            keylset collayout btime.text       [translate "Archive Date"]
            keylset collayout btime.width      120
            keylset collayout btime.dataType   date
            keylset collayout btime.dateFormat "U"
            keylset collayout btime.inputType  ""
            keylset collayout btime.renderer   renderDate

            keylset collayout mtime.dataIndex  mtime
            keylset collayout mtime.text       [translate "Modification Date"]
            keylset collayout mtime.width      120
            keylset collayout mtime.dataType   date
            keylset collayout mtime.dateFormat "U"
            keylset collayout mtime.inputType  ""
            keylset collayout mtime.renderer   renderDate
            
            keylset collayout size.dataIndex   size
            keylset collayout size.text        [translate "Size"]
            keylset collayout size.width       80
            keylset collayout size.dataType    int
            keylset collayout size.inputType   ""
            keylset collayout size.renderer    calcSizeIdx
            
        }
        WstTree {
            keylset collayout required   [list type icon name path]
            keylset collayout customize  [list mtime size]
            keylset collayout searchable [list]
            keylset collayout pageSize   0 

            keylset collayout type.dataIndex   type
            keylset collayout type.hidden      true

            keylset collayout icon.dataIndex   icon
            keylset collayout icon.hidden      true

            keylset collayout name.dataIndex   name
            keylset collayout name.text        [translate "Name"]
            keylset collayout name.width       250
            keylset collayout name.dataType    string
            keylset collayout name.renderer    renderIconIdx           
            
            keylset collayout mtime.dataIndex  mtime
            keylset collayout mtime.text       [translate "Modification Date"]
            keylset collayout mtime.width      120
            keylset collayout mtime.dataType   date
            keylset collayout mtime.dateFormat "U"
            keylset collayout mtime.renderer   renderDate
            
            keylset collayout size.dataIndex   size
            keylset collayout size.text        [translate "Size"]
            keylset collayout size.width       80
            keylset collayout size.dataType    int
            keylset collayout size.renderer    calcSizeIdx
            
            keylset collayout path.dataIndex   path
            keylset collayout path.dataType    string
            keylset collayout path.hidden      true
        }
        DbsTree {
            keylset collayout col.0.dataIndex type
            keylset collayout col.1.dataIndex text
            keylset collayout col.2.dataIndex description
            keylset collayout col.3.dataIndex mtime
            keylset collayout col.1.text  Name
            keylset collayout col.2.text  Description
            keylset collayout col.3.text  "Modification Date"
            keylset collayout col.1.width 250
            keylset collayout col.2.width 150
            keylset collayout col.3.width 120
            keylset collayout col.3.flex 1
            keylset collayout col.0.hidden true
        }
        WstTreeB2Go {
            keylset collayout sortcol name
            keylset collayout sortdir inc
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field type
            keylset collayout col.2.field name
            keylset collayout col.3.field mtime
            keylset collayout col.4.field size
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  Name
            keylset collayout col.3.text  "Modification Date"
            keylset collayout col.4.text  Size
            keylset collayout col.1.width 15
            keylset collayout col.2.width 250
            keylset collayout col.3.width 150
            keylset collayout col.4.width 150
        }
        FilePicker {
            keylset collayout sortcol name
            keylset collayout sortdir inc
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field type
            keylset collayout col.2.field name
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  Name
            keylset collayout col.1.width 10
            keylset collayout col.2.width 300
        }
        elementversions {
            keylset collayout sortcol mtime
            keylset collayout sortdir inc
            keylset collayout height  15
            keylset collayout top     0
            keylset collayout col.1.field type
            keylset collayout col.2.field name
            keylset collayout col.3.field mtime
            keylset collayout col.4.field btime
            keylset collayout col.5.field size
            keylset collayout col.6.field volid
            keylset collayout col.7.field volid
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  Name
            keylset collayout col.3.text  "Modification Date"
            keylset collayout col.4.text  "Backup/Archive Date"
            keylset collayout col.5.text  Size
            keylset collayout col.6.text  "Volume"
            keylset collayout col.7.text  "Location"
            keylset collayout col.1.width 15
            keylset collayout col.2.width 200
            keylset collayout col.3.width 120
            keylset collayout col.4.width 120
            keylset collayout col.5.width 80
            keylset collayout col.6.width 100
            keylset collayout col.7.width 100
        }
        elementsearch {
            keylset collayout sortcol name
            keylset collayout sortdir inc
            keylset collayout height  15
            keylset collayout top     0
            keylset collayout col.1.field type
            keylset collayout col.2.field name
            keylset collayout col.3.field btime
            keylset collayout col.4.field mtime
            keylset collayout col.5.field size
            keylset collayout col.6.field path
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  Name
            keylset collayout col.3.text  "Backup/Archive Date"
            keylset collayout col.4.text  "Modification Date"
            keylset collayout col.5.text  Size
            keylset collayout col.6.text  Location
            keylset collayout col.1.width 15
            keylset collayout col.2.width 150
            keylset collayout col.3.width 100
            keylset collayout col.4.width 100
            keylset collayout col.5.width 60
            keylset collayout col.6.width 150
        }
        Storagemanager {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex type
            keylset collayout col.3.dataIndex name
            keylset collayout col.4.dataIndex text
            keylset collayout col.5.dataIndex resgroup
            keylset collayout col.6.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Type"]
            keylset collayout col.3.text [translate "Name"]
            keylset collayout col.4.text [translate "Description"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 80
            keylset collayout col.3.width 80
            keylset collayout col.4.width 200
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.4.flex 1
            keylset collayout col.5.hidden true
            keylset collayout col.6.hidden true
        }
        Device_CONTAINER {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_mediaType
            keylset collayout col.5.dataIndex rsrc_deviceType
            keylset collayout col.6.dataIndex baseDir
            keylset collayout col.7.dataIndex resgroup
            keylset collayout col.8.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Media type"]
            keylset collayout col.5.text [translate "Drive type"]
            keylset collayout col.6.text [translate "Volumes directory"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 80
            keylset collayout col.3.width 200
            keylset collayout col.4.width 80
            keylset collayout col.5.width 80
            keylset collayout col.6.width 80
            keylset collayout col.7.width 80
            keylset collayout col.8.width 80
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.6.flex 1
            keylset collayout col.7.hidden true
            keylset collayout col.8.hidden true
        }
        Device {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_mediaType
            keylset collayout col.5.dataIndex rsrc_deviceType
            keylset collayout col.6.dataIndex rsrc_cleanMePlease
            keylset collayout col.7.dataIndex rsrc_state
            keylset collayout col.8.dataIndex rsrc_vendor
            keylset collayout col.9.dataIndex rsrc_product
            keylset collayout col.10.dataIndex rsrc_serialNo
            keylset collayout col.11.dataIndex rsrc_swRevision
            keylset collayout col.12.dataIndex resgroup
            keylset collayout col.13.dataIndex resopen
            keylset collayout col.14.dataIndex baseDir
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Media type"]
            keylset collayout col.5.text [translate "Drive type"]
            keylset collayout col.6.text [translate "Cleaning"]
            keylset collayout col.7.text [translate "Operation"]
            keylset collayout col.8.text [translate "Vendor"]
            keylset collayout col.9.text [translate "Product"]
            keylset collayout col.10.text [translate "Serial number"]
            keylset collayout col.11.text [translate "Firmware"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 80
            keylset collayout col.3.width 200
            keylset collayout col.4.width 80
            keylset collayout col.5.width 80
            keylset collayout col.6.width 80
            keylset collayout col.7.width 80
            keylset collayout col.8.width 80
            keylset collayout col.9.width 80
            keylset collayout col.10.width 80
            keylset collayout col.11.width 80
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.11.flex 1
            keylset collayout col.12.hidden true
            keylset collayout col.13.hidden true
            keylset collayout col.14.hidden true
        }
        Jukebox {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_vendor
            keylset collayout col.5.dataIndex rsrc_product
            keylset collayout col.6.dataIndex rsrc_serialNo
            keylset collayout col.7.dataIndex rsrc_swRevision
            keylset collayout col.8.dataIndex rsrc_deviceList
            keylset collayout col.9.dataIndex rsrc_defaultPool
            keylset collayout col.10.dataIndex baseDir
            keylset collayout col.11.dataIndex resgroup
            keylset collayout col.12.dataIndex resopen
            keylset collayout col.2.text [translate "Name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Vendor"]
            keylset collayout col.5.text [translate "Product"]
            keylset collayout col.6.text [translate "Serial number"]
            keylset collayout col.7.text [translate "Firmware"]
            keylset collayout col.8.text [translate "Drives"]
            keylset collayout col.9.text [translate "Default pool"]
            keylset collayout col.10.text [translate "Volumes directory"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 80
            keylset collayout col.3.width 200
            keylset collayout col.4.width 80
            keylset collayout col.5.width 80
            keylset collayout col.6.width 80
            keylset collayout col.7.width 80
            keylset collayout col.8.width 120
            keylset collayout col.9.width 120
            keylset collayout col.10.width 80
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.10.flex 1
            keylset collayout col.11.hidden true
            keylset collayout col.12.hidden true
        }
        Pool {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex status
            keylset collayout col.5.dataIndex rsrc_mediaType
            keylset collayout col.6.dataIndex rsrc_usage
            keylset collayout col.7.dataIndex rsrc_format
            keylset collayout col.8.dataIndex objStore
            keylset collayout col.9.dataIndex used
            keylset collayout col.10.dataIndex free
            keylset collayout col.11.dataIndex vols
            keylset collayout col.12.dataIndex rsrc_driveList
            keylset collayout col.13.dataIndex rsrc_cloneDriveList
            keylset collayout col.14.dataIndex esti
            keylset collayout col.15.dataIndex resgroup
            keylset collayout col.16.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Status"]
            keylset collayout col.5.text [translate "Media type"]
            keylset collayout col.6.text [translate "Usage"]
            keylset collayout col.7.text [translate "Format"]
            keylset collayout col.8.text [translate "Cloud service"]
            keylset collayout col.9.text [translate "Approx. used capacity"]
            keylset collayout col.10.text [translate "Free"]
            keylset collayout col.11.text [translate "Volumes"]
            keylset collayout col.12.text [translate "Drives"]
            keylset collayout col.13.text [translate "Drives for cloning"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 150
            keylset collayout col.3.width 200
            keylset collayout col.4.width 80
            keylset collayout col.5.width 80
            keylset collayout col.6.width 70
            keylset collayout col.7.width 60
            keylset collayout col.8.width 100
            keylset collayout col.9.width 150
            keylset collayout col.10.width 60
            keylset collayout col.11.width 60
            keylset collayout col.12.width 80
            keylset collayout col.13.width 80
            # column filter
            keylset collayout col.1.filter false
            keylset collayout col.2.filter string
            keylset collayout col.3.filter string
            keylset collayout col.4.filter list
            keylset collayout col.5.filter list
            keylset collayout col.6.filter list
            keylset collayout col.7.filter list
            keylset collayout col.8.filter string
            keylset collayout col.9.filter false
            keylset collayout col.10.filter false
            keylset collayout col.11.filter false
            keylset collayout col.12.filter false
            keylset collayout col.13.filter false
            #
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.9.renderer renderPoolSize
            keylset collayout col.10.renderer calcSize
            keylset collayout col.13.flex 1
            keylset collayout col.14.hidden true
            keylset collayout col.15.hidden true
            keylset collayout col.16.hidden true
        }
        Volume {
            #
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex rsrc_successor
            keylset collayout col.4.dataIndex rsrc_copyof
            keylset collayout col.5.dataIndex text
            keylset collayout col.6.dataIndex status
            keylset collayout col.7.dataIndex rsrc_state
            keylset collayout col.8.dataIndex rsrc_pool
            keylset collayout col.9.dataIndex rsrc_barcode
            keylset collayout col.10.dataIndex rsrc_injbox
            keylset collayout col.11.dataIndex rsrc_jukebox
            keylset collayout col.12.dataIndex rsrc_externalLocation
            keylset collayout col.13.dataIndex rsrc_mode
            keylset collayout col.14.dataIndex rsrc_usedSize
            keylset collayout col.15.dataIndex rsrc_dateExpires
            keylset collayout col.16.dataIndex rsrc_dateFilled
            keylset collayout col.17.dataIndex rsrc_dateWritten
            keylset collayout col.18.dataIndex rsrc_estimatedSize
            keylset collayout col.19.dataIndex resgroup
            keylset collayout col.20.dataIndex resopen
            keylset collayout col.21.dataIndex rsrc_usage
            keylset collayout col.22.dataIndex rsrc_mediaType
            keylset collayout col.23.dataIndex rsrc_nanopureQuality
            # dataType
            keylset collayout col.1.dataType string
            keylset collayout col.2.dataType string
            keylset collayout col.3.dataType string
            keylset collayout col.4.dataType string
            keylset collayout col.5.dataType string
            keylset collayout col.6.dataType string
            keylset collayout col.7.dataType string
            keylset collayout col.8.dataType string
            keylset collayout col.9.dataType string
            keylset collayout col.10.dataType string
            keylset collayout col.11.dataType string
            keylset collayout col.12.dataType string
            keylset collayout col.13.dataType string
            keylset collayout col.14.dataType int  # type must be auto for ext 4.2
            keylset collayout col.15.dataType date
            keylset collayout col.16.dataType date
            keylset collayout col.17.dataType date
            keylset collayout col.18.dataType int
            keylset collayout col.21.dataType string
            keylset collayout col.22.dataType string
            keylset collayout col.23.dataType string
            # text
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  [translate "ID"]
            keylset collayout col.3.text  [translate "Successor"]
            keylset collayout col.4.text  [translate "Clone"]
            keylset collayout col.5.text  [translate "Description"]
            keylset collayout col.6.text  [translate "Status"]
            keylset collayout col.7.text  [translate "State"]
            keylset collayout col.8.text  [translate "Pool"]
            keylset collayout col.9.text  [translate "Bar Code"]
            keylset collayout col.10.text [translate "Position"]
            keylset collayout col.11.text [translate "Jukebox"]
            keylset collayout col.12.text [translate "Location"]
            keylset collayout col.13.text [translate "Mode"]
            keylset collayout col.14.text [translate "Approx. used capacity"]
            keylset collayout col.15.text [translate "Expiration"]
            keylset collayout col.16.text [translate "Date Filled"]
            keylset collayout col.17.text [translate "Date Written"]
            # column width
            keylset collayout col.1.width 45
            keylset collayout col.2.width 55
            keylset collayout col.3.width 55
            keylset collayout col.4.width 55
            keylset collayout col.5.width 120
            keylset collayout col.6.width 80
            keylset collayout col.7.width 80
            keylset collayout col.8.width 150
            keylset collayout col.9.width 80
            keylset collayout col.10.width 80
            keylset collayout col.11.width 80
            keylset collayout col.12.width 80
            keylset collayout col.13.width 80
            keylset collayout col.14.width 150
            keylset collayout col.15.width 90
            keylset collayout col.16.width 90
            keylset collayout col.20.width 150
            # column width flexible
            keylset collayout col.17.flex 1
            # column width sortable
            # keylset collayout col.1.sortable false
            # column renderer
            keylset collayout col.1.renderer renderVolumeIcon
            keylset collayout col.14.renderer renderVolSize
            # column alignment
            keylset collayout col.1.align "right"
            # column filter
            keylset collayout col.1.filter false
            keylset collayout col.2.filter string
            keylset collayout col.3.filter false
            keylset collayout col.4.filter false
            keylset collayout col.5.filter string
            keylset collayout col.6.filter list
            keylset collayout col.7.filter list
            keylset collayout col.8.filter string
            keylset collayout col.9.filter string
            keylset collayout col.10.filter string
            keylset collayout col.11.filter string
            keylset collayout col.12.filter string
            keylset collayout col.13.filter list
            keylset collayout col.14.filter false
            keylset collayout col.15.filter date
            keylset collayout col.16.filter date
            keylset collayout col.17.filter date
            # column date raw format 
            keylset collayout col.15.dateFormat "Y-m-d"
            keylset collayout col.16.dateFormat "Y-m-d"
            keylset collayout col.17.dateFormat "Y-m-d"
            # column header menu disabled 
            keylset collayout col.1.menuDisabled true
            # column caculation for summary
            keylset collayout col.14.summaryType sumVolSizeFree
            # column renderer for summary
            keylset collayout col.14.summaryRenderer renderSumVolSize
            # column hidden flag
            keylset collayout col.0.hidden true
            keylset collayout col.18.hidden true
            keylset collayout col.19.hidden true
            keylset collayout col.20.hidden true
            keylset collayout col.21.hidden true
            keylset collayout col.22.hidden true
            keylset collayout col.23.hidden true
        }
        Volume_CONTAINER {
            #
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_pool
            keylset collayout col.5.dataIndex rsrc_mediaType
            keylset collayout col.6.dataIndex rsrc_usedSize
            keylset collayout col.7.dataIndex resgroup
            keylset collayout col.8.dataIndex resopen
            keylset collayout col.9.dataIndex rsrc_nanopureQuality
            # text
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  [translate "ID"]
            keylset collayout col.3.text  [translate "Description"]
            keylset collayout col.4.text  [translate "Pool"]
            keylset collayout col.5.text  [translate "Media type"]
            keylset collayout col.6.text  [translate "Approx. used capacity"]
            # column width
            keylset collayout col.1.width 45
            keylset collayout col.2.width 55
            keylset collayout col.3.width 200
            keylset collayout col.4.width 150
            keylset collayout col.5.width 80
            keylset collayout col.6.flex 1
            # column width sortable
            # keylset collayout col.1.sortable false
            # column renderer
            keylset collayout col.1.renderer renderVolumeIcon
            keylset collayout col.6.renderer calcSize
            # column alignment
            keylset collayout col.1.align "right"
            # column filter
            keylset collayout col.1.filter false
            # column header menu disabled 
            keylset collayout col.1.menuDisabled true
            # column hidden flag
            keylset collayout col.0.hidden true
            keylset collayout col.7.hidden true
            keylset collayout col.8.hidden true
            keylset collayout col.9.hidden true
        }
        License {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex rsrc_bomcode
            keylset collayout col.4.dataIndex rsrc_lickey
            keylset collayout col.5.dataIndex rsrc_mainttime
            keylset collayout col.6.dataIndex rsrc_tmptime
            keylset collayout col.7.dataIndex rsrc_exptime
            keylset collayout col.8.dataIndex resgroup
            keylset collayout col.9.dataIndex resopen
            keylset collayout col.5.dataType date
            keylset collayout col.6.dataType date
            keylset collayout col.7.dataType date
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Serial Number"]
            keylset collayout col.3.text [translate "Type"]
            keylset collayout col.4.text [translate "License key"]
            keylset collayout col.5.text [translate "Maintenance Expires"]
            keylset collayout col.6.text [translate "Interim Expires"]
            keylset collayout col.7.text [translate "License Expires"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 100
            keylset collayout col.3.width 220
            keylset collayout col.4.width 150
            keylset collayout col.5.width 120
            keylset collayout col.6.width 120
            keylset collayout col.7.width 80
            keylset collayout col.0.hidden true
            keylset collayout col.1.filter false
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.5.dateFormat "Y-m-d"
            keylset collayout col.6.dateFormat "Y-m-d"
            keylset collayout col.7.dateFormat "Y-m-d"
            keylset collayout col.7.flex 1
            keylset collayout col.8.hidden true
            keylset collayout col.9.hidden true
        }
        ArchivePlan {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex status
            keylset collayout col.5.dataIndex rsrc_autoStart
            keylset collayout col.6.dataIndex rsrc_pool
            keylset collayout col.7.dataIndex rsrc_targetIndex
            keylset collayout col.8.dataIndex resgroup
            keylset collayout col.9.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  [translate "ID"]
            keylset collayout col.3.text  [translate "Description"]
            keylset collayout col.4.text  [translate "Status"]
            keylset collayout col.5.text  [translate "Auto start"]
            keylset collayout col.6.text  [translate "Target Storage"]
            keylset collayout col.7.text  [translate "Target Index"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 100
            keylset collayout col.3.width 200
            keylset collayout col.4.width 80
            keylset collayout col.5.width 80
            keylset collayout col.6.width 150
            keylset collayout col.7.width 150
            # column filter
            keylset collayout col.1.filter false
            keylset collayout col.2.filter string
            keylset collayout col.3.filter string
            keylset collayout col.4.filter list
            keylset collayout col.5.filter list
            keylset collayout col.6.filter string
            keylset collayout col.7.filter string
            #
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.7.flex 1
            keylset collayout col.8.hidden true
            keylset collayout col.9.hidden true
        }
        BackupPlan {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex status
            keylset collayout col.5.dataIndex rsrc_vollifetime
            keylset collayout col.6.dataIndex schedules
            keylset collayout col.7.dataIndex resgroup
            keylset collayout col.8.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  [translate "ID"]
            keylset collayout col.3.text  [translate "Description"]
            keylset collayout col.4.text  [translate "Status"]
            keylset collayout col.5.text  [translate "Retention Time"]
            keylset collayout col.6.text  [translate "Backup Schedules"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 80
            keylset collayout col.3.width 300
            keylset collayout col.4.width 80
            keylset collayout col.5.width 100
            keylset collayout col.6.width 150
            # column filter
            keylset collayout col.1.filter false
            keylset collayout col.2.filter string
            keylset collayout col.3.filter string
            keylset collayout col.4.filter list
            keylset collayout col.5.filter false
            keylset collayout col.6.filter false
            #
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.5.renderer calcDays
            keylset collayout col.6.renderer rendercolrows
            keylset collayout col.6.flex 1
            keylset collayout col.7.hidden true
            keylset collayout col.8.hidden true
        }
        SyncPlan {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex status
            keylset collayout col.5.dataIndex rsrc_autoStart
            keylset collayout col.6.dataIndex rsrc_sourceHost
            keylset collayout col.7.dataIndex rsrc_sourceDirs
            keylset collayout col.8.dataIndex rsrc_targetHost
            keylset collayout col.9.dataIndex rsrc_targetDir
            keylset collayout col.10.dataIndex schedules
            keylset collayout col.11.dataIndex resgroup
            keylset collayout col.12.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "ID"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Status"]
            keylset collayout col.5.text [translate "Auto start"]
            keylset collayout col.6.text [translate "Source"]
            keylset collayout col.7.text [translate "Source Folders"]
            keylset collayout col.8.text [translate "Target"]
            keylset collayout col.9.text [translate "Target Folder"]
            keylset collayout col.10.text [translate "Synchronize Schedules"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 60
            keylset collayout col.3.width 120
            keylset collayout col.4.width 80
            keylset collayout col.5.width 80
            keylset collayout col.6.width 120
            keylset collayout col.7.width 150
            keylset collayout col.8.width 120
            keylset collayout col.9.width 150
            keylset collayout col.10.width 150
            # column filter
            keylset collayout col.1.filter false
            keylset collayout col.2.filter string
            keylset collayout col.3.filter string
            keylset collayout col.4.filter list
            keylset collayout col.5.filter list
            keylset collayout col.6.filter string
            keylset collayout col.7.filter string
            keylset collayout col.8.filter string
            keylset collayout col.9.filter string
            #
            keylset collayout col.0.hidden true
            keylset collayout col.1.align "right"
            keylset collayout col.1.sortable false
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.7.renderer rendercolrows
            keylset collayout col.10.renderer rendercolrows
            keylset collayout col.10.flex 1
            keylset collayout col.11.hidden true
            keylset collayout col.12.hidden true
        }
        MigrationPlan {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_autoStart
            keylset collayout col.5.dataIndex rsrc_sourcePool
            keylset collayout col.6.dataIndex rsrc_targetPool
            keylset collayout col.7.dataIndex rsrc_selectTime
            keylset collayout col.8.dataIndex rsrc_copyMode
            keylset collayout col.9.dataIndex schedules
            keylset collayout col.10.dataIndex resgroup
            keylset collayout col.11.dataIndex resopen
            keylset collayout col.1.text "&nbsp;"
            keylset collayout col.2.text [translate "ID"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Auto start"]
            keylset collayout col.5.text [translate "Source Pool"]
            keylset collayout col.6.text [translate "Target Pool"]
            keylset collayout col.7.text [translate "Date Filter"]
            keylset collayout col.8.text [translate "Mode"]
            keylset collayout col.9.text [translate "Migration Schedules"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 100
            keylset collayout col.3.width 120
            keylset collayout col.4.width 80
            keylset collayout col.5.width 120
            keylset collayout col.6.width 120
            keylset collayout col.7.width 120
            keylset collayout col.8.width 80
            keylset collayout col.9.width 150
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.9.renderer rendercolrows
            keylset collayout col.9.flex 1
            keylset collayout col.10.hidden true
            keylset collayout col.11.hidden true
        }
        ObjectBucket {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_pools
            keylset collayout col.5.dataIndex rsrc_stagingPath
            keylset collayout col.6.dataIndex resgroup
            keylset collayout col.7.dataIndex resopen
            keylset collayout col.1.text "&nbsp;"
            keylset collayout col.2.text [translate "Bucket name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Pool"]
            keylset collayout col.5.text [translate "Staging Area"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 150
            keylset collayout col.3.width 200
            keylset collayout col.4.width 120
            keylset collayout col.5.width 200
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.5.flex 1
            keylset collayout col.6.hidden true
            keylset collayout col.7.hidden true
        }
        UserPref {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex resgroup
            keylset collayout col.5.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 150
            keylset collayout col.3.width 300
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.3.flex 1
            keylset collayout col.4.hidden true
            keylset collayout col.5.hidden true
        }
        GroupPref {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex resgroup
            keylset collayout col.5.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 150
            keylset collayout col.3.width 300
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.3.flex 1
            keylset collayout col.4.hidden true
            keylset collayout col.5.hidden true
        }
        Client {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_hostname
            keylset collayout col.5.dataIndex rsrc_port
            keylset collayout col.6.dataIndex rsrc_licensetype
            keylset collayout col.7.dataIndex resgroup
            keylset collayout col.8.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Hostname"]
            keylset collayout col.5.text [translate "Port"]
            keylset collayout col.6.text [translate "License type"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 150
            keylset collayout col.3.width 200
            keylset collayout col.4.width 120
            keylset collayout col.5.width 80
            keylset collayout col.6.width 120
            keylset collayout col.0.hidden true
            keylset collayout col.1.align "right"
            keylset collayout col.1.sortable false
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.6.flex 1
            keylset collayout col.7.hidden true
            keylset collayout col.8.hidden true
        }
        ObjectStore {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_service
            keylset collayout col.5.dataIndex rsrc_bucket
            keylset collayout col.6.dataIndex rsrc_usedByResources
            keylset collayout col.7.dataIndex resgroup
            keylset collayout col.8.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "ID"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Service"]
            keylset collayout col.5.text [translate "Bucket/Container"]
            keylset collayout col.6.text [translate "Used by pool or archive plan"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 80
            keylset collayout col.3.width 150
            keylset collayout col.4.width 150
            keylset collayout col.5.width 100
            keylset collayout col.6.width 200
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.6.flex 1
            keylset collayout col.7.hidden true
            keylset collayout col.8.hidden true
        }
        Backup2Go {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_restorePath
            keylset collayout col.5.dataIndex rsrc_retainTime
            keylset collayout col.6.dataIndex resgroup
            keylset collayout col.7.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Data Storage Directory"]
            keylset collayout col.5.text [translate "Retain Data For"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 60
            keylset collayout col.3.width 150
            keylset collayout col.4.width 200
            keylset collayout col.5.width 150
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.5.renderer calcDaysWeek
            keylset collayout col.5.flex 1
            keylset collayout col.6.hidden true
            keylset collayout col.7.hidden true
        }
        Server {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_hostname
            keylset collayout col.5.dataIndex rsrc_port
            keylset collayout col.6.dataIndex rsrc_copyStarted
            keylset collayout col.7.dataIndex rsrc_copyCompleted
            keylset collayout col.8.dataIndex resgroup
            keylset collayout col.9.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "ID"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Server"]
            keylset collayout col.5.text [translate "Port"]
            keylset collayout col.6.text [translate "Start Time"]
            keylset collayout col.7.text [translate "Completed"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 100
            keylset collayout col.3.width 150
            keylset collayout col.4.width 150
            keylset collayout col.5.width 50
            keylset collayout col.6.width 120
            keylset collayout col.7.width 120
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.6.dataType date
            keylset collayout col.6.dateFormat "Y-m-d"
            #keylset collayout col.6.renderer renderDate
            keylset collayout col.7.dataType date
            keylset collayout col.7.dateFormat "Y-m-d"
            #keylset collayout col.7.renderer renderDate
            keylset collayout col.7.flex 1
            keylset collayout col.8.hidden true
            keylset collayout col.9.hidden true
        }
        Workstation {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_peerip
            keylset collayout col.5.dataIndex rsrc_hostid
            keylset collayout col.6.dataIndex rsrc_templateId
            keylset collayout col.7.dataIndex resgroup
            keylset collayout col.8.dataIndex resopen
            keylset collayout col.1.text "&nbsp;"
            keylset collayout col.2.text [translate "ID"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Last IP Address"]
            keylset collayout col.5.text [translate "Host-ID"]
            keylset collayout col.6.text [translate "Used Template"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 80
            keylset collayout col.3.width 150
            keylset collayout col.4.width 120
            keylset collayout col.5.width 120
            keylset collayout col.6.width 150
            keylset collayout col.0.hidden true
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.sortable false
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.1.align "right"
            keylset collayout col.6.flex 1
            keylset collayout col.7.hidden true
            keylset collayout col.8.hidden true
        }
        Database {
            #
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_driver
            keylset collayout col.5.dataIndex rsrc_usage
            keylset collayout col.6.dataIndex rsrc_vers
            keylset collayout col.7.dataIndex resgroup
            keylset collayout col.8.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Type"]
            keylset collayout col.5.text [translate "Usage"]
            keylset collayout col.6.text [translate "Version"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 150
            keylset collayout col.3.width 200
            keylset collayout col.4.width 100
            keylset collayout col.5.width 80
            keylset collayout col.6.width 80
            keylset collayout col.0.hidden true
            keylset collayout col.1.align "right"
            keylset collayout col.1.sortable false
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.4.renderer renderIndexType
            keylset collayout col.6.flex 1
            keylset collayout col.7.hidden true
            keylset collayout col.8.hidden true
        }
        LoginArea {
            #
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_tree
            keylset collayout col.5.dataIndex rsrc_category
            keylset collayout col.6.dataIndex rsrc_loginPath
            keylset collayout col.7.dataIndex resgroup
            keylset collayout col.8.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "ID"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.4.text [translate "Database"]
            keylset collayout col.5.text [translate "Category"]
            keylset collayout col.6.text [translate "Login Path"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 100
            keylset collayout col.3.width 150
            keylset collayout col.4.width 150
            keylset collayout col.5.width 150
            keylset collayout col.6.width 150
            keylset collayout col.0.hidden true
            keylset collayout col.1.align "right"
            keylset collayout col.1.sortable false
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.6.flex 1
            keylset collayout col.7.hidden true
            keylset collayout col.8.hidden true
        }
        Translation {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex rsrc_$locale
            keylset collayout col.5.dataIndex resgroup
            keylset collayout col.6.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "ID"]
            keylset collayout col.3.text [translate "Message"]
            keylset collayout col.4.text [translate "Translation"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 80
            keylset collayout col.3.width 180
            keylset collayout col.4.width 180
            # column filter
            keylset collayout col.1.filter false
            keylset collayout col.2.filter string
            keylset collayout col.3.filter string
            keylset collayout col.4.filter string
            keylset collayout col.0.hidden true
            keylset collayout col.1.align "right"
            keylset collayout col.1.sortable false
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.2.dataType int
            keylset collayout col.4.flex 1
            keylset collayout col.5.hidden true
            keylset collayout col.6.hidden true
        }
        Filter {
            keylset collayout col.0.dataIndex rsrc_status
            keylset collayout col.1.dataIndex type
            keylset collayout col.2.dataIndex name
            keylset collayout col.3.dataIndex text
            keylset collayout col.4.dataIndex resgroup
            keylset collayout col.5.dataIndex resopen
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text [translate "Name"]
            keylset collayout col.3.text [translate "Description"]
            keylset collayout col.1.width 40
            keylset collayout col.2.width 150
            keylset collayout col.3.width 300
            keylset collayout col.0.hidden true
            keylset collayout col.1.align "right"
            keylset collayout col.1.sortable false
            keylset collayout col.1.menuDisabled true
            keylset collayout col.1.renderer renderIcon
            keylset collayout col.3.flex 1
            keylset collayout col.4.hidden true
            keylset collayout col.5.hidden true
        }
        Job {
            keylset collayout sortcol rsrc_timeCompleted
            keylset collayout sortdir dec
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field type
            keylset collayout col.2.field text
            keylset collayout col.3.field rsrc_timeStarted
            keylset collayout col.4.field rsrc_timeCompleted
            keylset collayout col.5.field name
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  Description
            keylset collayout col.3.text  "Start Time"
            keylset collayout col.4.text  "End Time"
            keylset collayout col.5.text  Job
            keylset collayout col.1.width 15
            keylset collayout col.2.width 300
            keylset collayout col.3.width 100
            keylset collayout col.4.width 100
            keylset collayout col.5.width 100
        }
        JobLog {
            keylset collayout sortcol timeCompleted
            keylset collayout sortdir dec
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field type
            keylset collayout col.2.field text
            keylset collayout col.3.field client
            keylset collayout col.4.field level
            keylset collayout col.5.field numKbytes
            keylset collayout col.6.field timeStarted
            keylset collayout col.7.field timeCompleted
            keylset collayout col.8.field duration
            keylset collayout col.9.field name
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  "Plan Name/Operation"
            keylset collayout col.3.text  "Client"
            keylset collayout col.4.text  "Level"
            keylset collayout col.5.text  "Size"
            keylset collayout col.6.text  "Start Time"
            keylset collayout col.7.text  "End Time"
            keylset collayout col.8.text  "Duration"
            keylset collayout col.9.text  Job
            keylset collayout col.1.width 10
            keylset collayout col.2.width 80
            keylset collayout col.3.width 50
            keylset collayout col.4.width 30
            keylset collayout col.5.width 40
            keylset collayout col.6.width 60
            keylset collayout col.7.width 60
            keylset collayout col.8.width 50
            keylset collayout col.9.width 50
        }
        BackupTask {
            keylset collayout sortcol client
            keylset collayout sortdir dec
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field client
            keylset collayout col.2.field backupPlan
            keylset collayout col.3.field returnCode
            keylset collayout col.4.field timeCompleted
            keylset collayout col.5.field dirlist
            keylset collayout col.6.field pool
            keylset collayout col.7.field start
            keylset collayout col.8.field eventPools
            keylset collayout col.1.text "Client"
            keylset collayout col.2.text "Backup Plan"
            keylset collayout col.3.text "Last Run"
            keylset collayout col.4.text "Last Successful"
            keylset collayout col.5.text "Directories"
            keylset collayout col.6.text "Last Pool"
            keylset collayout col.7.text "Next Run"
            keylset collayout col.8.text "Next Pool"
            keylset collayout col.1.width 50
            keylset collayout col.2.width 50
            keylset collayout col.3.width 50
            keylset collayout col.4.width 50
            keylset collayout col.5.width 50 
            keylset collayout col.6.width 50
            keylset collayout col.7.width 50
            keylset collayout col.8.width 50
        }
        SyncTask {
            keylset collayout sortcol syncPlan
            keylset collayout sortdir inc
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field type
            keylset collayout col.2.field syncPlan
            keylset collayout col.3.field returnCode
            keylset collayout col.4.field timeCompleted
            keylset collayout col.5.field duration
            keylset collayout col.6.field start
            keylset collayout col.7.field sourceHost
            keylset collayout col.8.field sourceDirs
            keylset collayout col.9.field targetHost
            keylset collayout col.10.field targetDir
            keylset collayout col.1.text "&nbsp;"
            keylset collayout col.2.text "Synchronize Plan"
            keylset collayout col.3.text "Last Run"
            keylset collayout col.4.text "Last Successful"
            keylset collayout col.5.text "Duration"
            keylset collayout col.6.text "Next Run"
            keylset collayout col.7.text "Source"
            keylset collayout col.8.text "Source Path"
            keylset collayout col.9.text "Target"
            keylset collayout col.10.text "Target Path"
            keylset collayout col.1.width 5
            keylset collayout col.2.width 50
            keylset collayout col.3.width 50
            keylset collayout col.4.width 50
            keylset collayout col.5.width 50
            keylset collayout col.6.width 50 
            keylset collayout col.7.width 50
            keylset collayout col.8.width 50
            keylset collayout col.9.width 50
            keylset collayout col.10.width 50
        }
        ArchiveTask {
            keylset collayout sortcol timeStarted
            keylset collayout sortdir dec
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field archivePlan
            keylset collayout col.2.field timeStarted
            keylset collayout col.3.field duration
            keylset collayout col.4.field returnCode
            keylset collayout col.5.field numKbytes
            keylset collayout col.6.field client
            keylset collayout col.7.field dirlist
            keylset collayout col.8.field pool
            keylset collayout col.1.text "Archive Plan"
            keylset collayout col.2.text "Start Time"
            keylset collayout col.3.text "Duration"
            keylset collayout col.4.text "Status"
            keylset collayout col.5.text "Approx. Size"
            keylset collayout col.6.text "Client"
            keylset collayout col.7.text "Directories"
            keylset collayout col.8.text "Pool"
            keylset collayout col.1.width 50
            keylset collayout col.2.width 50
            keylset collayout col.3.width 50
            keylset collayout col.4.width 50
            keylset collayout col.5.width 50 
            keylset collayout col.6.width 50
            keylset collayout col.7.width 50
            keylset collayout col.8.width 50
        }
        MigrationTask {
            keylset collayout sortcol timeStarted
            keylset collayout sortdir dec
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.9.field migrationPlan
            keylset collayout col.10.field timeStarted
            keylset collayout col.11.field duration
            keylset collayout col.12.field returnCode
            keylset collayout col.13.field numKbytes
            keylset collayout col.14.field sourcePool
            keylset collayout col.15.field targetPool
            keylset collayout col.9.text "Migration Plan"
            keylset collayout col.10.text "Start Time"
            keylset collayout col.11.text "Duration"
            keylset collayout col.12.text "Status"
            keylset collayout col.13.text "Approx. Size"
            keylset collayout col.14.text "Source Pool"
            keylset collayout col.15.text "Target Pool"
            keylset collayout col.9.width 50
            keylset collayout col.10.width 50
            keylset collayout col.11.width 50
            keylset collayout col.12.width 50
            keylset collayout col.13.width 50 
            keylset collayout col.14.width 50
            keylset collayout col.15.width 50
        }
        Backup2GoOverview {
            keylset collayout sortcol name
            keylset collayout sortdir dec
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field type
            keylset collayout col.2.field name
            keylset collayout col.3.field text
            keylset collayout col.4.field copyCompleted
            keylset collayout col.5.field copyCompleted
            keylset collayout col.6.field templateId
            keylset collayout col.1.text "&nbsp;"
            keylset collayout col.2.text "ID"
            keylset collayout col.3.text "Description"
            keylset collayout col.4.text "Last Backup"
            keylset collayout col.5.text "Last Successful"
            keylset collayout col.6.text "Used Template"
            keylset collayout col.1.width 5
            keylset collayout col.2.width 50
            keylset collayout col.3.width 150
            keylset collayout col.4.width 150
            keylset collayout col.5.width 150
            keylset collayout col.6.width 150 
        }
        LicenseOverview {
            keylset collayout sortcol rowid
            keylset collayout sortdir inc
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field service
            keylset collayout col.2.field use
            keylset collayout col.3.field units
            keylset collayout col.4.field unitsused
            keylset collayout col.5.field unitsfree
            keylset collayout col.1.text "P5 Service/Expansion"
            keylset collayout col.2.text "Use"
            keylset collayout col.3.text "Licensed"
            keylset collayout col.4.text "In use"
            keylset collayout col.5.text "Available"
            keylset collayout col.1.width 130
            keylset collayout col.2.width 130
            keylset collayout col.3.width 60
            keylset collayout col.4.width 60
            keylset collayout col.5.width 60
        }
        jobmonitor {
            keylset collayout sortcol start
            keylset collayout sortdir inc
            keylset collayout height  15
            keylset collayout top      0
            keylset collayout col.1.field type
            keylset collayout col.2.field title
            keylset collayout col.3.field client
            keylset collayout col.4.field level
            keylset collayout col.5.field start
            keylset collayout col.6.field name
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  "Plan Name/Operation"
            keylset collayout col.3.text  "Client"
            keylset collayout col.4.text  "Level"
            keylset collayout col.5.text  "Start Time"
            keylset collayout col.6.text  "Job"
            keylset collayout col.1.width 20
            keylset collayout col.2.width 240
            keylset collayout col.3.width 70
            keylset collayout col.4.width 50
            keylset collayout col.5.width 110
            keylset collayout col.6.width 60
        }
        short {
            keylset collayout sortcol name
            keylset collayout sortdir inc
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field type
            keylset collayout col.2.field name
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  Name
            keylset collayout col.1.width 23
            keylset collayout col.2.width 1000
        }
        default {
            keylset collayout sortcol name
            keylset collayout sortdir inc
            keylset collayout height  15
            keylset collayout top     24
            keylset collayout col.1.field type
            keylset collayout col.2.field name
            keylset collayout col.3.field text
            keylset collayout col.1.text  "&nbsp;"
            keylset collayout col.2.text  Name
            keylset collayout col.3.text  Description
            keylset collayout col.1.width 40
            keylset collayout col.2.width 150
            keylset collayout col.3.width 804
        }
    }
    return $collayout
}

##############################################################################

proc mkWsCSS { collayout } {

    set nextleft   0
    set totalwidth 0
    set iconwidth  16
    foreach col [keylkeys collayout col] {
        incr totalwidth [keylget collayout col.$col.width]
    }
    set rowid 0
    foreach col [keylkeys collayout col] {
        set minwidth   [keylget collayout col.$col.width]
        set fixwidth   [expr $minwidth * 100 / $totalwidth]
        if { [keylget collayout sortcol] == [keylget collayout col.$col.field] } {
            set bgurl      {background-color: #D6DAE1}
            set bcolo      {border-color: #CDCFDA #CDCFDA #CDCFDA #CDCFDA}
        } else {
            set bgurl      {background-color: #F5F5F5}
            set bcolo      {border-color: #CDCFDA #CDCFDA #CDCFDA #CDCFDA}
        }
        if { !$rowid } {
            set bwidt      {border-width: 1px 1px 1px 1px}
        } else {
            set bwidt      {border-width: 1px 1px 1px 0px}
        }
        append thccs    [subst { 
            .th$col { width:${fixwidth}%;min-width: ${minwidth}px;padding-left:5px;padding-right:6px;padding-top:2px;padding-bottom:1px;margin:0px;$bgurl;$bwidt;$bcolo;border-style:solid;white-space:nowrap}
        }]
        append thfcs   [subst { 
            .thf$col { width:${fixwidth}%;min-width: ${minwidth}px;padding-left:5px;padding-right:6px;padding-top:1px;padding-bottom:1px;margin:0px;$bgurl;border-width: 0px 1px 1px 1px;$bcolo;border-style:solid;white-space:nowrap}
        }]
        append ticcs    [subst { 
            .ti$col { width:${fixwidth}%;white-space:nowrap;font-family: Arial, Helvetica, Osaka;font-size:13px;}
        }]
        append tfccs    [subst { 
            .tf$col { width:${minwidth}px;padding:0px;margin:0px;font-size:10px;border: 1px;border-style:solid;white-space:nowrap;border-color:#ADADAF}
        }]
        append tdccs    [subst { 
            .td$col { width:${fixwidth}%;min-width: ${minwidth}px;height:14px;padding-left:6px;padding-right:7px;padding-top:2px;padding-bottom:2px;margin:0px;vertical-align: top}
        }]
        incr rowid
    }
    # set breakwidth [expr [keylget collayout col.2.width] - $iconwidth]
    #
    set trowo    { .trow  { }
                   .trow0 { background-color: #FFFFFF }
                   .trow1 { background-color: #FFFFFF }
                   .td21 { width: ${iconwidth}px;padding-right:4px;vertical-align:top;padding-top:2px;white-space:nowrap }
                   .td22 { height:14px;padding:0px;margin:0px;vertical-align:top;padding-top:1px }
                   .tdiw { padding-top:2px;white-space:nowrap; }
                   .tdiv { display:block;padding-top:2px;height:14px;overflow:hidden }                   
                 }
    set trhig    { .trhig { background-color: #FFFFCC }}
    #
    html::style -type text/css { html::t [subst "$trhig $trowo $thccs $thfcs $ticcs $tfccs $tdccs"] }
}

##############################################################################

proc tr_CurrentUrl { rowid treeStep } {
    
    set treeStepName [session::get treeStepName]
    array set treeArray $treeStepName
    if {[set parentDir [lindex $treeStepName [expr [lsearch $treeStepName $treeStep] -2]]] == "" } {
         set parentDir [lindex $treeStepName 0]
    }
    html::tr -id $rowid -onclick "actSelected(this,event)" -onDblClick "prevDirDbl(this)" {
        html::td -class td1 -height 20 -style "padding:0px" {
            html::img -style "width:10px" -class icondis -src [session::url /img4/10x11.gif] { html::t "" }
            html::img -src [session::url /img4/ord_parent.png] { html::t "" }
        }
        html::td -class td2 {
            html::table -border "0" -cellpadding "0" -cellspacing "0" {
                html::tr {
                    #html::td -class td21 {
                    #    html::img -src [session::url /img4/16x16.gif] { html::t "" }
                    #}
                    html::td -class td22 -style "padding-left:0px" {
                        html::div -class tdiv -style "font-weight:900" { html::t [LexxTree displayName $treeArray(${treeStep})] }
                    }
                }
            }
        }
        html::td -class td3
        html::td -class td4
        html::td -class td5
        html::td -style "display: none" {
            html::input -id cbe$rowid -style "display: none" -type checkbox -value $treeStep
            html::input -id cbi$rowid -style "display: none" -type checkbox -value $parentDir
        }
    }
}

##############################################################################

proc tr_WstTreeB2Go { rowid sortCol upArray { sortColumn {} } } {
    
    upvar $upArray tblRow
        
    foreach cell $sortCol {
        set nextCell [lindex $cell 0]
        array set dataArray $tblRow(${nextCell})

        set imgId    $dataArray(elementPath)
        set imgType  $dataArray(type)
        set imgSrc   $dataArray(icon)

        if { !$dataArray(access) } {
            set imgId    ""
            set imgType  ""
            set imgSrc   [session::url /img4/no_access.png]
            set dblClick "alert('[translate {Permission denied}]')"
        } else {
            set dblClick "actDblClick(this)"
        }
        #
        html::tr -id $rowid -onclick "actSelected(this,event)" -onDblClick $dblClick -class trow[expr $rowid % 2] {
            html::td -class td1
            html::td -class td2 {
                html::table -border "0" -cellpadding "0" -cellspacing "0" -width 100% {
                    html::tr {
                        html::td -class td21 {
                            html::img -src $imgSrc { html::t "" } 
                        }
                        html::td -class td22 {
                            html::div -class tdiw { html::t [LexxTree displayName $dataArray(name)] }
                        }
                    }
                }
            }    
            html::td -class td3 { html::div -class tdiv { html::t [fmtdatetime $dataArray(mtime)] }}
            html::td -class td4 { html::div -class tdiv { html::t [fmtfilesize $dataArray(size) $dataArray(type) ] }}
            html::td -style "display: none" {
                html::input -id cbe$rowid -name $imgType -style "display: none" -type checkbox -value $imgId
            }
        }
        incr rowid
    }
    return $rowid
}

##############################################################################

proc tr_FilePicker { rowid sortCol upArray { sortColumn {} } } {
    
    upvar $upArray tblRow
        
    foreach cell $sortCol {
        set nextCell [lindex $cell 0]
        array set dataArray $tblRow(${nextCell})

        set imgType  $dataArray(type)
        if { $imgType == "Directory" || $imgType == "Container" } {
            set dblClick "actDblClick(this)"
        } else {
            set dblClick "return"
        }
        #
        html::tr -id $rowid -onclick "rowMark(this,event)" -onDblClick $dblClick -onMouseOver "this.className='trhig'" -onMouseOut "this.className='trow'" -class trow {
            set node [ns_tdp_node]
            if { $dataArray(type) == "Directory" || $dataArray(type) == "Container" } {
                html::td -style "padding-left:15px" {
                    html::img -src $dataArray(icon) { html::t "" } 
                }
                html::td -class td2 {
                    html::div -class tdiv { html::t [LexxTree displayName $dataArray(name)] }
                }
            } else {
                html::td -style "padding-left:15px" {
                    html::img -src $dataArray(icon) { html::t "" } 
                }
                html::td -class td2 {
                    html::div -class tdiv -style "color: gray" { html::t [LexxTree displayName $dataArray(name)] }
                }
                $node setAttribute onclick "return"
            }
            html::td -style "display: none" {
                html::input -id cbe$rowid -name $imgType -style "display: none" -type checkbox -value $dataArray(elementurl)
                html::input -id cbp$rowid                -style "display: none" -type checkbox -value $dataArray(elementPath)
            }
        }
        incr rowid
    }
    return $rowid
}

##############################################################################

proc tr_elementversions { rowid sortCol upArray { sortColumn {} } } {
    
    upvar $upArray tblRow

    set volgrp    [VolumeGroup new -volatile]
        
    foreach cell $sortCol {
        set nextCell [lindex $cell 0]
        array set dataArray $tblRow(${nextCell})

        html::tr -id $rowid -onclick "actSelected(this,event)" -class trow[expr $rowid % 2] {
            html::td -class td1
            html::td -class td2 { 
                html::table -border "0" -cellpadding "0" -cellspacing "0" -width 100% {
                    html::tr {
                        html::td -class td22 {
                            html::div -class tdiv { html::t [LexxTree displayName $dataArray(name)] }
                        }
                    }
                }
            }
            html::td -class td3 { html::div -class tdiv { html::t [fmtdatetime $dataArray(mtime)] } }
            html::td -class td4 { html::div -class tdiv { html::t [fmtdatetime $dataArray(btime)] } }
            html::td -class td5 { html::div -class tdiv { html::t [fmtfilesize $dataArray(size) $dataArray(type)] } }
            if { [$volgrp ls $dataArray(volid)] != "" && ![catch {set thisVol [$volgrp $dataArray(volid)]}]} {
                set label    "[$thisVol describe] ($dataArray(volid))"
                set location [$thisVol location]
            } else {
                set label    $dataArray(volid)            
                set location [translate "unknown"]          
            }
            html::td -class td6 { html::div -class tdiv { html::t $label } }
            html::td -class td7 { html::div -class tdiv { html::t $location } }
            html::td -style "display: none" {
                html::input -id cbe$rowid -name $dataArray(type) -style "display: none" -type checkbox -value $dataArray(elementurl)
            }
        }
        incr rowid
    }
    return $rowid
}


