//#############################################################################

//idx.js

//JavaScript Client Library

//See the file "license.txt" for information on usage and
//redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.


//#############################################################################

//Ext.Loader.setPath('Ext.ux', 'lib/extjs/ux');

Ext.require([
    'Ext.slider.*'
]);

// add template methode for afterRequest (since ext 5.0)
Ext.define('awProxy', {
	override: 'Ext.data.proxy.Ajax', 
	
	config: {
		afterRequest: Ext.emptyFn
	}
	
});

function showToast(hint,txt) {
    Ext.toast({
        html: txt,
        //title: hint,
        closable: false,
        align: 't',
        slideInDuration: 300,
        hideDuration: 800,
        bodyStyle: 'background:#f7f7b0; padding:10px; font-size: 14px'
    });
};


//read table head definition
Ext.define('breadcrumbs',{
	extend: 'Ext.data.Model',
	fields: [
	    {name: 'pName',  type: 'string', defaultValue: ''},
	    {name: 'pAddr',  type: 'string', defaultValue: ''}
	]
});

Ext.define('colHeadTree',{
	extend: 'Ext.data.Model',
	fields: [
         {name: 'text',  type: 'string', defaultValue: ''},
         {name: 'dataIndex',  type: 'string', defaultValue: ''},
         {name: 'dataType',  type: 'string', defaultValue: 'string'},
         {name: 'dateFormat',  type: 'string', defaultValue: 'U'},
         {name: 'sortable',  type: 'boolean', defaultValue: true},
         {name: 'width',  type: 'int', defaultValue: 100},
         {name: 'flex',  type: 'int', defaultValue: 0},
         {name: 'renderer',  type: 'string', defaultValue: ''},
         {name: 'align',  type: 'string', defaultValue: 'left'},
         {name: 'filter',  type: 'string', defaultValue: true},
         {name: 'menuDisabled',  type: 'boolean', defaultValue: false},
         {name: 'hidden',  type: 'boolean', defaultValue: false},
         {name: 'summaryType',  type: 'string', defaultValue: ''},
         {name: 'summaryRenderer',  type: 'string', defaultValue: ''}
    ]
});

//define data model for the gallery
Ext.define('m_gallery',{
	extend: 'Ext.data.Model',
	fields: [
         {name: 'name',  type: 'string', defaultValue: ''},
         {name: 'type',  type: 'string', defaultValue: ''},
         {name: 'pvsize',  type: 'int', defaultValue: 160},
         {name: 'xsize',  type: 'int', defaultValue: 160},
         {name: 'ysize', type: 'int', defaultValue: 160},
         {name: 'clippath', type: 'string', defaultValue: ''},
         {name: 'iconpath', type: 'string', defaultValue: ''},
         {name: 'container', type: 'string', defaultValue: ''},
         {name: 'media', type: 'string', defaultValue: ''}
    ]
});

rootUrl       = document.filelist.elementurl.value;
rootText      = document.filelist.elementtxt.value;
browser_index = document.hammerForm.browser_index.value;
document.hammerForm.treeType.value = document.filelist.treeType.value;


Ext.onReady(function() {
	infoSubmited = false;
	startAppListing();
});

function startAppListing() {

	getXmlData();

}

function getXmlData() {

	hideWait();

	// read data in XML format
	waitBox();
	Ext.Ajax.request({
		url: browser_index,
		method: 'POST',
		params: { 
			caller: 'ajaxHead',
			isXml: true
		},
		scope: this,
		failure: function(){
			extAlert(1,'Could not connect to server');
		}, 
		success:function(response, options) {
			hideWait();
			var xmldata = response.responseXML;
			doTree(xmldata);
		}
	});

}

function doTree(xmldata) {

	dbusage      = DQ.selectValue('param > dbusage', xmldata);
	dboper       = DQ.selectValue('param > dboper', xmldata);
	treeType     = DQ.selectValue('param > treeType', xmldata);
	hasSelection = DQ.selectValue('param > hasSelection', xmldata);
	pageSize     = DQ.selectValue('param > pageSize', xmldata);
	isAdmin      = DQ.selectValue('param > isAdmin', xmldata);
	idxModify    = DQ.selectValue('param > idxModify', xmldata);
	idxMetaEdit  = eval(DQ.selectValue('param > idxMetaEdit', xmldata));
	
	if ( treeType == 'AsxTree'  ) {
		var windowPanel = [{
			region: 'east',
			id: 'centereast',
			stateId: 'centereast',
			stateful: true,
			collapsible: true,
			collapseMode: 'mini',
			collapsed: true,
			preventHeader: true,
			layout: 'border',
			split: true,
			width: 360,
			padding: '0',
			bodyStyle: 'border-width: 0px 0px 0px 0px;',
        	listeners: {
            	expand: function() {
                	panel_meta.myLoad();
            	}
        	},
			items: [{
				xtype: 'panel',
				preventHeader: true,
				region: 'north',
				layout: 'fit',
				id: 'southpreview',
				stateId: 'southpreview',
				stateful: true,
				height: 340,
				split: true,
				padding: '0',
				collapsible: true,
				collapseMode: 'mini',
			    bodyStyle: 'border-width: 0px 0px 1px 1px;',
			}, {
				xtype: 'panel',
				preventHeader: true,
				region: 'center',
				layout: 'fit',
				padding: '0',
				id: 'centerinfo',
			    bodyStyle: 'border-width: 1px 0px 0px 1px;'
			}]
		},{
			region: 'center',
			layout: 'border',
			padding: '0',
			border: false,
			items: [{
				xtype: 'panel',
				region: 'center',
				layout: 'fit',
				id: 'centertree',
				padding: '0',
				border: false
			},{
				xtype: 'panel',
				region:'east',
				id: 'southgallery',
				stateId: 'southgallery',
				stateful: true,
				collapsible: true,
				collapseMode: 'mini',
				collapsed: true,
				split: true,
				preventHeader: true,
				width: 300,
				padding: '0',
				layout: 'fit',
				bodyStyle: 'border-width: 0px 1px 0px 1px;',
				listeners: {
					expand: function(p, opt){
						//store_gallery.loadRawData(store_tree.proxy.reader.rawData);
						// reload store to show thumbnails
						store_tree.load();
					}
				}
			}]
		}];
		var menuBarDef = [{ xtype: 'tbspacer' },{
			xtype : 'button',
			iconCls: 'btn-search',  
			cls: 'btn-padding-left',
			text: $$('Search'),
			value: 'browse',
			id: 'searchButton',
			toggleGroup: 'crmNaviBtnGroup',
			enableToggle: true,
			handler: function() {
				searchOrBrowse('store_load');
			}
		},{
			xtype : 'button',
			iconCls: 'btn-viewgallery',  
			cls: 'btn-padding-left',
			text: $$('Gallery'),
			handler: function() {
				viewportGallery.toggleCollapse();                
			}
		},{
			xtype : 'button',
			iconCls: 'btn-viewinfo',  
			cls: 'btn-padding-left',
			text: $$('Information'),
			handler: function() { 
				viewportInfo.toggleCollapse();                
			}            
		},{ xtype : 'tbfill' },{
			xtype : 'button',
			iconCls: 'btn-clockback',  
			cls: 'btn-padding-left',
			text: $$('Index'),
			menu: vtimeMenu = Ext.create('Ext.menu.Menu', {
				defaults: {
					margin: '0 5 0',
					handler: function(obj) {
						if ( workmodus.value == 'search' ) searchOrBrowse('store_load');
						store_tree.load({
							params: {
								caller: 'setSnapshot',
                                procedure: '',
								node: store_tree.currentUrl,
								vtime: obj.itemId
							},
                            callback : function(records, operation, success) {
                                console.log('reload selection store');
                                store_selection.load({params: {procedure: 'listing'}});
                            }
						});
					}             
				}
			})
		},{
			xtype : 'button',
			iconCls: 'btn-viewoption',  
			cls: 'btn-padding-left',
			text: $$('View'),
			handler: function() {
				viewoptionWindow();                
			}
		}];
		viewOptionsDef = [{
			xtype: 'radiogroup',
			fieldLabel: $$('Items per page'),
			labelAlign: 'top',
			defaults: {
				name: 'pageSize',
				style: {
					whiteSpace: 'nowrap',
					marginLeft: "10px"
				}
			},
			items: [{
				inputValue: '0',
				boxLabel: $$('Paging off')
			}, {
				inputValue: '50',
				boxLabel: '50'
			}, {
				inputValue: '100',
				boxLabel: '100'
			}, {
				inputValue: '200',
				boxLabel: '200'
			}, {
				inputValue: '500',
				boxLabel: '500'
			}],
			setValue: function (value) {
				if (!Ext.isObject(value)) {
					var obj = new Object();
					obj[this.name] = value;
					value = obj;
				}
				Ext.form.RadioGroup.prototype.setValue.call(this, value);
			}
		},{
			xtype: 'radiogroup',
			fieldLabel: $$('Show columns'),
			labelAlign: 'top',
			margin: '5 0 4 0'
		},{
			xtype: 'viewoptionscolgrid',
			itemId: 'viewoptionscolgrid_id',
			height: 220
		}];
		indexOptionsTabs = {
			xtype: 'container',
			layout: 'hbox',
			margin: '0 0 10 5',
			items: [{
				xtype: 'fieldset',
				title: 'Restore Previous Versions',
				padding: '0 10 10',
				items: [{
					xtype: 'label',
					text: $$('View the index at the selected time'),
					style: 'font-size: 11px;'
				},{
					xtype: 'indexoptionsvtimegrid',
					id: 'indexoptionsvtimegrid_id',
					style: 'border: solid #cccccc 1px',
					margin: '5 0 5 0',
					height: 400,
					width: 200
				}/*,{
					xtype: 'checkbox',
					boxLabel: $$('Show only data archived with the selected job'),
					itemId: 'vtimeOnly',
					hideLabel: true,
					margin: '8 0 0 6',
					width: 180,
					listeners: {
						change: function (cb, value, ov) {
							store_tree.load({
								params: {
									caller: 'setVtimeonly',
									node: store_tree.currentUrl,
									vtimeonly: value
								}
							});
						}
					}
				}*/]
			}, {
				xtype: 'component',
				width: 10
			}, {
				xtype: 'fieldset',
				title: 'Pools & Volumes',
				padding: '0 10 10',
				items: [{
					xtype: 'label',
					text: $$('Restore from a specific archive pool'),
					style: 'font-size: 11px;'
				},{
					xtype: 'indexoptionspoolgrid',
					id: 'indexoptionspoolgrid_id',
					style: 'border: solid #cccccc 1px',
					margin: '5 0 5 0',
					height: 117,
					width: 270
				},{
					xtype: 'label',
					text: $$('Restore from a specific archive volume(s)'),
					style: 'font-size: 11px;'
				},{
					xtype: 'indexoptionsvolumegrid',
					id: 'indexoptionsvolumegrid_id',
					style: 'border: solid #cccccc 1px',
					margin: '5 0 5 0',
					height: 257,
					width: 270
				}]
			}]
		}
		indexOptionsColDef = [
		    { dataIndex: 'id', hideable: false, hidden: true },
		    { dataIndex: 'vtime', header: $$('Archives'), renderer: eval('renderDate'), filter: {type: 'date',dateFormat: 'U'}, hideable: false, flex: 1 }
		];
	} else if ( treeType == 'BsxTree' ) {
		var windowPanel = [{
			xtype: 'panel',
			region: 'center',
			layout: 'fit',
			id: 'centertree',
			padding: '0',
			border: false
		}];
		var menuBarDef = [{ xtype: 'tbspacer' },{
			xtype : 'button',
			iconCls: 'btn-search',  
			cls: 'btn-padding-left',
			text: $$('Search'),
			value: 'browse',
			id: 'searchButton',
			toggleGroup: 'crmNaviBtnGroup',
			enableToggle: true,
			handler: function() {
				searchOrBrowse('store_load');
			}
		},/*{ xtype : 'tbseparator' },{ xtype: 'tbspacer' },{
			xtype: 'tbtext',
			text: 'Browsable backups:'            
		},*/{
			xtype : 'button',
			iconCls: 'btn-clockback',  
			cls: 'btn-padding-left',
			text: $$('Index'),
			menu: vtimeMenu = Ext.create('Ext.menu.Menu', {
				defaults: {
					margin: '0 5 0',
					handler: function(obj) {
						if ( workmodus.value == 'search' ) searchOrBrowse('store_load');
						store_tree.load({
							params: {
								caller: 'setSnapshot',
                                procedure: '',
								node: store_tree.currentUrl,
								vtime: obj.itemId
							},
                            callback : function(records, operation, success) {
                                console.log('reload selection store');
                                store_selection.load({params: {procedure: 'listing'}});
                            }
						});
					}             
				}
			})
		},{ xtype : 'tbfill' },{
			xtype : 'button',
			iconCls: 'btn-viewoption',  
			cls: 'btn-padding-left',
			text: $$('View'),
			handler: function() {
				viewoptionWindow();                
			}
		}];
		viewOptionsDef = [{
			xtype: 'radiogroup',
			fieldLabel: $$('Items per page'),
			labelAlign: 'top',
			defaults: {
				name: 'pageSize',
				style: {
					whiteSpace: 'nowrap',
					marginLeft: "10px"
				}
			},
			items: [{
				inputValue: '0',
				boxLabel: $$('Paging off')
			}, {
				inputValue: '50',
				boxLabel: '50'
			}, {
				inputValue: '100',
				boxLabel: '100'
			}, {
				inputValue: '200',
				boxLabel: '200'
			}, {
				inputValue: '500',
				boxLabel: '500'
			}],
			setValue: function (value) {
				if (!Ext.isObject(value)) {
					var obj = new Object();
					obj[this.name] = value;
					value = obj;
				}
				Ext.form.RadioGroup.prototype.setValue.call(this, value);
			}
		},{
			xtype: 'radiogroup',
			fieldLabel: $$('Show columns'),
			labelAlign: 'top',
			margin: '5 0 4 0'
		},{
			xtype: 'viewoptionscolgrid',
			itemId: 'viewoptionscolgrid_id',
			height:180
		}];
		indexOptionsTabs = {
			xtype: 'container',
			layout: 'hbox',
			margin: '0 0 10 5',
			items: [{
				xtype: 'fieldset',
				title: $$('Restore Previous Versions'),
				padding: '0 10 10',
				items: [{
					xtype: 'label',
					text: $$('View the index at the selected time'),
					style: 'font-size: 11px;'
				},{
					xtype: 'indexoptionsvtimegrid',
					id: 'indexoptionsvtimegrid_id',
					style: 'border: solid #cccccc 1px',
					margin: '5 0 5 0',
					height: 400,
					width: 200
				}]
			}, {
				xtype: 'component',
				width: 10
			}, {
				xtype: 'fieldset',
				title: 'Pools & Volumes',
				padding: '0 10 10',
				items: [{
					xtype: 'label',
					text: $$('Restore from a specific backup pool'),
					style: 'font-size: 11px;'
				},{
					xtype: 'indexoptionspoolgrid',
					id: 'indexoptionspoolgrid_id',
					style: 'border: solid #cccccc 1px',
					margin: '5 0 5 0',
					height: 117,
					width: 250
				},{
					xtype: 'label',
					text: $$('Restore from a specific backup volume(s)'),
					style: 'font-size: 11px;'
				},{
					xtype: 'indexoptionsvolumegrid',
					id: 'indexoptionsvolumegrid_id',
					style: 'border: solid #cccccc 1px',
					margin: '5 0 5 0',
					height: 257,
					width: 250
				}]
			}]
		}
		indexOptionsColDef = [
		    { dataIndex: 'id', hideable: false, hidden: true },
		    { dataIndex: 'vtime', header: $$('Backups'), renderer: eval('renderDate'), filter: {type: 'date',dateFormat: 'U'}, hideable: false, flex: 1 }
		];
	} else {
		var windowPanel = [{
			xtype: 'panel',
			region: 'center',
			layout: 'fit',
			id: 'centertree',
			padding: '0',
			border: false
		}];

		var menuBarDef = [{
			xtype : 'button',
			value: 'browse',
			id: 'searchButton',
			hidden: true
		}];
	}

	// view options ******************************************************************
	// general form fields
	Ext.define('m_viewoptionsform', {
		extend: 'Ext.data.Model',
		fields: ['pageSize','previewSize']
	});

	Ext.define('m_viewoptionsform_error', {
		extend: 'Ext.data.Model',
		fields: ['id', 'msg']
	});

	// column grid
	Ext.define('m_viewoptionscolgrid',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'active',  type: 'bool' },
		    {name: 'id',  type: 'string' },
		    {name: 'text',  type: 'string' },
		    {name: 'type',  type: 'string' }
		]
	});

	store_viewoptionscolgrid = Ext.create('Ext.data.Store', {
		model: 'm_viewoptionscolgrid',
		proxy: {
			type: 'memory',
			reader: {
				type: 'xml',
				record: 'col'
			}
		}
	});

	Ext.define('Tree.Viewoptionscol.Grid', {
		extend: 'Ext.grid.Panel',
		xtype: 'viewoptionscolgrid',
		multiSelect: true,
		disableSelection: true,
		hideHeaders: true,
		bodyStyle: 'border-width: 0px 0px 0px 0px;',
		columns: [
			{ dataIndex: 'active', width: 30, xtype: 'checkcolumn' },
		    { dataIndex: 'text', header: $$('Column'), flex: 1 }
		],
		initComponent: function() {
			var me = this;

			Ext.apply(me, {
				store: store_viewoptionscolgrid
		  	});    
			me.callParent(arguments);
		}
	});

	// index options ******************************************************************
	// snapshot grid
	Ext.define('m_indexoptionsvtimegrid',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'active',  type: 'bool' },
		    {name: 'id',  type: 'string' },
	        {name: 'vtime', type: 'date', dateFormat: 'U' }
	     ]
	});

	store_indexoptionsvtimegrid = Ext.create('Ext.data.Store', {
		model: 'm_indexoptionsvtimegrid',
		autoLoad: false,
		proxy: {
			type: 'ajax',
			url: browser_index,
 			timeout: 180000,
			actionMethods: 'POST',
			extraParams: {
				caller: 'ajaxGetSnapshots',
			},
			reader: {
				type: 'xml',
				totalProperty: 'totalCount',
				record: 'col'
			}
		},
		listeners: {
			load: function(records, successful, eOpts ) {
				var idx = this.findRecord('active', true);
				if ( idx ) {
					var grid = Ext.getCmp('indexoptionsvtimegrid_id');
					// to make sure the onchnage event triggers
					grid.suspendEvents();
					grid.getSelectionModel().deselect(idx);
					grid.resumeEvents(false);
					grid.getSelectionModel().select(idx);
				}
			}
		}
	});

	var selModelVtime = Ext.create('Ext.selection.CheckboxModel', {
		showHeaderCheckbox : false,
		mode: 'SINGLE',
		listeners: {
			select: function(model, record, index) {
				id = record.get('id');
				store_tree.load({
					params: {
						caller: 'setSnapshot',
                        procedure: '',
						node: store_tree.currentUrl,
						vtime: id
					},
                    callback : function(records, operation, success) {
                        console.log('reload selection store');
                        store_selection.load({params: {procedure: 'listing'}});
                   }
				});
			}
		}
	});

	Ext.define('Tree.Indexoptionsvtime.Grid', {
		extend: 'Ext.grid.Panel',
		xtype: 'indexoptionsvtimegrid',
		selModel: selModelVtime,
		multiSelect: false,
		hideHeaders: true,
		bodyStyle: 'border-width: 0px 0px 0px 0px;',
		initComponent: function() {
			var me = this;
			Ext.apply(me, {
				columns: indexOptionsColDef,
				store: store_indexoptionsvtimegrid
			});    
			me.callParent(arguments);
		}
	});

	// pool grid
	Ext.define('m_indexoptionspoolgrid',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'active',  type: 'bool' },
			{name: 'id',  type: 'string' },
			{name: 'name',  type: 'string' },
		    {name: 'text', type: 'string' }
		]
	});

	store_indexoptionspoolgrid = Ext.create('Ext.data.Store', {
		model: 'm_indexoptionspoolgrid',
		proxy: {
			type: 'ajax',
			url: browser_index,
 			timeout: 180000,
			actionMethods: 'POST',
			extraParams: {
				caller: 'ajaxGetPools',
			},
			reader: {
				type: 'xml',
				record: 'pool'
			}
		},
		listeners: {
			load: function(records, successful, eOpts ) {
				var idx = this.findRecord('active', true);
				if ( idx ) {
					var grid = Ext.getCmp('indexoptionspoolgrid_id');
					// select pool and trigger load event
					grid.getSelectionModel().select(idx,0,0);
				}
			}
		}
	});

	var selModelPool = Ext.create('Ext.selection.CheckboxModel', {
		showHeaderCheckbox : false,
		mode: 'SINGLE',
		listeners: {
			select: function(model, record, index) {
				var iwin = Ext.getCmp('indexoptionpanel_id');
			    iwin.mask($$('Setting pool, please wait ...'))
				var pool = record.get('name');
				Ext.Ajax.request({
					url: browser_index,
         			timeout: 180000,
					method: 'POST',
					params: { 
						caller: 'ajaxSetPools',
						pool: pool
					},
					scope: this,
					failure: function(){
			            iwin.unmask();
						extAlert(1,'Could not connect to server');
					}, 
					success:function(response, options) {
			            iwin.unmask();
                        store_indexoptionsvolumegrid.load({
                            params: {
                                caller: 'ajaxGetVolumes',
                                pool: pool
                            }
                        });
                        store_indexoptionsvtimegrid.load();
				    }
				});
			}
		}
	});

	Ext.define('Tree.Indexoptionspool.Grid', {
		extend: 'Ext.grid.Panel',
		xtype: 'indexoptionspoolgrid',
		selModel: selModelPool,
		multiSelect: false,
		hideHeaders: true,
		bodyStyle: 'border-width: 0px 0px 0px 0px;',
		columns: [
			{ dataIndex: 'text', header: $$('Pool Selection'), hideable: false, flex: 1 }
		],
		initComponent: function() {
			var me = this;
			Ext.apply(me, {
				store: store_indexoptionspoolgrid
			});    
			me.callParent(arguments);
		  }
	});

	// volume grid
	Ext.define('m_indexoptionsvolumegrid',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'active',  type: 'bool' },
			{name: 'id',  type: 'string' },
		    {name: 'text', type: 'string' }
		]
	});

	store_indexoptionsvolumegrid = Ext.create('Ext.data.Store', {
		model: 'm_indexoptionsvolumegrid',
		proxy: {
			type: 'ajax',
			url: browser_index,
         	timeout: 180000,
			actionMethods: 'POST',
			extraParams: {
				caller: 'ajaxGetVolumes',
			},
			reader: {
				type: 'xml',
				record: 'volume'
			}
		},
		listeners: {
			load: function(records, successful, eOpts ) {
				//var idx = this.findRecord('active', true);
				var grid = Ext.getCmp('indexoptionsvolumegrid_id');
				this.each(function(item, index, count) {
					if( item.get('active') ) {
						// select but supress select event
						grid.getSelectionModel().select(index,1,1);
					} else {
						grid.getSelectionModel().deselect(index,1,1);
					}
				});
			}
		}
	});

	var selModelVolume = Ext.create('Ext.selection.CheckboxModel', {
		showHeaderCheckbox : false,
        listeners: {
            selectionchange: function(model, selected) {
                model.view.up().up().down('button[itemId=apply_id]').setDisabled(!selected.length);
            }
        },
	});

	Ext.define('Tree.Indexoptionsvolume.Grid', {
		extend: 'Ext.grid.Panel',
		xtype: 'indexoptionsvolumegrid',
		selModel: selModelVolume,
		hideHeaders: true,
		bodyStyle: 'border-width: 0px 0px 0px 0px;',
		columns: [
			{ dataIndex: 'text', flex: 1 },
			{ dataIndex: 'id', width: 60 }
		],
		initComponent: function() {
			var me = this;
			Ext.apply(me, {
				store: store_indexoptionsvolumegrid,
				dockedItems: [{
					xtype: 'toolbar',
					dock: 'bottom',
        			ui: 'footer', 
					style: 'border: solid #bbbbbb 0px',
        			layout: { pack: 'center' },
					items: [{    
						xtype : 'button',       
						text: $$('Apply Volume(s)'),
	            		itemId: 'apply_id',
			            disabled: true,
						handler: function() {
							var s = me.getSelectionModel().getSelection();
							var grid = Ext.ComponentQuery.query('#indexoptionpanel_id indexoptionspoolgrid')[0]
							var pool = grid.getSelectionModel().getSelection()[0].get('name');
							// And then you can iterate over the selected items, e.g.: 
							var volumes = [];
							Ext.each(s, function (item) {
							  volumes.push(item.data.id);
							});
							Ext.Ajax.request({
								url: browser_index,
                     			timeout: 180000,
								method: 'POST',
								params: { 
									caller: 'ajaxSetVolumes',
									pool: pool,
									volumes: Ext.encode(volumes)
								},
								scope: this,
								failure: function(){
									extAlert(1,'Could not connect to server');
								} 
							});
						}
					}]
				}],
			});    
			me.callParent(arguments);
		},
	});

    // rename window

    Ext.define('Tree.ElementRename.Window', {
        extend: 'Ext.window.Window',

        width: 400,
        modal : true,
        layout: {
            type: 'vbox',
            align: 'stretch'
        },
        resizable: false,
        closeAction: 'destroy',
        config: {
            selected: '',
            nodename: ''
        },
        constrain: true
    });

    // delete window

    Ext.define('Tree.ElementDelete.Window', {
        extend: 'Ext.window.Window',

        width: 400,
        modal : true,
        layout: 'fit',
        resizable: false,
        closeAction: 'destroy',
        config: {
            selected: '',
            nodename: ''
        },
        constrain: true
    });

	// index move tree
	Ext.define('m_filepicker',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'id',  type: 'string', defaultValue: ''},
			{name: 'name', type: 'string', defaultValue: '' }
		]
	});

    Ext.define('Tree.FilePicker.Store', {
        extend: 'Ext.data.TreeStore',
        model: 'm_filepicker',
        proxy: {
            type: 'ajax',
            url: browser_index,
            timeout: 180000,
            actionMethods: 'POST',
            extraParams: {
                caller: 'ajaxFilePicker'
            },
            reader: {
                type: 'json',
				totalProperty: 'totalCount',
				rootProperty: 'nodes'
            }
        },
        sorters: [{
            property: 'leaf',
            direction: 'ASC'
        },{
            property: 'name',
            direction: 'ASC'
        }]
    });

    Ext.define('Tree.FilePicker.Grid', {
        extend: 'Ext.tree.Panel',
		xtype: 'filepickertree',
        padding: '0 0 0 0',
        useArrows: true,
        multiSelect: false,
        singleExpand: true,
        rootVisible: true,
        border: true,
        config: {
            selected: '',
            path: ''
        },
        columns: [{ text: $$('Folder'), dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
        listeners: {
            select: function(model, record, item) {
                var me = this;
                me.setSelected(record.data.id);
                //me.setPath(record.data.path);
                if (record.data.leaf)  {
                    model.view.up().up().down('button[itemId=select_id]').setDisabled(true);
                } else {
                    model.view.up().up().down('button[itemId=select_id]').setDisabled(false);
                }
                Ext.Ajax.request({
                    url: browser_index,
                    method: 'GET',
                    params: { 
                        caller: 'ajaxElementPath',
                        node: record.data.id
                    },
                    scope: this,
                    failure: function(){
                        extAlert(1,'Could not connect to server');
                    }, 
                    success: function(result, request) {
                        var json = Ext.decode(result.responseText);
                        me.setPath(json.path);
                    }
                });
            }
        },
        initComponent: function() {
            var me = this;
            Ext.applyIf(me, {
                store: new Tree.FilePicker.Store()
            });    
            me.callParent(arguments);
        }

    });

    Ext.define('Tree.elementMove.Window', {
        extend: 'Ext.window.Window',

        width: 400,
        height: 500,
        modal : true,
        layout: {
            type: 'vbox',
            align: 'stretch'
        },
        border: false,
        resizable: true,
        closeAction: 'destroy',
        config: {
            selected: '',
            nodename: ''
        },
        constrain: true,
        listeners: {
			show: function(view, rec, node, index, e) {
			    var me = this;
			    var tree_panel   = me.down('filepickertree');
			    var picker_store = tree_panel.getStore();
                picker_store.setRootNode();
                tree_panel.setRootNode(null);
                var newRoot = {
                    name: rootText,
                    id: rootUrl,
                    path: '/',
                    expanded: true
                }
                picker_store.setRootNode(newRoot);

			}
        }
    });

	// Selection ******************************************************************

	store_selection = Ext.create('Ext.data.Store', {
		fields:['type', 'name'],
		proxy: {
			type: 'ajax',
			url: browser_index,
			timeout: 3600000,
			actionMethods: {
                create: 'POST',
                read: 'POST',
                update: 'POST',
                destroy: 'POST'
            },			
			extraParams: {
				caller: 'ajaxSelection',
				node: rootUrl,
				isXml: true
			},
			reader: {
				type: 'xml',
				root: 'nodes',
				record: 'node'
			}
		}
	});

	Ext.define('Tree.Restore.Grid', {
		extend: 'Ext.grid.Panel',
		xtype: 'selectiongrid',
		multiSelect: true,
		border: false,
		columns: [
			{ dataIndex: 'type', hidden: true },
			{ header: $$('Name'), dataIndex: 'name', renderer: eval('renderIconIdx'), flex: 1 }
		],
		initComponent: function() {
			var me = this;

			Ext.apply(me, {
				store: store_selection
			});    
			me.callParent(arguments);
		}
	});

	// context menu ***********************************************************

	Ext.define('m_contextmenu',{
		extend: 'Ext.data.Model',
		fields: [
			{name: 'text',  type: 'string', defaultValue: ''},
		    {name: 'func',  type: 'string', defaultValue: ''}
    	]
	});

	var store_contextmenu = new Ext.data.Store({
		model: 'm_contextmenu',
		data: xmldata,
		proxy: {
			type: 'memory',
			reader: {
				type: 'xml',
				record: 'contextmenu'
			}
		}
	});

	var menus_attr = [];
	for(var i=0;i<store_contextmenu.getTotalCount();i++){
		var menu_attr = {};
		var mtext = store_contextmenu.getAt(i).data['text'];
		if ( mtext == '-' ) { 
			menu_attr['xtype'] = 'menuseparator';
		} else {
			menu_attr['text']    = mtext;
			menu_attr['func']    = store_contextmenu.getAt(i).data['func'];
			menu_attr['handler'] = function(){eval(this.func);};
		}
		// add to column array
		menus_attr.push(menu_attr);
	};
	
    if ( treeType == 'AsxTree' && isAdmin == "1" && idxModify == "1" ) {
        menus_attr.push({xtype:'menuseparator'});
        var submenu = {
            text:  $$('Element')+' ...',
            menu: {
                items:[{
                    text: $$('Rename'),
                    handler: function(){modifyIndex(indexElementRename)}
                },{
                    text: $$('Move'),
                    handler: function(){modifyIndex(indexElementMove)}
                },{
                    text: $$('New Folder'),
                    handler: function(){modifyIndex(indexElementNew)}
                }]
            }
        }
        menus_attr.push(submenu);
    }

	menuContext = new Ext.menu.Menu({
		itemId: 'menuContext_id',
		items: menus_attr
	});

    // bottom toolbar ***********************************************************

    var store_bottombar = new Ext.data.Store({
        model: 'm_contextmenu',
        data: xmldata,
        proxy: {
            type: 'memory',
            reader: {
                type: 'xml',
                record: 'bottombar'
            }
        }
    });

    var tbar_attr = [{ xtype : 'tbspacer', width: 5 }];

    for(var i=0;i<store_bottombar.getTotalCount();i++){
        var but_attr = {};
        var mtext = store_bottombar.getAt(i).data['text'];
        if ( mtext === '-' ) { 
            but_attr['xtype'] = 'tbspacer';
        } else if ( mtext === '--' ) { 
            but_attr['xtype'] = 'tbfill';
        } else {
            but_attr['text']    = mtext;
            but_attr['func']    = store_bottombar.getAt(i).data['func'];
            but_attr['handler'] = function(){eval(this.func);};
        }
        // add to column array
        tbar_attr.push(but_attr);
    };
    tbar_attr.push({ xtype : 'tbspacer', width: 5 });

	var fixButtonBar = new Ext.Toolbar({
		dock: 'bottom',
		defaultButtonUI: 'default',
	    padding: '10 0 10 0',  
		border: 0,
		itemId: 'fixButtonBar_id',
		defaults: {
			xtype : 'button',
			scale: 'medium',
			cls: 'btn-footer-button'
		},
		items: tbar_attr
	});

	// define and read column header ******************************************

	var gridHeaderStore = new Ext.data.Store({
		model: 'colHeadTree',
		data: xmldata,
		proxy: {
			type: 'memory',
			reader: {
				type: 'xml',
				record: 'col'
			}
		}
	});

	var cols_attr = [];
	var cols_field = [];
	for(var i=0;i<gridHeaderStore.getTotalCount();i++){
		var col_attr = {};
		var col_field = {};
		if (!gridHeaderStore.getAt(i).data['hidden']) {
			col_attr['stateId']  = 'state_id_' + gridHeaderStore.getAt(i).data['dataIndex'];
			col_attr['text'] = gridHeaderStore.getAt(i).data['text'];
			col_attr['dataIndex'] = gridHeaderStore.getAt(i).data['dataIndex'];
			col_attr['sortable']  = gridHeaderStore.getAt(i).data['sortable'];
			col_attr['width']     = gridHeaderStore.getAt(i).data['width'];
			col_attr['flex']      = gridHeaderStore.getAt(i).data['flex'];
			col_attr['renderer']  = eval(gridHeaderStore.getAt(i).data['renderer']);
			col_attr['align']     = gridHeaderStore.getAt(i).data['align'];
			cols_attr.push(col_attr);
		};
		// add to field array
		col_field['name'] = gridHeaderStore.getAt(i).data['dataIndex'];
		col_field['type'] = gridHeaderStore.getAt(i).data['dataType'];
		if ( col_field['type'] == 'date' ) {
			col_field['dateFormat'] = gridHeaderStore.getAt(i).data['dateFormat'];
		}
		cols_field.push(col_field);
	};

	//console.log(cols_attr);

	//  Tree Tree Tree Tree Tree Tree Tree Tree Tree Tree Tree Tree Tree Tree Tree Tree Tree Tree 

	Ext.define('bodyTree',{
		extend: 'Ext.data.Model',
		fields: cols_field
	});

	// stores for grid panel data

	store_tree = Ext.create('Ext.data.JsonStore', {
		model: 'bodyTree',
		autoLoad: true,
		pageSize: pageSize,
		remoteSort: true,
		sorters: ['name'],
		currentQuery: '',
		proxy: {
			type: 'ajax',
			// timeout 1 Stunde
			timeout: 3600000,
			url: browser_index,
			actionMethods: 'POST',
			extraParams: {
				caller: 'changeDir',
				node: rootUrl
			},
			reader: {
				type: 'json',
				totalProperty: 'totalCount',
				rootProperty: 'nodes'
			},
			afterRequest: function(req, res) {
				if (req.getOperation().success) {
			        var JSONdata = req.getOperation().getResponse().responseJson;
					showJsonMessage(JSONdata);
					if ( workmodus.value == 'browse' ) {
		    		    // store current directory
			    	    store_tree.currentUrl   = JSONdata.params.pAddr;
				        store_tree.currentDir   = JSONdata.params.pName;
				        store_tree.currentPath  = JSONdata.params.pPath;
				        store_tree.currentVtime = JSONdata.params.vtime;
				        // console.log(JSONdata.params);
    					// set create crum bar 
						var store = doBreadCrumBar(JSONdata);
					}
					if ( treeType == 'BsxTree' || treeType == 'AsxTree' ) {
					    store_snapshot.loadRawData(JSONdata);
					}
					if ( treeType == 'AsxTree' ) {
						if ( !viewportGallery.getCollapsed() ) {
							store_gallery.loadRawData(JSONdata);
						}               
						store_preview.removeAll();
						panel_meta.myRemoveall();
					}
					// reset path on each dir change
					if ( Ext.getCmp('pathToolbar_id') ) Ext.getCmp('pathToolbar_id').remove('path_id');
				} else {
					alert($$('Server session has expired.'));
					parent.location.href='/login/logout';
				}
			}
		}
	});

	// stores for search toolbar

	store_searchfields = Ext.create('Ext.data.Store', {
		fields: ['id', 'text', 'type', 'itype', 'ilist'],
		data: xmldata,
		proxy: {
			type: 'memory',
			reader: {
				type: 'xml',
				record: 'searchfield'
			}
		}
	});

	var store_oper_string = Ext.create('Ext.data.Store', {
		fields: ['value','text', 'description' ],
		data : [
		        { value: '*=',  text: $$("contains word"), description: $$("Search for one or more words in a file name.<br>E.g. search for 'project', 'image' or '300' will find 'project image-300dpi.jpg'.") },
		        { value: '=*',  text: $$("contains string"), description: $$("Search for a string in a file name.<br>E.g. search for 'image' will find 'projectimage300dpi.jpg'. Note: Could be very slow!") }
		        ]
	});

	var store_oper_meta = Ext.create('Ext.data.Store', {
		fields: ['value','text', 'description' ],
		data : [
		        { value: '*=',  text: $$('starts with'), description: $$("Search for a string the metadata field starts with.") },
		        { value: '=*',  text: $$('contains string'), description: $$("Search for a string in a metadata field. Note: Could be very slow!") }
		        ]
	});

	var store_oper_match = Ext.create('Ext.data.Store', {
		fields: ['value','text'],
		data : [{ value: '==',  text: $$("is") }]
	});

	var store_oper_date = Ext.create('Ext.data.Store', {
		fields: ['value','text'],
		data : [
		        { value: '==', text: $$('is exactly') },
		        { value: '<', text: $$('is before') },
		        { value: '>', text: $$('is after') },
		        { value: '><', text: $$('within last') }
		        ]
	});

	var store_oper_size = Ext.create('Ext.data.Store', {
		fields: ['value','text'],
		data : [
		        { value: '==', text: $$('equals') },
		        { value: '<', text: $$('is lesser than') },
		        { value: '>', text: $$('is greater than') }
		        ]
	});

	var store_oper_number = Ext.create('Ext.data.Store', {
		fields: ['value','text'],
		data : [
		        { value: '==', text: $$('is exactly') },
		        { value: '<', text: $$('is lesser than') },
		        { value: '>', text: $$('is greater than') }
		        ]
	});

	var store_units_size = Ext.create('Ext.data.Store', {
		fields: ['value','text'],
		data : [
		        { value: '1', 'text':'Byte'},
		        { value: '1024', 'text':'KB'},
		        { value: '1048576', 'text':'MB'},
		        { value: '1073741824', 'text':'GB'}
		        ]
	});

	var store_units_days = Ext.create('Ext.data.Store', {
		fields: ['value','text'],
		data : [
		        { value: '1', 'text':$$('Days')},
		        { value: '7', 'text':$$('Weeks')},
		        { value: '30', 'text':$$('Months')}
		        ]
	});

	var store_value_filetype = Ext.create('Ext.data.Store', {
		fields: ['value','text'],
		data : [
		        { value: '3', 'text':$$('File')},
		        { value: '1', 'text':$$('Folder')}
		        ]
	});

	//  Search field definition ----------------------------------------------

	Ext.define('Tree.Toolbar.Search.FieldName', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'fieldName',
        itemId: 'field_id',
        width: 120,
        editable: false,
        store : store_searchfields,
        queryMode: 'local',
        displayField: 'text',
        valueField: 'id',
        value: 'name'
	});

	Ext.define('Tree.Toolbar.Search.StringOper', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'stringOper',
		itemId: 'query_id',
		width: 140,
		editable: false,
		store : store_oper_string,
		queryMode: 'local',
		displayField: 'text',
		valueField: 'value',
		value: '*=',
        listConfig: {
            itemTpl: [
                '<div data-qtip="{description}">{text}</div>'
        ]}
	});

	Ext.define('Tree.Toolbar.Search.MetaOper', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'metaOper',
		itemId: 'query_id',
		width: 140,
		editable: false,
		store : store_oper_meta,
		queryMode: 'local',
		displayField: 'text',
		valueField: 'value',
		value: '*=',
        listConfig: {
            itemTpl: [
                '<div data-qtip="{description}">{text}</div>'
        ]}
	});

	Ext.define('Tree.Toolbar.Search.MatchOper', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'matchOper',
		itemId: 'query_id',
		width: 140,
		editable: false,
		store : store_oper_match,
		queryMode: 'local',
		displayField: 'text',
		valueField: 'value',
		value: '=='
	});

	Ext.define('Tree.Toolbar.Search.DateOper', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'dateOper',
		itemId: 'query_id',
		width: 140,
		editable: false,
		store : store_oper_date,
		queryMode: 'local',
		displayField: 'text',
		valueField: 'value',
		value: '==',
		listeners: {
			change: function(combobox) {
				var oper = combobox.getValue();
				var thisTbar  = this.up('SearchToolbar');
				thisTbar.remove('value_id');
				if ( oper == '><' ) {
					thisTbar.insert(2,{
						xtype: 'stringField'
					});
					thisTbar.insert(3,{
						xtype: 'daysUnits'
					});
				} else {
					thisTbar.remove('units_id');
					thisTbar.insert(2,{
						xtype: 'dateFeld'
					});
				}
			}
		}
	});

	Ext.define('Tree.Toolbar.Search.NumberOper', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'numberOper',
		itemId: 'query_id',
		width: 140,
		editable: false,
		store : store_oper_number,
		queryMode: 'local',
		displayField: 'text',
		valueField: 'value',
		value: '=='
	});

	Ext.define('Tree.Toolbar.Search.SizeOper', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'sizeOper',
		itemId: 'query_id',
		width: 140,
		editable: false,
		store : store_oper_size,
		queryMode: 'local',
		displayField: 'text',
		valueField: 'value',
		value: '=='
	});

	Ext.define('Tree.Toolbar.Search.SizeUnits', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'sizeUnits',
		itemId: 'units_id',
		width: 60,
		editable: false,
		store : store_units_size,
		queryMode: 'local',
		displayField: 'text',
		valueField: 'value',
		value: '1'
	});

	Ext.define('Tree.Toolbar.Search.DaysUnits', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'daysUnits',
		itemId: 'units_id',
		width: 60,
		editable: false,
		store : store_units_days,
		queryMode: 'local',
		displayField: 'text',
		valueField: 'value',
		value: '1'
	});

	Ext.define('Tree.Toolbar.Search.fileFolderField', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'fileFolderField',
		itemId: 'value_id',
		width: 100,
		editable: false,
		store : store_value_filetype,
		queryMode: 'local',
		displayField: 'text',
		valueField: 'value',
		value: '3'
	});

	Ext.define('Tree.Toolbar.Search.StringField', {
		extend: 'Ext.form.field.Base',
		xtype: 'stringField',
		itemId: 'value_id',
		width: 100,
		listeners: {
			specialkey: function(field, e){
				if (e.getKey() == e.ENTER) {
					var thisTbar = this.up('SearchToolbar');
					thisTbar.getComponent('find_id').fireEvent('click');
				}
			}
		}
	});

	Ext.define('Tree.Toolbar.Search.DateFeld', {
		extend: 'Ext.form.field.Date',
		xtype: 'dateFeld',
		itemId: 'value_id',
		format: Ext.Date.patterns[userDateFormat],
		width: 100
	});

	Ext.define('Tree.Toolbar.Search.Path', {
		extend: 'Ext.button.Button',
		xtype: 'pathButton',
		itemId: 'path_id',
		text: '',
		handler: function(obj) {
			if ( workmodus.value == 'search' ) searchOrBrowse();
			store_tree.currentPage = 1;
			store_tree.proxy.extraParams = {
					caller: 'changeDir',
					procedure: 'changeParent',
					node: obj.value
			};
			store_tree.load();
		}             
	});

	Ext.define('Tree.Toolbar.Search.DropMenu', {
		extend: 'Ext.form.field.ComboBox',
		xtype: 'dropMenu',
		itemId: 'value_id',
		width: 100,
		queryMode: 'local',
		displayField: 'text',
		valueField: 'value',
		listeners: {
			specialkey: function(field, e){
				if (e.getKey() == e.ENTER) {
					var thisTbar = this.up('SearchToolbar');
					thisTbar.getComponent('find_id').fireEvent('click');
				}
			}
		}
	});

	//  Toolbars -------------------------------------------------------------

	//  crumToolbar

	crumBar = new Ext.Toolbar({
		dock: 'top',
		padding: '2 0 2 0',  
		height: 30,
		cls: 'crumBar',
		defaults: {
			xtype : 'button'
		}
	});

	menuBar = new Ext.Toolbar({
		dock: 'top',
		height: 30,
		padding: '2 0 2 0',  
		items: menuBarDef
	});

	//  PagingToolbar

	Ext.define('Tree.Toolbar.Paging', {
		extend: 'Ext.toolbar.Paging',
		xtype: 'PagingToolbar',
		dock: 'bottom',
		height: 30,
		padding: '0 0 0 0',  
		border: '0 0 0 0',
		store: store_tree,   // same store GridPanel is using
		displayInfo: true,
		displayMsg: $$('Displaying {0} - {1}'),
		listeners: {
			beforeRender: function(pt) {
				pt.getComponent('inputItem').readOnly = true;
				pt.getComponent('afterTextItem').hidden = true;
				pt.getComponent('last').hidden = true;
			}
		},
		items: [{ xtype: 'tbseparator' },{ xtype: 'tbtext', text: $$('Items per page')+': ' + pageSize  }]
	});

	//  PathToolbar

	Ext.define('Tree.Toolbar.Pathbar', {
		extend: 'Ext.toolbar.Toolbar',
		xtype: 'PathToolbar',
		dock: 'bottom',
		height: 30,
		padding: '2 0 2 0',
		border: '0 0 1 0'
	});

	//  SearchToolbar

	Ext.define('Tree.Toolbar.Search', {
		extend: 'Ext.toolbar.Toolbar',
		xtype: 'SearchToolbar',
		dock: 'top',
		height: 30,
		padding: '0 0 0 0',  
		border: '0 0 1 0',
		cls: 'searchtoolbar_cls',
		defaults: {
			margin: '2 0 2 5'
		},
		items: [{
			xtype: 'fieldName',
			listeners: {
				change: function(combobox) {
					var id     = combobox.getValue();
					var record = store_searchfields.getById(id);
					var type   = record.get('type');
					var itype  = record.get('itype');
					var ilist  = record.get('ilist');
					var thisTbar  = this.up('SearchToolbar');
					thisTbar.remove('query_id');
					thisTbar.remove('units_id');
					if ( type == 'date' ) {
						thisTbar.insert(1,{
							xtype: 'dateOper'
						});
						thisTbar.remove('value_id');
						thisTbar.insert(2,{
							xtype: 'dateFeld'
						});
					} else if ( type == 'int' ) {
						thisTbar.insert(1,{
							xtype: 'sizeOper'
						});
						thisTbar.remove('value_id');
						thisTbar.insert(2,{
							xtype: 'stringField'
						});
						thisTbar.insert(3,{
							xtype: 'sizeUnits'
						});
					} else if ( type == 'number' ) {
						if ( itype == 'dropdown' ) {
							thisTbar.insert(1,{
								xtype: 'numberOper'
							});
							thisTbar.remove('value_id');
							thisTbar.insert(2,{
								xtype: 'dropMenu',
								store : Ext.decode(ilist)
							});
						} else {
							thisTbar.insert(1,{
								xtype: 'numberOper'
							});
							thisTbar.remove('value_id');
							thisTbar.insert(2,{
								xtype: 'stringField'
							});
						}
					} else if ( type == 'string' ) {
						if ( itype == 'dropdown' ) {
							thisTbar.insert(1,{
								xtype: 'matchOper'
							});
							thisTbar.remove('value_id');
							thisTbar.insert(2,{
								xtype: 'dropMenu',
								store : Ext.decode(ilist)
							});
						} else if ( itype == 'textfield' ) {
							thisTbar.insert(1,{
								xtype: 'metaOper'
							});
							if ( !thisTbar.down('stringField') ) {
							    thisTbar.remove('value_id');
							    thisTbar.insert(2,{
								    xtype: 'stringField'
							    });
							}
						} else if ( itype == 'forFileType' ) {
							thisTbar.insert(1,{
								xtype: 'matchOper'
							});
							thisTbar.remove('value_id');
							thisTbar.insert(2,{
								xtype: 'fileFolderField'
							});
						} else {
							thisTbar.insert(1,{
								xtype: 'stringOper'
							});
							if ( !thisTbar.down('stringField') ) {
							    thisTbar.remove('value_id');
							    thisTbar.insert(2,{
								    xtype: 'stringField'
							    });
							}
						}
					};
				}
			}        
		},{
			xtype: 'stringOper'
		},{
			xtype: 'stringField'
		},{
			xtype: 'button',
			itemId: 'find_id',
            iconCls: 'tbar-find',
            hidden: true,
			text:  $$('Find'),
			listeners: {
				click: doSearch
			}            
		},{ xtype: 'tbspacer' },{
			xtype: 'button',
			itemId: 'save_id',
            iconCls: 'tbar-save',
            hidden: true,
			text:  $$('Save'),
			listeners: {
				click: saveQuery
			}
		},{
			xtype : 'tbfill'
		},{
			xtype: 'button',
			margin: '2 0 2 0',
			iconCls: 'btn-add',
			handler: function() {
				panel_tree.addDocked({xtype: 'SearchToolbar'});
				// show button only on last dock
				panel_tree.showButtonOnlyLastDocked();
			}            
		},{
			xtype: 'button',
			margin: '2 0 2 0',
			iconCls: 'btn-rem',
			handler: function(aa,bb,cc,dd) {
				// if last search toobar is removed 
				if ( panel_tree.getDockedItems('SearchToolbar').length == 1 ) {
					searchOrBrowse('store_load');
				} else {
					panel_tree.removeDocked(this.up('SearchToolbar'));
					// show button only on last dock
					panel_tree.showButtonOnlyLastDocked();
				}
			}
		}]
	});

	//  Grid Panel Grid Panel Grid Panel Grid Panel Grid Panel Grid Panel Grid Panel Grid Panel  
	// to place the load mask in the whole panel
    Ext.define(null, {
        override: 'Ext.view.Table',
        getMaskTarget: function() {
            var ownerCt = this.ownerCt;
            return ownerCt[ownerCt.maskElement];
        }
    });
	panel_tree = Ext.create('Ext.grid.Panel', {
		stateId: 'treePanel_id_' + dbusage,
		stateful: true,
		store: store_tree,
		border: false,
		padding: '0 0 0 0',
		multiSelect: true,
		enableColumnHide:false,
		bufferedRenderer: false,
		myEvent: '',
		myIndex: '',
		maskElement: 'el',
		listeners: {
			select: {
				fn: function(view, record, item, index){
				    /*remove this check because in ExtJS5.1 it is not necessary 
					//if ( this.myEvent == 'itemdblclick' ) {
					//	this.myEvent = 'select';
					//	return false;
					}*/
					if ( treeType == 'AsxTree' ) {
						if ( record.data.type == 'File' ) {
							store_preview.proxy.extraParams.node = record.data.id;
							store_preview.load();
						};
						panel_meta.myElementurl = record.data.id;
						if ( !viewportInfo.getCollapsed() ) {
							panel_meta.myLoad();
						};
					}
					var thisTbar = Ext.getCmp('pathToolbar_id');
                    Ext.Ajax.request({
                        url: browser_index,
                        method: 'GET',
                        params: { 
                            caller: 'ajaxElementPath',
                            node: record.data.id
                        },
                        scope: this,
                        failure: function(){
                            extAlert(1,'Could not connect to server');
                        }, 
                        success: function(result, request) {
                            var json = Ext.decode(result.responseText);
                            if (thisTbar) {
                                thisTbar.remove('path_id');
                                thisTbar.insert(0,{
                                    xtype: 'pathButton',
                                    text: json.path,
                                    value: record.data.id
                                });
                            }
                        }
                    });
				},
				delay: 100
			},
			itemdblclick: function(view, record, item, index, e){
				//this.myEvent = 'itemdblclick';
				this.myIndex = index;
				if ( record.data.type == 'Directory' || ( record.data.type == 'Link' && store_tree.currentDir == '__CYCLES' )) {
					if ( workmodus.value == 'search' ) {
						store_tree.currentUrl = record.data.id;
						searchOrBrowse();
						store_tree.removeAll();
						store_tree.proxy.extraParams = {
								caller: 'changeDir',
								procedure: 'setVtime',
								node: record.data.id
						};
						store_tree.load();
					} else {
						// for paging set back to first page
						store_tree.currentPage = 1;
						store_tree.removeAll();
						store_tree.proxy.extraParams = {
								caller: 'changeDir',
                                procedure: '',
								node: record.data.id
						};
						store_tree.load();
					}
				} else if ( treeType == 'AsxTree' || treeType == 'BsxTree' ) {
					openUserapp(record.data.type,record.data.id);
				}
			},
			itemcontextmenu: function(view, rec, node, index, e) {
				e.stopEvent();
				if (menuContext.items && menuContext.items.length > 0) menuContext.showAt(e.getXY());
				return false;
			},
			containercontextmenu: function(view, e, opt) {
				e.stopEvent();
				if (menuContext.items && menuContext.items.length > 0) menuContext.showAt(e.getXY());
				return false;
			},
			render: function(view, rec, node, index, e) {
                if ( pageSize > 0 ) {
                    if ( panel_tree.getDockedItems('PagingToolbar').length == 0 ) {
                        panel_tree.addDocked({xtype: 'PagingToolbar', id: 'pagingToolbar_id'});
                    }
                } else {
                    Ext.each(panel_tree.getDockedItems('PagingToolbar'), function(tb) {
                        panel_tree.removeDocked(tb);
                    });
                }
                if ( panel_tree.getDockedItems('PathToolbar').length == 0 ) {                        
                        panel_tree.addDocked({xtype: 'PathToolbar', id: 'pathToolbar_id'});
                }
			}
		},
		columns: cols_attr,
		myReset: function () {
			if (this.myIndex != "") {
				this.store.load({
					scope:this,
					callback:function(records, operation, success){
						this.getSelectionModel().select(this.myIndex);
					}
				});
			};
		},
		showButtonOnlyLastDocked: function () {
			var me = this;
			// for SearchToolbar show only for the last toolbar the find button
			var ary = me.getDockedItems('SearchToolbar');
			if (ary && ary.length > 0) {
				var i = 0;
				for(var y in ary) {
					if (ary[y].getComponent('find_id').isVisible() ) {
						ary[y].getComponent('find_id').setVisible(false);
						ary[y].getComponent('save_id').setVisible(false);
					}
					i = y;
				}
				ary[i].getComponent('find_id').setVisible(true);
				ary[i].getComponent('save_id').setVisible(true);
			}
		}
	});

	if ( treeType == 'AsxTree' || treeType == 'BsxTree' ) {
	    var allBars = [menuBar, crumBar, fixButtonBar]
	} else {
	    var allBars = [crumBar, fixButtonBar]
	}

	window_tree = Ext.create('Ext.panel.Panel', {
		layout: 'border',
		padding: '0',
		border: false,
		items: windowPanel,
		dockedItems: allBars
	});       

	Ext.getCmp('centercenter').add(window_tree);
	Ext.getCmp('centertree').add(panel_tree);

	workmodus =  Ext.getCmp('searchButton');

    // create the snapshot toolbar
    store_snapshot = Ext.create('Ext.data.JsonStore', {
        fields: ['vtime','vtimetext'],
        proxy: {
            type: 'memory',
            reader: {
                type: 'json',
                rootProperty: 'runtime'				    

            }
        },
        listeners: {
            datachanged: function(store,records,success,operation,opts) {
                vtimeMenu.removeAll();
                for(var i=0;i<store.getTotalCount();i++){
                    var vtime     = store.getAt(i).data['vtime'];
                    var vtimetext = store.getAt(i).data['vtimetext'];
                    if ( store_tree.currentVtime == vtime) {
                        vtimeMenu.up().setText(vtimetext);
                        var iconCls ='check-okay';
                    } else {
                        var iconCls ='undefined';
                    }
                    vtimeMenu.add([{
                        text: vtimetext,
                        itemId: vtime,
                        iconCls: iconCls
                    }]);
                };
                vtimeMenu.add([{
                    text: $$('more options')+' ...',
                    itemId: 'listvtime',
                    handler: function(obj) {
                        indexoptionWindow();                
                    }
                }]);
            }
        }
    });

	if ( treeType == 'AsxTree' ) {
		viewportGallery =  Ext.getCmp('southgallery');
		viewportInfo    =  Ext.getCmp('centereast');
		viewportPreview =  Ext.getCmp('southpreview');
		viewportMeta    =  Ext.getCmp('centerinfo');

		// Gallery view ******************************************************************

		store_gallery = Ext.create('Ext.data.JsonStore', {
			model: 'm_gallery',
			proxy: {
				type: 'memory',
				reader: {
				    type: 'json',
				    rootProperty: 'images'				    
				}
			}
		});

		var tpl = new Ext.XTemplate(
				'<tpl for=".">',
				    '<div class="thumb-wrap">',
				        '<tpl if="media == \'image\'">',
				            '<span style="width: {pvsize}px;">{name}</span>',
				            '<div class="thumb" style="width: {pvsize}px; height: {pvsize}px; line-height: {pvsize}px;">',
				                '<img src="{clippath}" style="width: {xsize}px; height: {ysize}px" title="{name}">',
				            '</div>',
				        '<tpl else>',
				            '<tpl if="iconpath != \'\'">',		
    				            '<span style="width: {pvsize}px;">{name}</span>',
	    			            '<div class="thumb" style="width: {pvsize}px; height: {pvsize}px; line-height: {pvsize}px;">',
		    		                '<img src="{iconpath}" style="width: {xsize}px; height: {ysize}px" title="{name}">',
			    	            '</div>',
                            '<tpl else>',
				                '<span style="width: {pvsize}px;">{name}</span>',
				                '<div class="thumb" style="width: {pvsize}px; height: {pvsize}px; line-height: {pvsize}px;">',
				                    '<img src="/lexxapp/img4/file-video.png" style="width: 64px; height: 64px" title="{name}">',
				                '</div>',
    				        '</tpl>',			            
				        '</tpl>',
				    '</div>',
				'</tpl>',
				'<div class="x-clear"></div>'
		);

		var viewGallery = Ext.create('Ext.view.View', {
			store: store_gallery,
			tpl: tpl,
			width: '100%',
			height: '100%',
			multiSelect: false,
			trackOver: true,
			overItemCls: 'x-item-over',
			itemSelector: 'div.thumb-wrap',
			listeners: {
				itemdblclick: function(view, record, item, index, event) {
					panel_tree.myIndex = index;
					openUserapp(record.data.type,record.data.id);
					return false;
				},
				select: function(view, record, opt) {
					var iy = this.getSelectionModel().getSelection()[0];
					var row = panel_tree.store.indexOf(iy);
					panel_tree.getSelectionModel().select(row);
					panel_tree.getView().focusRow(row);
				},
				beforerefresh: function(me, eOpts) {
					if (store_gallery.getCount() > 0 ) {
						var pvsize = store_gallery.getAt(0).data['pvsize'];
						sliderPreview.setValue(pvsize);
					}
				}
			}
		});

		Ext.define('Tree.Toolbar.SliderBar', {
			extend: 'Ext.toolbar.Toolbar',
			xtype: 'SliderToolbar',
			dock: 'bottom',
			height: 30,
            border: '0 1 0 1',
			padding: '0 0 0 0'
		});

		sliderPreview= Ext.create('Ext.slider.Single', {
			hideLabel: true,
			width: 100,
			increment: 32,
			minValue: 68,
			maxValue: 260,
			tipText: function(thumb){
				var pvsize = thumb.value - 4;
				return Ext.String.format('{0} x {0}', pvsize);
			},
			listeners: {
				changecomplete: function(slider, newValue, thumb, eOpts) {
    				Ext.getBody().mask($$('Changing preview size ...'), 'loading')
					Ext.Ajax.request({
						url: browser_index,
						method: 'POST',
						params: { 
							caller: 'ajaxSetPreviewSize',
							previewSize: newValue
						},
						scope: this,
						failure: function(){
							Ext.getBody().unmask();
							extAlert(1,'Could not connect to server')
						}, 
						success:function(response, options) {
							var XMLdata = response.responseXML;
							Ext.getBody().unmask();
							showMessage(XMLdata);
							store_tree.load();
						}
					});
				}
			}
		});

		var panelGallery = Ext.create('Ext.Panel', {
			id: 'images-view',
			padding: '0 0 0 0',
			border: false,
			autoScroll: true,
			items: viewGallery,
			dockedItems: [{
				xtype: 'SliderToolbar',
				items: [{
					xtype: 'tbtext',
					text: $$('Preview size')+':'            
				}, sliderPreview]
			}]
		});

		viewportGallery.add(panelGallery);

		// Preview ******************************************************************

		store_preview = Ext.create('Ext.data.JsonStore', {
			model: 'm_gallery',
			proxy: {
				type: 'ajax',
				url: browser_index,
				actionMethods: 'POST',
				extraParams: {
					caller: 'ajaxPreview',
					node: rootUrl,
					isXml: true
				},
				reader: {
					type: 'json',
				    rootProperty: 'image'
				},
				afterRequest: testSession
			}
		});

		store_preview.load();

		var tpl = new Ext.XTemplate(
            '<tpl for=".">',
            '<div class="thumb-wrap">',
                '<tpl if="media == \'image\'">',
                    '<span style="width: {pvsize}px;">{name}</span>',
                        '<div class="thumb">',
                        '<img src="{clippath}" style="width: {xsize}px; title="{name}">',
                    '</div>',
                '<tpl else>',
                    '<tpl if="container == \'.mp4\'">',		
                        '<span style="width: {pvsize}px;">{name}</span>',
                        '<div class="thumb">',
                            '<video style="display:block; margin: 0 auto;" width=320 controls autoplay>',
                                '<source src="{clippath}" type="video/mp4"></source>',
                            '</video>',
                        '</div>',
                    '<tpl else>',
                        '<span style="width: {pvsize}px;">{name}</span>',
                        '<div class="thumb">',
                            '<object classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" style="width: {xsize}px; height: {ysize}px" codebase="http://www.apple.com/qtactivex/qtplugin.cab">',
                                '<param name="src" value="{clippath}"/>',
                                '<param name="autoplay" value="true"/>',
                                '<param name="controller" value="true"/>',
                                '<param name="loop" value="false"/>',
                                '<param name="scale" value="aspect"/>',
                                '<embed src="{clippath}" style="width: {xsize}px; height: {ysize}px" scale="aspect" autoplay="true" controller="true" loop="false" pluginspage="http://www.apple.com/quicktime/"/>',
                            '</object>',
                        '</div>',
                     '</tpl>',               
                '</tpl>',
            '</div>',
            '</tpl>',
            '<div class="x-clear"></div>'
		);

		var p_view = Ext.create('Ext.view.View', {
			store: store_preview,
			tpl: tpl,
			width: '100%',
			height: '100%',
			multiSelect: true,
			trackOver: true,
			overItemCls: 'x-item-over',
			itemSelector: 'div.thumb-wrap',
			listeners: {
				itemdblclick: function(view, record, item, index, event) {
					openUserapp(record.data.type,record.data.id);
					return false;
				}
			}			
		});
		var panelPreview = new Ext.Panel({
			id: 'images-preview',
			padding: '0 0 0 0',
			border: false,
			autoScroll: true,
			items: p_view
		});

		viewportPreview.add(panelPreview);

		// Meta data ******************************************************************

		// stores for meta data form

		var store_metafields = Ext.create('Ext.data.Store', {
			fields: ['id', 'text', 'type', 'itype', 'ilist', 'irows'],
			data: xmldata,
			proxy: {
				type: 'memory',
				reader: {
					type: 'xml',
					record: 'metafield'
				}
			}
		});
	
		var form_items  = [];
		var form_fields = [];
		store_metafields.each(function(rec){
			var form_item  = {};
			if ( rec.get('itype') == 'dropdown' ) {
				form_item['xtype'] = 'combo';
				form_item['store'] = Ext.decode(rec.get('ilist'));
			} else {
				if ( rec.get('irows') > 1 ) {
					form_item['xtype'] = 'textareafield';
					form_item['rows'] = rec.get('irows');
				} else {
					form_item['xtype'] = 'textfield';
				}
			}
			form_item['fieldLabel'] = rec.get('text');
			form_item['name'] = rec.get('id');
 			// add to item array
			form_items.push(form_item);
    		form_fields.push(rec.get('id'));
    	});

		// general form fields
		Ext.define('m_metadataform', {
			extend: 'Ext.data.Model',
			fields: form_fields
		});

		Ext.define('m_metadataform_error', {
			extend: 'Ext.data.Model',
			fields: ['id', 'msg']
		});

		panel_meta = Ext.create('Ext.form.Panel', {
			//frame: true,
			waitMsgTarget:true,
			bodyStyle:'padding:5px 5px 0;border-width: 0px 0px 0px 0px;',
    		layout: 'anchor',
			reader: Ext.create('Ext.data.reader.Xml', {
				model: 'm_metadataform',
				root: 'metadata',
				record : 'node',
				successProperty: '@success'
			}),
			errorReader: Ext.create('Ext.data.reader.Xml', {
				model: 'm_metadataform_error',
				record : 'field',
				successProperty: '@success'
			}),
			myElementurl: '',
    		myLoad: function () {
    			var me = this;
    			if (me.myElementurl == "") return
    			me.getForm().reset();
				me.getForm().load({
					url: browser_index,
					waitMsg:'Loading...',
					params: {
						caller: 'ajaxGetMetadata',
						node: me.myElementurl
					},
					success:function(form, loadobj) {
						showMessage(loadobj.response.responseXML);
					}
				});
    		},
    		myReset: function () {
    			if (this.myElementurl != "") {
    				this.myLoad(this.myElementurl);
    			};
    		},
    		myRemoveall: function () {
				this.getForm().reset();
    		},
     		defaults: {
        		anchor: '100%',
        		//labelWidth: 80,
				labelAlign: 'right',
				fieldStyle: 'font-size:11px;',
				labelStyle: 'font-size:11px;'
    		},
	       	items: form_items,
			buttons: [{
				text: $$('Apply'),
                itemId: 'editmetadata_id',
                hidden: true,
				formBind: true,
				handler: function(btn){
					popupHide()
					getSelctedIndexItems()
					if ( numberElements == 0 ) {
						alert(document.msgForm.jsmsg1.value)
						return 0
					}
					if ( numberElements > 1 ) {
						if ( !confirm(document.msgForm.jsmsg34.value) ) return 0
					}
					this.up('form').getForm().submit({
						url: browser_index,
						waitMsg: $$('Saving')+' ...',
						params: {
							caller: 'ajaxSetMetadata',
							selectedelements: Ext.encode(selectedelements)
						},
						success:function(form, loadobj) {
							showMessage(loadobj.response.responseXML);
						}
					});
				}
			}]
		});
		
		viewportMeta.add(panel_meta);

	}
	// show/hide metadata apply button
    if ( treeType == 'AsxTree' ) {
        var applybtn = Ext.ComponentQuery.query('#editmetadata_id')[0];
		applybtn.setHidden(!idxMetaEdit);
    }

	// show selection window if selection has items
	if ( hasSelection == 1 ) selectionWindow();

	Ext.Ajax.on('requestexception', function (conn,res,opt) {
		if (res.timedout) {
			extAlert(1,'Query timeout expired');
		} else {
			extAlert(1,'Could not connect to server');
		}
	});

}


function doBreadCrumBar(JSONdata) {
	var breadcrumbStore = Ext.create('Ext.data.JsonStore', {
		model: 'breadcrumbs',
		data: JSONdata,
		proxy: {
			type: 'memory',
			reader: {
				type: 'json',
				rootProperty: 'pathList'
			}
		},
		//autoLoad: true,
		listeners: {
			load: function(store,records,success,operation,opts) {
				crumBar.removeAll();
				var count = store.getTotalCount();
				// back button
				if ( count > 1) {
					crumBar.add([{
						pAddr: store.getAt(count-2).data['pAddr'],
						iconAlign: 'right',
						iconCls: 'bcrum_back_a',
						handler: function(obj) {
							// for paging set back to first page
							store_tree.currentPage = 1;
							store_tree.proxy.extraParams = {
									caller: 'changeDir',
                                    procedure: '',
									node: obj.pAddr
							};
							store_tree.load();
						}
					}]);
				} else {
					crumBar.add([{
						disabled: true,
						iconAlign: 'right',
						iconCls: 'bcrum_back_d'
					}]);
				}
				for(var i=0;i<count;i++){
					crumBar.add([{
						cls: 'bcrum-bar',
						text: store.getAt(i).data['pName'],
						pAddr: store.getAt(i).data['pAddr'],
						iconAlign: 'right',
						iconCls: 'bcrum',
						handler: function(obj) {
							// for paging set back to first page
							store_tree.currentPage = 1;
							store_tree.proxy.extraParams = {
									caller: 'changeDir',
                                    procedure: '',
									node: obj.pAddr
							};
							store_tree.load();
						}
					}]);
				};
			}
		}
	});
	breadcrumbStore.load();
}
// try to fetch values for page status and message
function showMessage(XMLdata) {
	var attention = DQ.selectValue('attention', XMLdata);
	var message   = DQ.selectValue('message', XMLdata);
	if (typeof attention == 'undefined') {
		extAlert(1,$$('Server communication error. (Invalid XML message)'));
	} else if (attention > 0 ) {
		extAlert(attention,message);
	}
}
function showJsonMessage(JSONdata) {
	var attention = JSONdata.control.attention;
	var message   = JSONdata.control.message;
	if (typeof attention == 'undefined') {
		extAlert(1,$$('Server communication error. (Invalid XML message)'));
	} else if (attention > 0 ) {
		extAlert(attention,message);
	}
}
//archive, restore, sync selection window
function selectionWindow() {
	var reswin = Ext.getCmp('selection_id');
	if(!reswin) {
		if ( dboper == 'Archive' ) {
			var reswin = Ext.create('Ext.window.Window', {
				id: 'selection_id',
				title: $$('Archive Selection'),
				height: '70%',
				width: 200,
				layout: 'fit',
				closeAction: 'hide',
				renderTo: 'centercenter',
				constrain: true,
				listeners: {
					beforeshow: function(win) {
						var sr = win.getComponent('selectiongrid_id').getStore();
						sr.load({
							params: {
								caller: 'ajaxSelection',
								procedure: 'listing'
							}
						});
					}
				},
				items: {
					xtype: 'selectiongrid',
					itemId: 'selectiongrid_id'
				},
				dockedItems: [{
					xtype: 'toolbar',
					dock: 'bottom',
					padding: '0 0 0 0',  
					defaults: {
						xtype : 'button'
					},
					items: [{
						iconCls: 'btn_rem',
						handler: function() {
							var win  = this.up().up();
							var grid = win.getComponent('selectiongrid_id');
							outBasket(grid);
						}
					},{           
						iconCls: 'btn_add',
						handler: function() {
							inBasket();
						}
					},{ xtype : 'tbfill' },{           
						text: $$('Archive'),
						handler: function() {
							doSelection(treeType,'selection_archive');
						}
					}]
				}]
			});
		} else if ( dboper == 'Synchronize' ) {
			var reswin = Ext.create('Ext.window.Window', {
				id: 'selection_id',
				title: $$('Sync Selection'),
				height: '70%',
				width: 200,
				layout: 'fit',
				closeAction: 'hide',
				renderTo: 'centercenter',
				constrain: true,
				listeners: {
					beforeshow: function(win) {
						var sr = win.getComponent('selectiongrid_id').getStore();
						sr.load({
							params: {
								caller: 'ajaxSelection',
								procedure: 'listing'
							}
						});
					}
				},
				items: {
					xtype: 'selectiongrid',
					itemId: 'selectiongrid_id'
				},
				dockedItems: [{
					xtype: 'toolbar',
					dock: 'bottom',
					padding: '0 0 0 0',  
					defaults: {
						xtype : 'button'
					},
					items: [{
						iconCls: 'btn_rem',
						handler: function() {
							var win  = this.up().up();
							var grid = win.getComponent('selectiongrid_id');
							outBasket(grid);
						}
					},{           
						iconCls: 'btn_add',
						handler: function() {
							inBasket();
						}
					},{ xtype : 'tbfill' },{           
						text: $$('Sync'),
						handler: function() {
							prepareCopyBySync('selection_copy');
						}
					}]
				}]
			});
		} else {
			var reswin = Ext.create('Ext.window.Window', {
				id: 'selection_id',
				title: $$('Restore Selection'),
				height: '70%',
				width: 200,
				layout: 'fit',
				closeAction: 'hide',
				renderTo: 'centercenter',
				constrain: true,
				listeners: {
					beforeshow: function(win) {
						var sr = win.getComponent('selectiongrid_id').getStore();
						sr.load({
							params: {
								caller: 'ajaxSelection',
								procedure: 'listing'
							}
						});
					}
				},
				items: {
					xtype: 'selectiongrid',
					itemId: 'selectiongrid_id'
				},
				dockedItems: [{
					xtype: 'toolbar',
					dock: 'bottom',
					padding: '0 0 0 0',  
					defaults: {
						xtype : 'button'
					},
					items: [{
						iconCls: 'btn_rem',
						handler: function() {
							var win  = this.up().up();
							var grid = win.getComponent('selectiongrid_id');
							outBasket(grid);
						}
					},{           
						iconCls: 'btn_add',
						handler: function() {
							inBasket();
						}
					},{ xtype : 'tbfill' },{           
						text: $$('Restore To'),
						handler: function() {
							doSelection(treeType,'selection_restore');
						}
					}]
				}]
			});
		}
		Ext.getCmp('centercenter').add(reswin);
		//reswin.alignTo('centercenter', "r-r", [-30, 0]);
	}
	reswin.show();
}            
//view options window
function viewoptionWindow() {
	var reswin = Ext.getCmp('viewoptionpanel_id')
	console.log('viewoptionWindow');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'viewoptionpanel_id',
			title: $$('View'),
			width:300,
			height:400,
			layout:'fit',
			resizable: false,
			border: false,
			closeAction: 'destroy',
			renderTo: 'centercenter',
			constrain: true,
			listeners: {
				beforeshow: function(win) {
					form = win.down('form');
					// load first form and second load grid store for "show columne"
					form.getForm().load({
						url: browser_index,
						waitMsg:'Loading...',
						params: {
							caller: 'ajaxViewoptions'
						},
						success:function(form, loadobj) {
							store_viewoptionscolgrid.loadRawData(loadobj.response.responseXML);
						}
					});
				}
			},
			items: Ext.create('Ext.form.Panel', {
				frame: true,
				waitMsgTarget:true,
				//bodyStyle:'padding:5px 5px 0',
				layout:'auto',
				reader: Ext.create('Ext.data.reader.Xml', {
					model: 'm_viewoptionsform',
					record : 'viewoptions',
					successProperty: '@success'
				}),
				// configure how to read the XML errors
				errorReader: Ext.create('Ext.data.reader.Xml', {
					model: 'm_viewoptionsform_error',
					record : 'field',
					successProperty: '@success'
				}),
				items: viewOptionsDef,
				buttons: [{
					text: $$('Cancel'),
					handler: function(btn){
						var win = btn.up('window');
						win.close();
					}
				}, {
					text: $$('Apply & Reload'),
					formBind: true,
					handler: function(btn){
						var win  = this.up().up();
						var grid = win.getComponent('viewoptionscolgrid_id');
						var selectedsystem = new Array();
						var selecteduser   = new Array();
						var shoSysCols;
						var shoUsrCols;
						grid.getStore().each(function(record){
							if (record.get('active')) {
								var row = record.get('id');
								if (record.get('type') == 'system') {
									selectedsystem.push(row);
								} else {
									selecteduser.push(row);
								}
							}
						});
						if ( selectedsystem.length ) {
						    shoSysCols = JSON.stringify(selectedsystem)
						}
						if ( selecteduser.length ) {
						    shoUsrCols = JSON.stringify(selecteduser)
						}
						this.up('form').getForm().submit({
							url: browser_index,
							submitEmptyText: false,
							waitMsg: $$('Saving')+' ...',
							params: {
								caller: 'ajaxViewoptions',
								procedure: 'cachePage',
								shoSysCols: shoSysCols,
								shoUsrCols: shoUsrCols
							},
							success: function(form) {
								var win = btn.up('window');
								win.close();
								pageReload();
							}
						});
					}
				}]		
			})
		});
		Ext.getCmp('centercenter').add(reswin);
		//reswin.alignTo('centercenter', "r-r", [-50, -50]);
	}
	reswin.show();
}
//index option window            
function indexoptionWindow(refresh) {
	if ( workmodus.value == 'search' ) searchOrBrowse('store_load');
	var reswin = Ext.getCmp('indexoptionpanel_id');
	if(!reswin) {
		var reswin = Ext.create('Ext.window.Window', {
			id: 'indexoptionpanel_id',
			title: $$('Index Options'),
			width:550,
			height:500,
			resizable: false,
			border: false,
			closeAction: 'hide',
			renderTo: 'centercenter',
			constrain: true,
			listeners: {
				beforeshow: function(win) {
                    store_indexoptionspoolgrid.load();
				}
			},
			items: indexOptionsTabs
		});
		Ext.getCmp('centercenter').add(reswin);
		//reswin.alignTo('centercenter', "r-r", [-50, -50]);
	} else if (refresh) {
		reswin.close();
	}
	reswin.show();
}
// warning about changes
function modifyIndex(redirect) {
    if ( workmodus.value == 'browse' ) {
        // check if element is type folder
        if ( redirect.prototype.constructor.name != 'indexElementNew' ) {
            var elm = getSingelIndexElement(panel_tree);
            if (!elm) return;
        }
        var txt1 = $$('Please make sure no archive jobs are running.');
        var txt2 = $$('Index modification and simultaneously running archive jobs can influence each other. Therefore, make sure that during the manual changes no archive jobs are running.');
        var txt3 = txt1 +'<br><br>'+ txt2
        Ext.MessageBox.show({
            title: $$('Important Note'),
            width: 400,
            msg: txt3,
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.WARNING,
            fn: function(buttonId) {
                if (buttonId === "ok") {
                    redirect();
                }
            }
        });
    } else {
        extAlert(2,$$('In search mode index modification are not possible'))
    }
}
//index modification rename
function indexElementRename() {
    var elm = getSingelIndexElement(panel_tree);
    if (!elm) return;
	var reswin = Ext.getCmp('elementRenamePanel_id')
	if(!reswin) {
		var reswin = Ext.create('Tree.ElementRename.Window', {
			id: 'elementRenamePanel_id',
            items: [{
                margin: '10 10 10 10',
                xtype: 'component',
                html: $$('Are you sure you want to rename this index element?')
            },{
                margin: '5 10 10 10',
                xtype: 'textfield',
                name: 'elementName',
                fieldLabel: $$('New name'),
                labelAlign: 'right'
            },{
                margin: '5 10 10 10',
                xtype: 'component',
                html: $$('Note') + ': ' + $$('Renaming an index element may take a few moments.')
            }],
            buttons: [{
                text: $$('Cancel'),
                handler: function(btn) {
                    var win = btn.up('window');
                    win.close();
                }
            },{
                text: $$('Rename'),
                handler: function(btn) {
                    var win = btn.up('window');
                    var winField  = win.down('textfield[name=elementName]');
                    var newName   = winField.getValue();
                    var oldName   = win.getNodename();
		            Ext.Msg.confirm($$('Rename'), $$('Do you really want to rename:')  + '<div style="margin:5px;"><i>' + oldName + '</i></div>' + $$('to:') + '<div style="margin:5px;"><i>' + newName + '</i></div>', function(btn, name){
			            if (btn == 'yes') {
                            win.setLoading($$('Renaming')+' ...');
                            Ext.Ajax.request({
                                url: browser_index,
 			                    timeout: 360000,
                                method: 'POST',
                                params: { 
                                    caller: 'ajaxRenameElement',
                                    node: win.getSelected(),
                                    trgtnode: newName,
                                    vtime: store_tree.currentVtime
                                },
                                scope: this,
                                failure: function(){
                                    win.setLoading(false);
                                    win.close();
                                    extAlert(1,'Could not connect to server');
                                },
                                success:function(response, options) {
                                    win.setLoading(false);
                                    win.close();
                                    var XMLdata = response.responseXML;
                                    showMessage(XMLdata);
                                    var vtime = DQ.selectValue('returnvalues > vtime', XMLdata);
                                    //reload tree with new snapshot time
                                    store_tree.load({
                                        params: {
                                            caller: 'setSnapshot',
                                            procedure: '',
                                            node: store_tree.currentUrl,
                                            vtime: vtime
                                        }
                                    });
                                }
                            });
                         }
                    });
                }
            }]
        });
		Ext.getCmp('centercenter').add(reswin);
		reswin.center('centercenter');
	}
	reswin.setTitle($$('Rename') + ': ' + elm['name']);
	var winField = reswin.down('textfield[name=elementName]');
    winField.setValue(elm['name']);
	reswin.setSelected(elm['id']);
	reswin.setNodename(elm['name']);
	reswin.show();
}
//index modification delete
function indexElementDelete() {
    var elm = getSingelIndexElement(panel_tree);
    if (!elm) return;
	var reswin = Ext.getCmp('elementDeletePanel_id')
	if(!reswin) {
		var reswin = Ext.create('Tree.ElementDelete.Window', {
			id: 'elementDeletePanel_id',
            items: [{
                margin: '10 10 5 10',
                xtype: 'component',
                html: $$('Are your sure you want to delete this index element?')
            },{
                margin: '5 10 60 10',
                xtype: 'component',
                html: $$('Note') + ': ' + $$('Deleting an index element may take a few moments.')
            }],
            buttons: [{
                text: $$('Cancel'),
                handler: function(btn) {
                    var win = btn.up('window');
                    win.close();
                }
            },{
                text: $$('Delete'),
                handler: function(btn) {
                    var win = btn.up('window');
                    win.setLoading($$('Deleting')+' ...');
                    Ext.Ajax.request({
                        url: browser_index,
 			            timeout: 180000,
                        method: 'POST',
                        params: { 
                            caller: 'ajaxDeleteElement',
                            node: win.getSelected(),
                            vtime: store_tree.currentVtime
                        },
                        scope: this,
                        failure: function(){
                            win.setLoading(false);
                            win.close();
                            extAlert(1,'Could not connect to server');
                        },
                        success:function(response, options) {
                            win.setLoading(false);
                            win.close();
                            var XMLdata = response.responseXML;
                            showMessage(XMLdata);
                            var vtime = DQ.selectValue('returnvalues > vtime', XMLdata);
                            //reload tree with new snapshot time
                            store_tree.load({
                                params: {
                                    caller: 'setSnapshot',
                                    procedure: '',
                                    node: store_tree.currentUrl,
                                    vtime: vtime
                                }
                            });
                        }
                    });
                }
            }]
        });
		Ext.getCmp('centercenter').add(reswin);
		reswin.center('centercenter');
	}
	reswin.setTitle($$('Delete') + ': ' + elm['name']);
	reswin.setSelected(elm['id']);
	reswin.setNodename(elm['name']);
	reswin.show();
}
//index modification delete
function indexElementNew() {
    Ext.Msg.prompt($$('Name of new folder'), '', function(btn, foldername){
        if (btn == 'ok') {
            Ext.Ajax.request({
                url: browser_index,
                timeout: 180000,
                method: 'POST',
                params: { 
                    caller: 'ajaxNewFolder',
                    node: store_tree.currentUrl,
                    folder: foldername,
                    vtime: store_tree.currentVtime
                },
                scope: this,
                failure: function(){
                    extAlert(1,'Could not connect to server')
                }, 
                success:function(response, options) {
                    var XMLdata = response.responseXML;
                    showMessage(XMLdata);
                    var vtime = DQ.selectValue('returnvalues > vtime', XMLdata);
                    //reload tree with new snapshot time
                    store_tree.load({
                        params: {
                            caller: 'setSnapshot',
                            procedure: '',
                            node: store_tree.currentUrl,
                            vtime: vtime
                        }
                    });
                }
            });
        };
    });
}
//index modification move
function indexElementMove() {
    var elm   = getSingelIndexElement(panel_tree)
    if (!elm) return;
	var reswin = Ext.getCmp('elementMovePanel_id')
	if(!reswin) {
		var reswin = Ext.create('Tree.elementMove.Window', {
			id: 'elementMovePanel_id',
            items: [{
                margin: '10 10 0 10',
                xtype: 'component',
                html: $$('Please select the target folder')+':'
            },{
                margin: '10 10 0 10',
                xtype: 'filepickertree',
                itemId: 'filepickertree_id',
                flex: 1
            },{
                margin: '10 10 10 10',
                xtype: 'component',
                html: $$('Note') + ': ' + $$('Moving an index element may take a few moments.')
            }],
            buttons: [{
                xtype: 'button',
                text: $$('New Folder ...'),
                handler: function() {
                    var panel_tree   = Ext.ComponentQuery.query('#filepickertree_id')[0];
                    if (panel_tree.getSelectionModel().hasSelection()) {
                        Ext.Msg.prompt($$('Name of new folder'), '', function(btn, foldername){
                            if (btn == 'ok') {
                                var tree_store   = panel_tree.getStore();
                                var selectedNode = panel_tree.getSelectionModel().getSelection();
                                var nodeobj      = selectedNode[0];
                                var elementurl   = selectedNode[0].data.id
                                Ext.Ajax.request({
                                    url: browser_index,
                                    timeout: 180000,
                                    method: 'POST',
                                    params: { 
                                        caller: 'ajaxNewFolder',
                                        node: elementurl,
                                        folder: foldername,
                                        vtime: store_tree.currentVtime
                                    },
                                    scope: this,
                                    failure: function(){
                                        extAlert(1,'Could not connect to server')
                                    }, 
                                    success:function(response, options) {
                                        var XMLdata = response.responseXML;
                                        // try to fetch values for page status and message
                                        var attention = DQ.selectValue('attention', XMLdata);
                                        var message   = DQ.selectValue('message', XMLdata);
                                        var newnode   = DQ.selectValue('newnode', XMLdata);
                                        var vtime     = DQ.selectValue('vtime', XMLdata);
                                        if (typeof attention == 'undefined') {
                                            extAlert(1,$$('Server communication error. (Invalid XML message)'))
                                        } else if (attention > 0 ) {
                                            extAlert(attention,message)
                                        }
                                        if (attention == 0 ) {
                                            //reload tree with new snapshot time
                                            store_tree.load({
                                                params: {
                                                    caller: 'setSnapshot',
                                                    procedure: '',
                                                    node: store_tree.currentUrl,
                                                    vtime: vtime
                                                }
                                            });
                                            //reload the node with the new created folder
                                            nodeobj.removeAll();
                                            tree_store.load({ 
                                                node: nodeobj,
                                                callback : function(records, operation, success){
                                                    var rootNode  = panel_tree.getRootNode();
                                                    var newObj    = rootNode.findChild('id',newnode, true);
                                                    newObj.parentNode.expand();
                                                    panel_tree.getSelectionModel().select(newObj);
                                                }
                                            });
                                        };
                                    }
                                });
                            };
                        });
                    } else {
                        extAlert(2,'Please select the parent folder')
                    }
                }
            },{ xtype: 'tbfill' },{
                text: $$('Cancel'),
                handler: function(btn) {
                    var win = btn.up('window');
                    win.close();
                }
            },{
                itemId: 'select_id',
                text: $$('Select'),
                disabled: true,
                handler: function(btn) {
                    var win = btn.up('window');
                    var winTitle = win.getTitle();
                    var winTree  = win.down('filepickertree');
                    var oldName  = win.getNodename();
                    var selNode  = winTree.getSelected();
                    var nodePath = winTree.getPath();
		            Ext.Msg.confirm($$('Move'), $$('Do you really want to move:')  + '<div style="margin:5px;"><i>' + oldName + '</i></div>' + $$('to:') + '<div style="margin:5px;"><i>' + nodePath + '</i></div>', function(btn, name){
			            if (btn == 'yes') {
                            win.setLoading($$('Moving')+' ...');
                            Ext.Ajax.request({
                                url: browser_index,
 			                    timeout: 360000,
                                method: 'POST',
                                params: { 
                                    caller: 'ajaxMoveElement',
                                    node: win.getSelected(),
                                    trgtnode: selNode,
                                    vtime: store_tree.currentVtime
                                },
                                scope: this,
                                failure: function(){
                                    win.setLoading(false);
                                    win.close();
                                    extAlert(1,'Could not connect to server');
                                },
                                success:function(response, options) {
                                    win.setLoading(false);
                                    win.close();
                                    var XMLdata = response.responseXML;
                                    showMessage(XMLdata);
                                    var vtime = DQ.selectValue('returnvalues > vtime', XMLdata);
                                    //reload tree with new snapshot time
                                    store_tree.load({
                                        params: {
                                            caller: 'setSnapshot',
                                            procedure: '',
                                            node: store_tree.currentUrl,
                                            vtime: vtime
                                        }
                                    });
                                }
                            });
                         }
                    });
                }
            }]
        });
		Ext.getCmp('centercenter').add(reswin);
		reswin.center('centercenter');
	}
	reswin.setTitle($$('Move') + ': ' + elm['name']);
	reswin.setSelected(elm['id']);
	reswin.setNodename(elm['name']);
	reswin.show();
}
// get singel element from tree
function getSingelIndexElement(_tree) {
    var nrel = 0;
    var elm  = [];
    var selection = _tree.getSelectionModel().getSelection();
    Ext.iterate(selection, function(obj, index) {
        elm['id']   = obj.get('id');
        elm['name'] = obj.get('name');
        elm['type'] = obj.get('type');
        nrel++
    });
    if ( nrel > 1 ) {
        alert(document.msgForm.jsmsg2.value);
        return false;
    }
    if ( nrel < 1 ) {
        alert(document.msgForm.jsmsg1.value);
        return false;
    }
    if ( elm['type'] != 'Directory' ) {
        alert(document.msgForm.jsmsg102.value);
        return false;
    }
    return elm;
}
// render icon
function renderIconIdx(value, metaData, record, rowIndex, colIndex, store, view) {
	if ( record.data.type == "Directory" ) {
		metaData.tdCls = 'idx-folder-icon';
	} else if ( record.data.icon == "Link" ) {
		metaData.tdCls = 'idx-link-icon';
	} else if ( record.data.icon == "Image" ) {
		metaData.tdCls = 'idx-image-icon';
	} else {
		metaData.tdCls = 'idx-file-icon';
	}
	return value;
}
//show search fields
function searchOrBrowse(mode) {
    // hide the two restore button in case of a search
    var btn = Ext.ComponentQuery.query('#fixButtonBar_id > button[func/="inBasket"]')[0];
    var mnu = Ext.ComponentQuery.query('#menuContext_id > menuitem[func/="inBasket"]')[0];
	if ( workmodus.value == 'browse' ) {
        if ( btn ) btn.setVisible(false);
        if ( mnu ) mnu.setVisible(false);
		panel_tree.addDocked({xtype: 'SearchToolbar'});
		// show button only on last dock
		panel_tree.showButtonOnlyLastDocked();
		store_tree.removeAll();
		crumBar.removeAll();
		// preset search path
		store_tree.searchUrl = rootUrl;
		crumBar.add([{ xtype: 'tbspacer' },{
			xtype: 'tbtext',
			text: $$('Search in')+':'            
		},{
			xtype: 'button',
            cls:'x-btn-default-small',
            border: 1,
            style: {
                borderColor: '#bbb',
                borderStyle: 'solid'
            },				
			text: $$('Entire Index'),
			value: rootUrl,
			allowDepress: false,
			toggleGroup: 'searchBtnGroup',
			enableToggle: true,
			pressed: true,
			handler: function() {
				store_tree.searchUrl = rootUrl;
			}
		}]);
		if ( rootUrl != store_tree.currentUrl ) {
			crumBar.add([{ xtype: 'tbspacer' },{
			    xtype: 'tbtext',
			        text: $$('or')+':'            
		        },{
				xtype: 'button',
                cls:'x-btn-default-small',
                border: 1,
                style: {
                    borderColor: '#bbb',
                    borderStyle: 'solid'
                },				
                text: store_tree.currentDir,
				value: store_tree.currentUrl,
				allowDepress: false,
				toggleGroup: 'searchBtnGroup',
				enableToggle: true,
				handler: function() {
					store_tree.searchUrl = store_tree.currentUrl;
                    var msg1 = "A positional search in '" +store_tree.currentDir+ "' may take a long time."
                    showToast($$('Warning'), msg1);
				}
			},{ xtype: 'tbspacer', width: 20 }]);
		};
		store_savedqueries = Ext.create('Ext.data.Store', {
			fields: ['id', 'query'],
			autoLoad: true,
			proxy: {
				type: 'ajax',
				url: browser_index,
				actionMethods: 'POST',
				extraParams: {
					caller: 'ajaxGetQuery',
				},
				reader: {
					type: 'xml',
					record: 'searchquery'
				}
			}
		});
		store_lastqueries = Ext.create('Ext.data.Store', {
			fields: ['id', 'query'],
			autoLoad: true,
			proxy: {
				type: 'ajax',
				url: browser_index,
				actionMethods: 'POST',
				extraParams: {
					caller: 'ajaxGetLastQuery',
				},
				reader: {
					type: 'xml',
					record: 'searchquery'
				}
			}
		});
		crumBar.add([{
			xtype: 'tbtext',
			text: $$('Recent searches')+':'            
		},{
			xtype: 'combo',
			itemId: 'lastquery_id',
			minWidth: 140,
            grow : true,
            growToLongestValue : true,
			editable: false,
			store : store_lastqueries,
			queryMode: 'local',
			displayField: 'id',
			valueField: 'id',
			emptyText: $$('Select a search')+'...',
			listeners: {
				change: viewQuery
			}
		},{
			xtype: 'tbtext',
			text: $$('Saved searches')+':'            
		},{
			xtype: 'combo',
			itemId: 'savedquery_id',
			width: 140,
			editable: false,
			store : store_savedqueries,
			queryMode: 'local',
			displayField: 'id',
			valueField: 'id',
			emptyText: $$('Select a search')+'...',
			listeners: {
				change: viewQuery
			}
		},{
			xtype: 'button',
			iconCls: 'tbar-rem',
			text:  $$('Delete'),
			listeners: {
				click: function(combobox) {
					var cb = this.up().down('combo[itemId=savedquery_id]');
					var id = cb.getValue();
					if (id) {
						Ext.Msg.confirm($$('Alert'), $$('Do you really want to delete this search?'), function(btn, name){
							if (btn == 'yes'){
								Ext.Ajax.request({
									url: browser_index,
									method: 'POST',
									params: { 
										caller: 'ajaxDeleteQuery',
										queryname: id
									},
									scope: this,
									failure: function(){
										extAlert(1,'Could not connect to server');
									}, 
									success:function(response, options) {
										var xmldata = response.responseXML;
										cb.getStore().loadRawData(xmldata);
										cb.reset();
									}
								});
							}
						});                        
					} else {
						Ext.MessageBox.alert($$('Note'), $$('Please select a saved search.'));
					}
				}
			}
		}]);
		workmodus.value = 'search';
        document.windowForm.workmodus.value = 'search'
	} else {
        if ( btn ) btn.setVisible(true);
        if ( mnu ) mnu.setVisible(true);
		Ext.each(panel_tree.getDockedItems('SearchToolbar'), function(tb) {
			panel_tree.removeDocked(tb);
		});
		// for paging set back to first page
		store_tree.currentPage = 1;
		if ( mode == 'store_load' ) {
            store_tree.proxy.extraParams = {
                    caller: 'changeDir',
                    procedure: '',
                    node: store_tree.currentUrl
            };
            store_tree.load();
		}
		workmodus.toggle(false);
		workmodus.value = 'browse';
        document.windowForm.workmodus.value = 'browse'
	}
	if ( treeType == 'AsxTree' ) {
		store_gallery.removeAll();
		store_preview.removeAll();
		panel_meta.myRemoveall();
	}
}
// execute the search
function doSearch() {
    var contains_flag = false;
    var isWord_flag   = false;
    var query_part = [];
    var name_part  = [];
    var ary = panel_tree.getDockedItems('SearchToolbar');
    for (var i in ary) {
        var thisField = ary[i].getComponent('field_id');
        var id        = thisField.getValue();
        var record    = store_searchfields.getById(id);
        var type      = record.get('type');

        var field    = ary[i].getComponent('field_id').getValue();
        if (field.search('x_') == 0 ) {
            var field = field.substr(2);
        }
        var query    = ary[i].getComponent('query_id').getValue();
        var value    = ary[i].getComponent('value_id').getValue();

        if ( value == '' || typeof value == 'undefined' ) continue;

        if ( type == 'date' ) {
            var start = Ext.Date.format(value, 'U');
            var end   = parseInt(start) + (24 * 3600);
            if ( query == '==' ) {
                var part = field + ' > ' + start + ' && ' + field + ' < ' + end ;
            } else if ( query == '><' ) {
                var unit  = ary[i].getComponent('units_id').getValue();
                var mult  = parseInt(value) * parseInt(unit)
                var zero  = Ext.Date.format(new Date(), "m/d/Y");
                var end   = Ext.Date.format(new Date(zero), 'U');
                var start = parseInt(end) - (mult * 24 * 3600);
                var part  = field + ' > ' + start + ' && ' + field + ' < ' + end ;
            } else {
                var part = field + ' ' + query  + ' ' + start;
            }
            query_part.push(part);
        } else if ( type == 'int' ) {
            var unit = ary[i].getComponent('units_id').getValue();
            var mult = parseInt(value) * parseInt(unit)
            var part = field + ' ' + query  + ' ' + mult;
            query_part.push(part);
        } else {
            if ( query == '=*' ) var contains_flag = true;
            // search for words in filename 
            if ( field == 'name' && query == '*=' ) {
                name_part.push(value);
                var isWord_flag = true;
            } else {
                var part = field + ' ' + query  + ' ' + '{'+value+'}';
                query_part.push(part);
            }
        }
    }
    // add word search to query
    if ( name_part != '' ) {
        var name_query = 'name' + ' *= ' + '{'+name_part.join(' ')+'}';
        query_part.push(name_query);
    }
    // for paging set back to first page
    store_tree.currentPage = 1;
    if ( query_part != '' ) {
        // get entire query to cache in session
        var query_obj = buildQueryObj();
        store_tree.currentQuery = query_part;
        store_tree.proxy.extraParams = {
                caller: 'ajaxSearch',
                node: store_tree.searchUrl,
                query: Ext.encode(query_part),
                queryobj: Ext.encode(query_obj)
        };
        store_tree.load(function(records, operation, success) {
            // reload last query store
            store_lastqueries.load();
        }); 
        var msg2 = $$("Please wait until it is finished.")
        if (contains_flag && !isWord_flag) {
            var msg1 = $$("A 'contains string' query may take a long time to complete.")
            showToast($$('Warning'), msg1+'<br>'+msg2);
        }
		if ( rootUrl != store_tree.searchUrl ) {
            var msg1 = $$("A positional search may take a long time.")
            showToast($$('Warning'), msg1+'<br>'+msg2);
        }
    }
}
// build entire query to store it on server side
function buildQueryObj() {
	var ary = panel_tree.getDockedItems('SearchToolbar');
	var query_obj = {};
	for (var i in ary) {
		query_obj[i] = {};
		ary[i].items.each(function(item){
			var fieldtype = item.getXType();
			switch (fieldtype) {
			case "fieldName":
			case "stringOper":
			case "metaOper":
			case "dateOper":
			case "dateFeld":
			case "numberOper":
			case "sizeOper":
			case "stringField":
			case "sizeUnits":
			case "daysUnits":
			case "dropMenu":
			case "matchOper":
			case "fileFolderField":
				var itemId = item.getItemId();
				query_obj[i][itemId] = {};
				query_obj[i][itemId]['xtype'] = fieldtype;
				query_obj[i][itemId]['value'] = item.getValue();
				break;
			default:
				break;
			}
		});
	}
	return query_obj;
}
//save search query
function saveQuery() {
    var query_obj = buildQueryObj();
	Ext.Msg.prompt($$('Save Search Query'), $$('Please enter a name'), function(btn, queryname){
		if (btn == 'ok'){
			//var queryname = window.btoa(name)
			Ext.Ajax.request({
				url: browser_index,
				method: 'POST',
				params: { 
					caller: 'ajaxSaveQuery',
					query: Ext.encode(query_obj),
					queryname: queryname
				},
				scope: this,
				failure: function(){
					extAlert(1,'Could not connect to server');
				}, 
				success:function(response, options) {
					var xmldata = response.responseXML;
					var cb = crumBar.down('combo[itemId=savedquery_id]');
            		cb.getStore().loadRawData(xmldata);
            		cb.reset();
            		cb.setValue(queryname);
				}
			});
		}
	});                        
}
// build the query in GUI
function viewQuery(combobox) {
    var id = combobox.getValue();
    if (id) {
        var record = combobox.getSelectedRecord();
        var query  = record.get('query');
        var query_obj = Ext.decode(query);						
        // delete the current search tool bars
        Ext.each(panel_tree.getDockedItems('SearchToolbar'), function(tb) {
            panel_tree.removeDocked(tb);
        });
        for (var tbar in query_obj) {
            // create for each entry a toolbar
            var thisTbar  = panel_tree.addDocked({xtype: 'SearchToolbar'})[0];
            // get object access to the stored field properties
            var tbar_obj = query_obj[tbar];
            for (var formfield in tbar_obj) {
                var form_obj = tbar_obj[formfield];
                // console.log(formfield + " = " + form_obj.value);
                // set the value of the combo or text field
                // other properties will be ignored
                var thisField = thisTbar.getComponent(formfield);
                if ( thisField.getXType() == 'dateFeld' ) {
                    thisField.setValue(new Date(form_obj.value));
                } else {
                    thisField.setValue(form_obj.value);
                }
            }
        }
        // show button only on last dock
        panel_tree.showButtonOnlyLastDocked();
        // start search
        if(thisTbar) thisTbar.getComponent('find_id').fireEvent('click');
    }
}
//add item to selection
function inBasket() {
	getSelctedIndexItems()
	if ( numberElements == 0 ) {
		alert(document.msgForm.jsmsg1.value)
		return 0
	}
	selectionWindow();
	store_selection.load({
		params: {
			caller: 'ajaxSelection',
			procedure: 'inBasket',
			selectedelements: Ext.encode(selectedelements)
		}
	});
}
//remove item from selection
function outBasket(grid) {
	numberElements   = 0;
	selectedelements = [];
	var selection    = grid.getSelectionModel().getSelection();
	Ext.iterate(selection, function(obj, index) {
		var elm = obj.get('id');
		selectedelements.push(elm);
		numberElements++
	});
	if ( numberElements == 0 ) {
		alert(document.msgForm.jsmsg1.value)
		return 0
	}
	store_selection.load({
		params: {
			caller: 'ajaxSelection',
			procedure: 'outBasket',
			selectedelements: Ext.encode(selectedelements)
		}
	});

}
//start restore or archive process from selection
function doSelection(elementType,aktion) {
	win = window.open("", client[elementType][aktion].target, client[elementType][aktion].wsize);
	win.focus();
	winOpenClose(win);
	document.windowForm.action = document.urls.elements[aktion].value;
	document.windowForm.elementCall.value  = aktion;
	document.windowForm.target = client[elementType][aktion].target;
	document.windowForm.submit();
}
function restoreVersion(grid) {
	popupHide();
	var elementType  = treeType;
	var aktion       = 'dialog_restore';
	numberElements   = 0;
	selectedelements = [];
	var selection    = grid.getSelectionModel().getSelection();
	Ext.iterate(selection, function(obj, index) {
		var elm = obj.get('id');
		selectedelements.push(elm);
		numberElements++
	});
	if ( checkForSingle() == 0 ) return
	win = window.open("", client[elementType][aktion].target, client[elementType][aktion].wsize);
	win.focus();
	winOpenClose(win);
	document.windowForm.action = document.urls.elements[aktion].value;
	document.windowForm.elementCall.value  = aktion;
	document.windowForm.target = client[elementType][aktion].target;
	document.windowForm.elementurl.value = Ext.encode(selectedelements);
	document.windowForm.submit();
}
function pageReload() {
	//remove fix bottom bar as div element because it is not controlled by EXT
	rmDiv('wstreebody');
	rmDiv('loaderdiv');
	rmDiv('fixButton');
	//if (Ext.getCmp('selection_id')) Ext.getCmp('selection_id').destroy();
	Ext.getCmp('centercenter').removeAll();
	waitBox('centerdata');
	Ext.get('centerdata').load({
		url:browser_index,
		scripts:true,
		success: function(){
			hideWait();
		},
		failure: function(){
			extAlert(1,'Could not connect to server')
		}, 
		params:{
			caller: 'volumenListing',
			dbusage: dbusage,
			operation: dboper,
			elementurl: rootUrl,
			elementtxt: rootText
		}
	});
}
//reload on session expired
function testSession(req, res) {
	// test if document has xml mime type
	if (!req.getOperation().success) {
		alert($$('Server session has expired.'))
		parent.location.href='/login/logout'
	}
}
//example of an iframe window
function openWindow2(elementType, elementurl) {
	if ( client[elementType] && client[elementType].open ) {
		new Ext.Window({
			title : "iframe",
			width : 600,
			height: 600,
			layout : 'fit',
			border: false,
			items : [{
				xtype : "component",
				autoEl : {
					tag : "iframe",
					name : client[elementType].open.target
				}
			}]
		}).show();
		document.hammerForm.elementType.value = elementType;
		document.hammerForm.elementCall.value = "open";
		document.hammerForm.elementurl.value  = elementurl;
		document.hammerForm.target            = client[elementType].open.target;
		document.hammerForm.submit();
	} else {
		alert(document.msgForm.jsmsg10.value + ': ' +elementType)
	}
}
// open user application workmodus.value
var userappwin = null;
function openUserapp(elementType, elementurl) {
	var node = escape(elementurl)
    var url = document.hammerForm.userapp.value + '?urlcaller=restore&modus=' + workmodus.value + '&elementurl=' + node
    if ( document.hammerForm.treeType.value == 'AsxTree' ) {
        userappwin = window.open(url,"userapp","height=750,width=620,scrollbars=auto,resizable,status");
    } else {
        userappwin = window.open(url,"userapp","height=380,width=620,scrollbars=auto,resizable,status");
    }
    userappwin.focus();
}
function fileProc(aktion) {
    getCheckedElements()
    if ( checkForSingle() == 0 ) return
    if ( !client[elementType] ) {
        alert(document.msgForm.jsmsg11.value)
        return
    }
	var node = escape(elementurl)
	var url = document.hammerForm.userapp.value + '?urlcaller=restore&modus=' + workmodus.value + '&elementurl=' + node
    if ( document.hammerForm.treeType.value == 'AsxTree' ) {
        userappwin = window.open(url,"userapp","height=750,width=620,scrollbars=auto,resizable,status");
    } else {
        userappwin = window.open(url,"userapp","height=380,width=620,scrollbars=auto,resizable,status");
    }
    userappwin.focus();
}

