Ext.define('P5Jobmanager.view.MainViewViewModel', {
    extend: 'Ext.app.ViewModel',
    alias: 'viewmodel.mainview',

    requires:[
        'P5Jobmanager.model.ClientListing',
        'P5Jobmanager.model.JobmonitorListing',
        'P5Jobmanager.model.JoblogListing'
    ],

    data:{
        servertime: '',
        clockStyle: 'color:#d4d3d3'
    },

    stores: {
        clientstore: {
            model: 'P5Jobmanager.model.ClientListing',
            autoLoad: true,
            listeners: {
                load: 'onclientStoreLoad'
            }
        },
        jobmonitorstore: {
            model: 'P5Jobmanager.model.JobmonitorListing',
            autoLoad: false,
            listeners: {
                load: 'onJobmonitorStoreLoad'
            }
        },
        runningjobsstore: {
            source: '{jobmonitorstore}',
            sorters: [{
                property: 'start',
                direction: 'ASC'
            }],
            filters: {
                property: 'status', operator: '!=', value: 'scheduled'
            }
        },
        scheduledqueuestore: {
            source: '{jobmonitorstore}',
            sorters: [{
                property: 'jobid',
                direction: 'ASC'
            }],
            filters: [{
                property: 'status', value: 'scheduled'
            }]
        },
        joblogstore: {
            model: 'P5Jobmanager.model.JoblogListing',
            autoLoad: false,
            remoteSort: true,
            pageSize: 10,
            sorters: [{
                property: 'timeCompleted',
                direction: 'DESC'
            }],
            listeners: {
                load: 'onJoblogStoreLoad',
            }
        }
    },
    formulas: {
        isAjobMonitorChecked: {
            single: true,
            get: function(get) {
                return ( !get('anyJobMonitor_ref.checked') && !get('archiveJobMonitor_ref.checked') && !get('backupJobMonitor_ref.checked') && !get('restoreJobMonitor_ref.checked') && !get('syncJobMonitor_ref.checked') && !get('othersJobMonitor_ref.checked') ) ? true : false
            }
        },
        isAnyJobMonitor: {
            get: function(get) {
                return ( !get('anyJobMonitor_ref.checked') ) ? false : true
            }
        },
        isArchiveJobMonitor: {
            get: function(get) {
                return ( !get('anyJobMonitor_ref.checked') && get('archiveJobMonitor_ref.checked') ) ? false : true
            }
        },
        isBackupJobMonitor: {
            get: function(get) {
                return ( !get('anyJobMonitor_ref.checked') && get('backupJobMonitor_ref.checked') ) ? false : true
            }
        },
        isRestoreJobMonitor: {
            get: function(get) {
                return ( !get('anyJobMonitor_ref.checked') && get('restoreJobMonitor_ref.checked') ) ? false : true
            }
        },
        isSyncJobMonitor: {
            get: function(get) {
                return ( !get('anyJobMonitor_ref.checked') && get('syncJobMonitor_ref.checked') ) ? false : true
            }
        },
        isOthersJobMonitor: {
            get: function(get) {
                return ( !get('anyJobMonitor_ref.checked') && get('othersJobMonitor_ref.checked') ) ? false : true
            }
        },
    }
});
