Ext.define('P5Jobmanager.view.MainViewViewController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.mainview',
    init: function() {
 		var me = this;
        me.control({
            '#scheduledjobsgrid_id': {
                render: function(a,b,c) {
                    console.log('scheduledjobsgrid_id ready');
                }
            },
            '#jobmonitorgrids_id': {
                render: function(a,b,c) {
                    console.log('jobmonitorgrids_id ready');
                    var viewModel = me.getViewModel();
                    viewModel.getStore('jobmonitorstore').load();
                    viewModel.bind('{isAjobMonitorChecked}', function(allUnChecked) {
                        if ( allUnChecked ) me.lookupReference('anyJobMonitor_ref').setValue(true);
                    });
                }
            },
            '#jobloggrid_id': {
                viewready: function(a,b,c) {
                    console.log('jobloggrid_id ready');
                    var viewModel = me.getViewModel();
                    viewModel.getStore('joblogstore').load();
                }
            },
            'jobtypegrid': {
                viewready: function(grid,b,c) {
                    console.log('jobtypegrid ready');
                    grid.getSelectionModel().select(0);
                },
                selectionchange: me.onJobTypeSelect
            },
            'clientgrid': {
                selectionchange: me.onClintSelect
            }
        });    
    },
    onclientStoreLoad: function( store, records, successful, eOpts ) {
 		var me = this;
        console.log('clientStore loaded');
        var grid = me.lookupReference('clientgrid_ref');
        grid.getSelectionModel().select(0);
    },    
    onJobmonitorStoreLoad: function( store, records, successful, eOpts ) {
 		var me = this;
        //console.log('Job monitor store loaded: '+successful);
        var viewModel = me.getViewModel();
        if ( successful ) {
            viewModel.set("clockStyle",'color:#5EC53A');
            var json = eOpts.getResponse().responseJson;
            var msec  = new Date(json.clocksec*1000);
            var clocl = Ext.Date.format(msec, Ext.Date.patterns['formatTimeLong']);
            viewModel.set("servertime",clocl);
            me.startStopJobmonitorstoreReload(5000);
        } else {
            viewModel.set("clockStyle",'color:#d4d3d3');
        }
    },    
    startStopJobmonitorstoreReload: function(interval) {
        me = this;
        var viewModel = me.getViewModel();
        clearTimeout(P5Jobmanager.globals.jobmonitorstoreLoop);
        P5Jobmanager.globals.jobmonitorstoreLoop = null;
        //console.log('Starting frequently update for job monitor store');
        P5Jobmanager.globals.jobmonitorstoreLoop = setTimeout(function(){
            var upd_store = me.getView().getViewModel().getStore('jobmonitorstore');
            if (!P5Jobmanager.globals.attention) upd_store.reload();
        },interval);
    },
    onJoblogStoreLoad: function( store, records, successful, eOpts ) {
 		var me = this;
        //console.log('Job log store loaded');
        if ( successful ) me.startStopJoblogstoreReload(5000);
    },    
    startStopJoblogstoreReload: function(interval) {
        me = this;
        clearTimeout(P5Jobmanager.globals.joblogstoreLoop);
        P5Jobmanager.globals.joblogstoreLoop = null;
        //console.log('Starting frequently update for job log store');
        P5Jobmanager.globals.joblogstoreLoop = setTimeout(function(){
            var upd_store = me.getView().getViewModel().getStore('joblogstore');
            if (!P5Jobmanager.globals.attention) upd_store.reload();
        },interval);
    },
    startStopReload: function( event, interval ) {
        if (event && event.altKey) {
            console.log('Stop polling');
            clearTimeout(P5Jobmanager.globals.jobmonitorstoreLoop);
            clearTimeout(P5Jobmanager.globals.joblogstoreLoop);
        } else {
            console.log('Starting frequently update');
            me.startStopJobmonitorstoreReload(interval);
            me.startStopJoblogstoreReload(interval);
        }
    },    
    onMonitorgridReload: function(grid, tool, event) {
        me = this;
        console.log('onMonitorgridReload');
        var mgrid = Ext.ComponentQuery.query('#anyjobmonitorgrid_id')[0];
        var store = mgrid.getStore();
        store.reload();
    },
    onContextMenuQueued: function(view, rowIndex, collIndex, item, theEvent, record, htmlRow) {
        me = this;
        var menu = view.myMenu;
        if (!menu) {
            menu = view.myMenu = Ext.widget('menu', {
                controller: 'mainview',
                items: [{
                    iconCls: 'x-fa fa-refresh signgreen',
                    text: $$('Start now'),
                    handler: function(btn) {
                        me.onStartNow(view);
                    }
                },{
                    iconCls: 'x-fa fa-ban signred',
                    text: $$('Cancel'),
                    handler: function(btn) {
                        me.onCancelNow(view);
                    }
                }]
            });
        }
        menu.showAt(theEvent.getXY());
    },
    onContextMenuRunning: function(view, rowIndex, collIndex, item, theEvent, record, htmlRow) {
        me = this;
        var menu = view.myMenu;
        if (!menu) {
            menu = view.myMenu = Ext.widget('menu', {
                controller: 'mainview',
                items: [{
                    iconCls: 'x-fa fa-ban signred',
                    text: $$('Stop'),
                    handler: function(btn) {
                        me.onCancelNow(view);
                    }
                }]
            });
        }
        menu.showAt(theEvent.getXY());
    },
    onOpenJobLog: function(view, rowIndex, collIndex, item, theEvent, record, htmlRow) {
        me = this;
        console.log('onOpenJobLog');
        me.onOpenMonitor(record.get('name'));
    },
    onOpenJobLogRow: function(view, record, item, index, e) {
        me = this;
        console.log('onOpenJobLogRow');
        me.onOpenMonitor(record.get('name'));
    },
    onOpenMonitor: function(job) {
        var elementType  = 'Job'
        win = window.open("", client[elementType].open.target, client[elementType].open.wsize);
        win.focus();
        win.document.open();
        win.document.close();
        document.hammerForm.selected.value    = job;
        document.hammerForm.elementType.value = elementType;
        document.hammerForm.elementCall.value = "open";
        document.hammerForm.elementurl.value  = '';
        document.hammerForm.target            = client[elementType].open.target;
        document.hammerForm.submit();
    },
    onStartNow: function(view) {
        console.log('onStartNow');
        var selectedRecord = view.getSelectionModel().getSelection()[0];
        var myid = selectedRecord.get('id');
        var job  = selectedRecord.get('jobid');
        Ext.Msg.show({
            title: $$('Confirm Job Start'),
            width: 360,
            message: $$('Do you really want to start this job now?'),
            buttons: Ext.Msg.YESNO,
            buttonText:{ 
                yes: $$('Start now'), 
                no: $$('No') 
            },
            icon: Ext.Msg.QUESTION,
            fn: function(btn) {
                if (btn === 'yes' ) {
                    Ext.Ajax.request({
                        waitMsg: $$('Starting job ...'),
                        url: P5Jobmanager.globals.serverpage,
                        method: 'GET',
                        params: {
                            tdp: 'jobcontrol',
                            caller: 'ajaxStartJob',
                            myid: myid,
                            job: job
                        },
                        success: function(result, request) {
                            var json = Ext.decode(result.responseText);
                            extAlert(json.attention,json.message);
                            me.startStopReload(0,1000);
                        },
                        failure: function(result, request) {
                            Ext.MessageBox.alert('Failed', result.responseText);
                        }
                    });
                }
            }
        });
    },
    onCancelNow: function(view) {
        me = this;
        console.log('onCancelNow');
        var selectedRecord = view.getSelectionModel().getSelection()[0];
        var myid = selectedRecord.get('id');
        var job  = selectedRecord.get('jobid');
        Ext.Msg.show({
            title: $$('Confirm Job Cancellation'),
            width: 360,
            message: $$('Do you really want to stop/cancel this job?'),
            buttons: Ext.Msg.YESNO,
            buttonText:{ 
                yes: $$('Stop/Cancel'), 
                no: $$('No') 
            },
            icon: Ext.Msg.QUESTION,
            fn: function(btn) {
                if (btn === 'yes' ) {
                    Ext.Ajax.request({
                        waitMsg: $$('Canceling job ...'),
                        url: P5Jobmanager.globals.serverpage,
                        method: 'GET',
                        params: {
                            tdp: 'jobcontrol',
                            caller: 'ajaxCancelJob',
                            myid: myid,
                            job: job
                        },
                        success: function(result, request) {
                            var json = Ext.decode(result.responseText);
                            extAlert(json.attention,json.message);
                            me.startStopReload(0,1000);
                        },
                        failure: function(result, request) {
                            Ext.MessageBox.alert('Failed', result.responseText);
                        }
                    });
                }
            }
        });
    },
    onRowbodyclick: function(view, rowEl, e, eOpts) {
        var me = this;
        console.log('onRowbodyclick');
        var viewModel = me.getViewModel();
        var job_store = viewModel.getStore('jobmonitorstore');
        var itemEl = Ext.get(rowEl).up(view.itemSelector);
        var record = view.getRecord(itemEl);
        var jobid  = record.get('id');

        // incase jobid is the same close the long report
        // if ( jobid == P5Jobmanager.globals.jobid ) jobid = null;
        // P5Jobmanager.globals.jobid = jobid;

        var idx = P5Jobmanager.globals.jobid.indexOf(jobid);
        if ( idx > -1 ) {
            P5Jobmanager.globals.jobid.splice(idx, 1);
        } else {
            P5Jobmanager.globals.jobid.push(jobid);
        }
        job_store.reload();
    },    
    onJobTypeSelect: function(view, selections, options) {
        var me = this;
        var viewModel = me.getViewModel();
        var job_store = viewModel.getStore('jobmonitorstore');
        var log_store = viewModel.getStore('joblogstore');
        if (selections.length < 1) return;
        var jtype = selections[0].get('id')
        job_store.removeFilter('jtype')
        log_store.removeFilter('jtype')
        // switch of filter with 'any"
        if ( jtype == 'any' ) return;
        job_store.addFilter({
            id: 'jtype',
            property: 'jtype',
            value: jtype
        });
        log_store.addFilter({
            id: 'jtype',
            property: 'jtype',
            value: jtype
        });
    },
    onClintSelect: function(view, selections, options) {
        var me = this;
        var viewModel = me.getViewModel();
        var job_store = viewModel.getStore('jobmonitorstore');
        var log_store = viewModel.getStore('joblogstore');
        if (selections.length < 1) return;
        var client = selections[0].get('id')
        job_store.removeFilter('client')
        log_store.removeFilter('client')
        // switch of filter with 'any"
        if ( client == 'any' ) return;
        job_store.addFilter({
            id: 'client',
            property: 'client',
            value: client
        })
        log_store.addFilter({
            id: 'client',
            property: 'client',
            value: client
        })
    },
    onToggelLegacyView: function(chkbox ,newValue , oldValue , eOpts ) {
        me = this;
        console.log('onToggelLegacyView');
        var thisForm = chkbox.up('form').getForm()
        thisForm.submit({
            url: P5Jobmanager.globals.serverpage,
            submitEmptyText: false,
            target : '_top',
            standardSubmit: true,
            params: {
                tdp: 'jobcontrol',
                caller: 'ajaxSwitchToLegacyView'
            }
        });
    }
});
