Ext.define("P5Jobmanager.view.JobmonitorGrids", {
    extend: 'Ext.panel.Panel',
    alias: "widget.jobmonitorgrids",

    reference: 'jobmonitorgrids_ref',
    itemId: 'jobmonitorgrids_id',
    
    layout: {
        type: 'hbox',
        pack: 'start',
        align: 'stretch'
    },
    
    border: false,
    
    items: [{
        //title: $$('All Running Jobs'),
        xtype: 'anymonitorgrid',
        flex: 1,
        bind: { hidden: '{!anyJobMonitor_ref.checked}' }
    }]
});
// Any Any Any Any Any Any Any Any Any Any Any Any Any
Ext.define("P5Jobmanager.view.AnyMonitorGrid", {
    extend: 'Ext.grid.Panel',
    alias: "widget.anymonitorgrid",

    bind:{
        store: '{runningjobsstore}'
    },
    reference: 'anyjobmonitorgrid_ref',
    itemId: 'anyjobmonitorgrid_id',

    viewConfig: {
        loadMask: false,
        preserveScrollOnReload: true,
        preserveScrollOnRefresh: true,
        getRowClass: function() { 
            return 'bold-row'; 
        } 
    
    },

    border: false,

    columns: [{
        xtype: 'actioncolumn',
        dataIndex: 'state',
        stopSelection: false,
        align: 'center',
        text: '',
        menuDisabled : true,
        width: 30,
        handler: 'onContextMenuRunning',
        //iconCls: 'runicon'
        renderer: function(value,metaData,record) {
            switch(value) {
                case 'transit':
                    metaData.tdCls = 'job-transit tcl-icon';
                    break;
                default:
                    metaData.tdCls = 'backingup-icon';
            }
        }
    },{
        dataIndex: 'jtype',
        align: 'center',
        text: '',
        menuDisabled : true,
        width: 22,
        renderer: function(value,metaData,record) {
            switch(value) {
                case 'archivejob':
                    metaData.tdCls = 'archivejob-icon';
                    break;
                case 'backupjob':
                    metaData.tdCls = 'backupjob-icon';
                    break;
                case 'backup2gojob':
                    metaData.tdCls = 'backup2gojob-icon';
                    break;
                case 'syncjob':
                    metaData.tdCls = 'syncjob-icon';
                    break;
                case 'migrationjob':
                    metaData.tdCls = 'migrationjob-icon';
                    break;
                case 'restorejob':
                    metaData.tdCls = 'restorejob-icon';
                    break;
                default:
                    metaData.tdCls = 'otherjob-icon';
            }
        }
    },{ text: $$('Plan Name/Operation'), dataIndex: 'text', width: 200
    },{ text: $$('Client'), dataIndex: 'client', width: 80
    },{ text: $$('User'), dataIndex: 'owner', width: 80
    },{ text: $$('Level'), dataIndex: 'level', width: 60
    },{ 
        text: $$('Start Time'),
        dataIndex: 'start',
        width: 90,
        xtype: 'datecolumn',
        format: Ext.Date.patterns['formatTimeShort']
    },{
        text: $$('Job'),
        dataIndex: 'jobid',
        flex: 1
    }],
    features: [{
        ftype: 'rowbody',
        getAdditionalData: function (data, idx, record, orig) {
            var caret = ( record.get('id') == P5Jobmanager.globals.jobid )  ? "x-fa fa-caret-down":"x-fa fa-caret-right";
            return {
                rowBodyCls: "my-body-class",
                rowBody: '<div id="rowBodywrapper"><div id="first" class="'+caret+'"></div><div id="second">'+record.get('shownreport')+'</div></div>',
            };
        }
    }],
    listeners: {
        rowbodyclick: 'onRowbodyclick'
    }
});
