Ext.define("P5Jobmanager.model.JoblogListing", {
    extend: "Ext.data.Model",
    idProperty: "id",
    schema: {
        namespace: "P5Jobmanager.model"
    },

    fields: [{
        name: 'id',
        type: 'string'
    },{
        name: 'name',
        type: 'string'
    },{
        name: 'noticed',
        type: 'string'
    },{
        name: 'returnStr',
        type: 'string'
    },{
        name: 'client',
        type: 'string'
    },{
        name: 'owner',
        type: 'string'
    },{
        name: 'timeStarted',
        type: 'date',
        dateFormat: 'U'
    },{
        name: 'timeCompleted',
        type: 'date',
        dateFormat: 'U'
    },{
        name: 'duration',
        type: 'number'
    },{
        name: 'numKbytes',
        type: 'number'
    },{
        name: 'pool',
        type: 'string'
    },{
        name: 'level',
        type: 'string'
    },{
        name: 'jtype',
        type: 'string'
    },{
        name: 'text',
        type: 'string'
    }],
    proxy:{
        type:'ajax',
        url: P5Jobmanager.globals.serverpage,
        actionMethods:{
             read:'GET'
        },
        extraParams: {
            tdp: 'jobmonitor',
            caller: 'ajaxGetJoblog',
        },
        reader:{
            type:'json',
            rootProperty:'data'
        }
    }
});