Ext.define('P5Jobhistory.view.MainViewViewModel', {
    extend: 'Ext.app.ViewModel',
    alias: 'viewmodel.mainview',

    requires:[
        'P5Jobhistory.model.ClientListing',
        'P5Jobhistory.model.JoblogListing'
    ],

    data:{
        servertime: '',
        clockStyle: 'color:#d4d3d3',
        pageSize: 50,
        showEnterDate: false
    },

    stores: {
        clientstore: {
            model: 'P5Jobhistory.model.ClientListing',
            autoLoad: true,
            listeners: {
                load: 'onclientStoreLoad'
            }
        },
        joblogstore: {
            model: 'P5Jobhistory.model.JoblogListing',
            autoLoad: false,
            remoteSort: true,
		    remoteFilter: true,
            sorters: [{
                property: 'timeCompleted',
                direction: 'DESC'
            }]
        }

    },
    formulas: {
        enterDateHidden: function (get) {
            if ( get('showEnterDate') ) {
                return false;
            } else {
                return true;
            }
        }
    }
});
