Ext.define('P5Jobhistory.view.MainViewViewController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.mainview',
    init: function() {
 		var me = this;
 		me.filterObj = [];
 		me.filterAry = [];
        me.control({
            'periodgrid': {
                viewready: function(grid,b,c) {
                    console.log('periodgrid ready');
                    var viewModel = me.getViewModel();
                    var store = grid.getStore();
                    var value = Ext.state.Manager.get('preSelDateID','12hour');
                    var idx = store.findRecord('id', value);
                    grid.getSelectionModel().select(idx,false,true);
                    if ( value == 'enterDate' ) {
                        viewModel.set('showEnterDate',true);
                        var fromDate  = Ext.state.Manager.get('fromDateState','');
                        var toDate    = Ext.state.Manager.get('toDateState','');
                        var fd = Ext.Date.format(fromDate, Ext.Date.patterns['formatDateInt'])
                        var td = Ext.Date.format(toDate, Ext.Date.patterns['formatDateInt'])
                        Ext.ComponentQuery.query('#fromDate_id')[0].setRawValue(fd);
                        Ext.ComponentQuery.query('#toDate_id')[0].setRawValue(td);
                        me.filterObj.push({ id: 'preSelDateFrom',property: 'preSelDateFrom', value: fd });
                        me.filterObj.push({ id: 'preSelDateTo',property: 'preSelDateTo', value: td });
                    }
                    me.onFilterGridReady('preSelDate',value);
                },
                selectionchange: me.onJobPeriodeSelect
            },
            '#fromDate_id': {
                change: me.onFromDateChange
            },
            '#toDate_id': {
                change: me.onToDateChange
            },
            'resultgrid': {
                viewready: function(grid,b,c) {
                    console.log('resultgrid ready');
                    var store = grid.getStore();
                    var value = Ext.state.Manager.get('jobResultID','any');
                    var idx = store.findRecord('id', value);
                    grid.getSelectionModel().select(idx,false,true);
                    me.onFilterGridReady('jobResult',value);
                },
                selectionchange: me.onJobResultSelect
            },
            'jobtypegrid': {
                viewready: function(grid,b,c) {
                    console.log('jobtypegrid ready');
                    var store = grid.getStore();
                    var value = Ext.state.Manager.get('jobtypeID','any');
                    var idx = store.findRecord('id', value);
                    grid.getSelectionModel().select(idx,false,true);
                    me.onFilterGridReady('jtype',value);
                },
                selectionchange: me.onJobTypeSelect
            },
            'clientgrid': {
                selectionchange: me.onClintSelect
            }
        });    
    },
    onFilterGridReady: function(filter,value) {
        me = this;
        me.filterAry.push(filter);
        me.filterObj.push({
            id: filter,
            property: filter,
            value: value
        });
        var ary = me.filterAry;
        // when all filters are loaded the logs are loaded
        if (ary.includes('preSelDate') && ary.includes('jobResult') && ary.includes('jtype') && ary.includes('client')) {
            var viewModel = me.getViewModel();
            var log_store = viewModel.getStore('joblogstore');
            var pageSize  = Ext.state.Manager.get('pageSize',50);
            viewModel.set('pageSize',pageSize);
            log_store.setPageSize(pageSize);
            log_store.addFilter(me.filterObj);
            log_store.load();
        }
    },    
    onclientStoreLoad: function( store, records, successful, eOpts ) {
 		var me = this;
        console.log('clientStore loaded');
        var grid = me.lookupReference('clientgrid_ref');
        var value = Ext.state.Manager.get('clientID','any');
        var idx = store.findRecord('id', value);
        grid.getSelectionModel().select(idx,false,true);
        me.onFilterGridReady('client',value);
    },    
    onOpenJobLog: function(view, rowIndex, collIndex, item, theEvent, record, htmlRow) {
        me = this;
        console.log('onOpenJobLog');
        me.onOpenLog(record.get('name'));
    },
    onOpenJobLogRow: function(view, record, item, index, e) {
        me = this;
        console.log('onOpenJobLogRow');
        me.onOpenLog(record.get('name'));
    },
    onOpenLog: function(job) {
        var elementType  = 'Job'
        win = window.open("", client[elementType].open.target, client[elementType].open.wsize);
        win.focus();
        win.document.open();
        win.document.close();
        document.hammerForm.selected.value    = job;
        document.hammerForm.elementType.value = elementType;
        document.hammerForm.elementCall.value = "open";
        document.hammerForm.elementurl.value  = '';
        document.hammerForm.target            = client[elementType].open.target;
        document.hammerForm.submit();
    },
    onJobPeriodeSelect: function(view, selections, options) {
        var me = this;
        var viewModel = me.getViewModel();
        var log_store = viewModel.getStore('joblogstore');
        if (selections.length < 1) return;
        var preSelDate = selections[0].get('id')
        Ext.state.Manager.set('preSelDateID',preSelDate);
        if ( preSelDate == 'enterDate' ) {
            viewModel.set('showEnterDate',true);
        } else {
            viewModel.set('showEnterDate',false);
            Ext.ComponentQuery.query('#fromDate_id')[0].setRawValue('');
            Ext.ComponentQuery.query('#toDate_id')[0].setRawValue('');
            Ext.state.Manager.clear('fromDateState');
            Ext.state.Manager.clear('toDateState');
            log_store.removeFilter('preSelDateFrom')
            log_store.removeFilter('preSelDateTo')
        }
        log_store.removeFilter('preSelDate')
        log_store.addFilter({
            id: 'preSelDate',
            property: 'preSelDate',
            value: preSelDate
        });
    },
    onFromDateChange: function(picker, newValue, oldValue, eOpts) {
        var me = this;
        Ext.state.Manager.set('fromDateState',newValue);
        var fromDate = Ext.Date.format(newValue, Ext.Date.patterns['formatDateInt'])
        var viewModel = me.getViewModel();
        var log_store = viewModel.getStore('joblogstore');
        log_store.removeFilter('preSelDateFrom')
        log_store.addFilter({
            id: 'preSelDateFrom',
            property: 'preSelDateFrom',
            value: fromDate
        });
    },
    onToDateChange: function(picker, newValue, oldValue, eOpts) {
        var me = this;
        Ext.state.Manager.set('toDateState',newValue);
        var toDate = Ext.Date.format(newValue, Ext.Date.patterns['formatDateInt'])
        var viewModel = me.getViewModel();
        var log_store = viewModel.getStore('joblogstore');
        log_store.removeFilter('preSelDateTo')
        log_store.addFilter({
            id: 'preSelDateTo',
            property: 'preSelDateTo',
            value: toDate
        });
    },
    onJobResultSelect: function(view, selections, options) {
        var me = this;
        var viewModel = me.getViewModel();
        var log_store = viewModel.getStore('joblogstore');
        if (selections.length < 1) return;
        var jobResult = selections[0].get('id')
        Ext.state.Manager.set('jobResultID',jobResult);
        log_store.removeFilter('jobResult')
        log_store.addFilter({
            id: 'jobResult',
            property: 'jobResult',
            value: jobResult
        });
    },
    onJobTypeSelect: function(view, selections, options) {
        var me = this;
        var viewModel = me.getViewModel();
        var log_store = viewModel.getStore('joblogstore');
        if (selections.length < 1) return;
        var jtype = selections[0].get('id')
        Ext.state.Manager.set('jobtypeID',jtype);
        log_store.removeFilter('jtype')
        log_store.addFilter({
            id: 'jtype',
            property: 'jtype',
            value: jtype
        });
    },
    onClintSelect: function(view, selections, options) {
        var me = this;
        var viewModel = me.getViewModel();
        var log_store = viewModel.getStore('joblogstore');
        if (selections.length < 1) return;
        var client = selections[0].get('id')
        Ext.state.Manager.set('clientID',client);
        log_store.removeFilter('client')
        log_store.addFilter({
            id: 'client',
            property: 'client',
            value: client
        })
    },
    onToggelLegacyView: function(chkbox ,newValue , oldValue , eOpts ) {
        me = this;
        console.log('onToggelLegacyView');
        var thisForm = chkbox.up('form').getForm()
        thisForm.submit({
            url: P5Jobhistory.globals.serverpage,
            submitEmptyText: false,
            target : '_top',
            standardSubmit: true,
            params: {
                tdp: 'joblog',
                caller: 'ajaxSwitchToLegacyView'
            }
        });
    }
});
